OwSubLayoutEXTJS = function() {
	var navigationPanelWidth;
	//var navigationPanelResizeURL;
	var navPanel;
	var mainPanel;
	return {
		config : {	},

		init : function() {
			var subLayoutNavigation = document.getElementById('OwSubLayout_NAVIGATION');
			//var subLayoutTable = document.getElementById('OwSubLayout_Div_Panel');
			if (subLayoutNavigation != null) {
				subLayoutNavigation.style.visibility = "visible";
			}
			var subLayoutMain = document.getElementById('OwSubLayout_MAIN');
			if (subLayoutMain != null) {
				subLayoutMain.style.visibility = "visible";
			}
			if (subLayoutNavigation == null || subLayoutMain == null) {
				/*
				 * do nothing, no navigation pane or no OwSubLayout_Div_Panel no split!
				 * @return {TypeName} 
				 */
				return;
			}
			navigationPanelWidth = this.config.m_navigationPanelWidth;
			navigationPanelResizeURL = this.config.m_resizeURL;
			var size = calculateSize();
			navPanel = new Ext.Panel( {
				region : 'west',
				contentEl : 'OwSubLayout_NAVIGATION',
				split : true,
				minSize : 150,
				maxSize : 500,
				width : navigationPanelWidth,
				collapsible : true				
			});
			var mainContent = new Ext.Panel( {
				id : 'mainContentPanel',
				region : 'center',
				contentEl : 'OwSubLayout_MAIN',
				autoscroll : true
			});

			mainPanel = new Ext.Panel( {
				renderTo : 'OwSubLayout_Div_Panel',
				layout : 'border',
				items : [ navPanel, mainContent ],
				height : size[0]
				//,width : size[1]
			});
			var mainId = document.getElementById('OwSubLayout_Div');
			if (mainId) {
				mainId.style.display = "none";
			}
			
		//resize once again because the height can be changed by the new content
		size = calculateSize();		
		mainPanel.setHeight(size[0]);
		mainPanel.doLayout();
			
		mainContent.on('resize',onMainContentPanelResize);
		navPanel.on('resize', onNavigationPanelResize);
		mainPanel.show();
		Ext.EventManager.onWindowResize(onSublayoutResize);
	}
	};//end return
	//------ calculate container size ---
	function calculateSize() {
		//var subLayoutTable = document.getElementById('OwSubLayout_Div_Panel');
		var subLayoutNavigation = document.getElementById('OwSubLayout_NAVIGATION');
		var subLayoutMain = document.getElementById('OwSubLayout_MAIN');
		mainLayout = document.getElementById('OwMainLayout_MAIN');

		//Do not use height of OwSubLayout_Div_Panel -> Causes bug 4872
		//height = subLayoutTable.offsetHeight;//mainLayout.offsetHeight-23;

		//calculate height by 'OwSubLayout_NAVIGATION' and 'OwSubLayout_MAIN'
		//height is the greater value of the offset height
		if(subLayoutMain.offsetHeight > subLayoutNavigation.offsetHeight)
			height = subLayoutMain.offsetHeight;
		else{
			height = subLayoutNavigation.offsetHeight;
			height = height + 26; // add x-panel-header for roll in/out of navigation column
		}

		//handle problem of automatic height resizing by the extJS form elements
		//this problem occures, if standard html elements are rerendered by extJS to extJS form elements
		//this process sometimes starts after current size calculation
		//add 4px for every select element in subLayoutMain
		height = height + (subLayoutMain.getElementsByTagName('select').length * 4) ;		

		if (height < 400) {
			height = 400;
		}

		var width = mainLayout.offsetWidth - 4;
		return [ height, width ];
	}
	//---------on resize------------------
	function onNavigationPanelResize(component, adjWidth, adjHeight, rawWidth, rawHeight) {
		//alert('New width: ' + adjWidth);
		var requestConfig = {
			timeout : 30000,
			//disableCaching : false,
			success : function(o) {

			},
			failure : function(o) {

			}
		};
		shouldNotify = true;
		var postparam = null;
		if (component == navPanel) {

			postparam = Ext.urlEncode( {
				width : adjWidth
			});
		} else {
			shouldNotify = true;
			postparam = Ext.urlEncode( {
				height : adjHeight
			});
		}
		if (shouldNotify) {
			Ext.lib.Ajax.request("POST", navigationPanelResizeURL, requestConfig, postparam);
		}
		size = calculateSize();		
		mainPanel.setHeight(size[0]);
		mainPanel.doLayout();
		
	}
	function onSublayoutResize() {
		mainLayout = document.getElementById('OwMainLayout_MAIN');
		//mainPanel.setWidth(mainLayout.offsetWidth - 4);
		mainPanel.doLayout();
		updateGridComponent();
	}
	function updateGridComponent() {
		grid = Ext.getCmp('owgrid');
		if (grid) {
			gridPanel = document.getElementById('grid-panel');
			grid.setHeight(gridPanel.offsetHeight);
			grid.setWidth(gridPanel.offsetWidth);
		}
	}
	function onMainContentPanelResize() {
		updateGridComponent();
	}
}();