package com.wewebu.ecm.alfresco.ws;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.alfresco.repo.web.scripts.workflow.AbstractWorkflowWebscript;
import org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/**
 *<p>
 * Java backed implementation of a webscript to start new workflows.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public class StartWorkflowWebScript extends AbstractWorkflowWebscript
{
    /* (non-Javadoc)
     * @see org.alfresco.repo.web.scripts.workflow.AbstractWorkflowWebscript#buildModel(org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder, org.springframework.extensions.webscripts.WebScriptRequest, org.springframework.extensions.webscripts.Status, org.springframework.extensions.webscripts.Cache)
     */
    @Override
    protected Map<String, Object> buildModel(WorkflowModelBuilder modelBuilder, WebScriptRequest req, Status status, Cache cache)
    {
        Map<String, String> params = req.getServiceMatch().getTemplateVars();

        // getting task id from request parameters
        String workflowDefinitionId = params.get("workflowDefinitionId");

        try
        {
            WorkflowDefinition workflowDefinition = workflowService.getDefinitionById(workflowDefinitionId);

            JSONObject json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            Map<QName, Serializable> parameters = parseProperties(json, workflowDefinition);

            Map<QName, Serializable> startParameters = new HashMap<QName, Serializable>(parameters);
            NodeRef bpmPackage = this.workflowService.createPackage(null);
            QName bpmPackageProp = QName.createQName("bpm:package", this.namespaceService);
            startParameters.put(bpmPackageProp, bpmPackage);

            WorkflowPath workflowPath = workflowService.startWorkflow(workflowDefinitionId, startParameters);

            // build the model for ftl
            Map<String, Object> model = new HashMap<String, Object>();

            WorkflowInstance workflowInstance = workflowPath.getInstance();

            //            StringBuffer startTaskIds = new StringBuffer();

            //            WorkflowTaskQuery query = new WorkflowTaskQuery();
            //            query.setProcessId(workflowInstance.getId());
            //            query.setTaskState(null);
            //            query.setActive(null);

            //            WorkflowTask startTask = workflowService.getStartTask(workflowInstance.getId());

            //            System.err.println("workflowService class " + workflowService.getClass());
            //            List<WorkflowTask> initialTasks = workflowService.queryTasks(query);
            //            for (WorkflowTask initialTask : initialTasks)
            //            {
            //                //skip the start task
            //                if (!startTask.getId().equals(initialTask.getId()))
            //                {
            //                    try
            //                    {
            //                        System.err.println("Updating task " + initialTask.getId());
            //                        workflowService.updateTask(initialTask.getId(), parameters, null, null);
            //                        startTaskIds.append(" " + initialTask.getId());
            //                    }
            //                    catch (WorkflowException e)
            //                    {
            //                        System.err.println(e.getMessage());
            //                    }
            //                }
            //            }

            //            model.put("startTaskIds", startTaskIds);
            model.put("workflowInstanceId", workflowInstance.getId());
            model.put("workflowDefinitionId", workflowDefinitionId);
            String dmsId = "workspace://SpacesStore/" + bpmPackage.getId();
            model.put("bpmPackage", dmsId);

            return model;
        }
        catch (IOException iox)
        {
            throw new WebScriptException(Status.STATUS_BAD_REQUEST, "Could not read content from request.", iox);
        }
        catch (JSONException je)
        {
            throw new WebScriptException(Status.STATUS_BAD_REQUEST, "Could not parse JSON from request.", je);
        }
    }

    @SuppressWarnings("unchecked")
    private Map<QName, Serializable> parseProperties(JSONObject json, WorkflowDefinition workflowDefinition) throws JSONException
    {
        QName cmPersonClassName = QName.createQName("cm:person", namespaceService);

        Map<QName, Serializable> props = new HashMap<QName, Serializable>();

        // gets the array of properties names
        String[] names = JSONObject.getNames(json);

        if (names != null)
        {
            // array is not empty
            for (String name : names)
            {
                // build the qname of property
                QName key = QName.createQName(name.replaceFirst("_", ":"), namespaceService);
                Object jsonValue = json.get(name);

                Serializable value = null;

                // process null values 
                if (jsonValue.equals(JSONObject.NULL))
                {
                    props.put(key, null);
                }
                else
                {
                    // gets the property definition from dictionary
                    PropertyDefinition prop = dictionaryService.getProperty(key);
                    AssociationDefinition association = dictionaryService.getAssociation(key);

                    if (prop != null)
                    {
                        // convert property using its data type specified in model
                        value = (Serializable) DefaultTypeConverter.INSTANCE.convert(prop.getDataType(), jsonValue);
                    }
                    else if (null != association)
                    {
                        ClassDefinition targetClassDef = association.getTargetClass();
                        QName targetClassName = targetClassDef.getName();
                        System.err.println("Found association: " + key + " target class: " + targetClassName);
                        if (cmPersonClassName.equals(targetClassName))
                        {
                            System.err.println("Searching for person: " + jsonValue);
                            value = personService.getPerson(jsonValue.toString());
                        }
                    }
                    else
                    {
                        // property definition was not found in dictionary
                        if (jsonValue instanceof JSONArray)
                        {
                            value = new ArrayList<String>();

                            for (int i = 0; i < ((JSONArray) jsonValue).length(); i++)
                            {
                                ((List<String>) value).add(((JSONArray) jsonValue).getString(i));
                            }
                        }
                        else
                        {
                            // If the JSON returns an Object which is not a String, we use that type.
                            // Otherwise, we try to convert the string
                            if (jsonValue instanceof String)
                            {
                                // Revert to using string-value
                                value = (String) jsonValue;
                            }
                            else
                            {
                                // Use the value provided by JSON
                                value = (Serializable) jsonValue;
                            }
                        }
                    }
                }

                String valueClass = (null == value) ? "" : " class: " + value.getClass();
                System.err.println("Adding property: " + key + valueClass + " with value: " + value);
                System.err.println();
                props.put(key, value);
            }
        }
        return props;
    }
}
