package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.resource.ResourceException;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecmimpl.OwCredentialsConstants;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.classes.OwAlfrescoBPMObjectClass;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.StartWorkflowResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowStartResult;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.WorkflowInstance;
import com.wewebu.ow.server.exceptions.OwException;

/**
 *<p>
 * Fake {@link OwWorkitem} used to start a new WorkflowREST.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
@SuppressWarnings("rawtypes")
public class OwAlfrescoBPMLaunchableWorkItem extends OwAlfrescoBPMWorkItem
{
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMLaunchableWorkItem.class);
    private OwWorkflowDescription workflowDescription;

    @SuppressWarnings("unchecked")
    protected OwAlfrescoBPMLaunchableWorkItem(TaskInstance taskInstance, OwAlfrescoBPMLaunchableWorkitemContainer container, Collection attachmentobjects, OwAlfrescoBPMWorkflowDescription workflowDescription, OwAlfrescoBPMRepository bpmRepository)
            throws OwException
    {
        super(taskInstance, container, bpmRepository);
        this.attachmentobjects = new ArrayList();
        if (null != attachmentobjects)
        {
            this.attachmentobjects.addAll(attachmentobjects);
        }
        this.workflowDescription = workflowDescription;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem#dispatch()
     */
    @SuppressWarnings("unchecked")
    @Override
    public void dispatch() throws Exception
    {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        StartWorkflowResource resource = restfulFactory.startWorkflowResource(this.workflowDescription.getId());
        try
        {
            Map<String, Object> parameters = prepareParameters();

            //TODO remove this when objectClass.getPropertyClassNames() will return associations too
            String currentUserName = this.bpmRepository.getNetwork().getCredentials().getAuthInfo(OwCredentialsConstants.LOGIN_USR);
            parameters.put(OwAlfrescoBPMObjectClass.PROP_BPM_ASSIGNEE, currentUserName);

            //Uncomment this if you want the workflow priority to be also set
            //            if (parameters.containsKey(OwAlfrescoBPMWorkflowModel.PROP_CLASS_BPM_PRIORITY))
            //            {
            //                Object priority = parameters.get(OwAlfrescoBPMWorkflowModel.PROP_CLASS_BPM_PRIORITY);
            //                parameters.put(OwAlfrescoBPMWorkflowModel.PROP_CLASS_BPM_WORKFLOW_PRIORITY, priority);
            //            }

            JSONObject jsonObject = new JSONObject(parameters);
            LOG.log(Level.WARN, jsonObject);

            WorkflowStartResult result = resource.start(new JsonRepresentation(jsonObject));
            WorkflowInstance workflowInstance = new WorkflowInstance();
            workflowInstance.setId(result.data.getWorkflowInstanceId());
            this.taskInstance.setWorkflowInstance(workflowInstance);
            String bpmPackage = result.data.getBpmPackage();
            OwProperty bpmPackageProp = this.getProperty(OwAlfrescoBPMObjectClass.PROP_BPM_PACKAGE);
            bpmPackageProp.setValue(bpmPackage);

            OwStandardPropertyCollection props = new OwStandardPropertyCollection();
            props.put(OwAlfrescoBPMObjectClass.PROP_BPM_PACKAGE, bpmPackageProp);

            this.setProperties(props);
        }
        catch (ResourceException re)
        {
            LOG.error(resource.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not start workflow.", re);
        }
        finally
        {
            resource.getClientResource().release();
        }

        this.saveAttachments();
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem#canDispatch(int)
     */
    @Override
    public boolean canDispatch(int iContext_p) throws Exception
    {
        return true;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem#getLock(int)
     */
    @Override
    public boolean getLock(int iContext_p) throws Exception
    {
        return true;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem#save()
     */
    @Override
    protected void save()
    {
        //DO nothing
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem#setProperties(com.wewebu.ow.server.ecm.OwPropertyCollection)
     */
    @Override
    public void setProperties(OwPropertyCollection properties_p) throws Exception
    {
        // TODO Auto-generated method stub
        super.setProperties(properties_p);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem#loadAttachments()
     */
    @Override
    protected void loadAttachments()
    {
        //Do nothing, we already have them cached
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem#canReassignToUserContainer(int)
     */
    @Override
    public boolean canReassignToUserContainer(int iContext_p) throws Exception
    {
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem#loadPropertyValue(java.lang.String, com.wewebu.ow.server.ecm.OwPropertyClass)
     */
    @Override
    protected Object loadPropertyValue(String strPropertyName_p, OwPropertyClass propertyClass) throws Exception
    {
        // When starting a workflow, unspecified properties have to have the default value set for them
        Object nativeValue = super.loadPropertyValue(strPropertyName_p, propertyClass);
        if (null == nativeValue)
        {
            nativeValue = propertyClass.getDefaultValue();
        }
        return nativeValue;
    }
}