package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.restlet.resource.ResourceException;

import com.wewebu.ow.server.ecm.OwBatch;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowDefinitions;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowDefinitionsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.WorkflowDefinition;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.util.WorkflowDescriptionNameComparator;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwXMLUtil;

/**
 *<p>
 * Implementation of a BPM Repository based on the Alfresco WorkflowREST RESTful API.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 3.2.0.0
 */
public class OwAlfrescoBPMRepository implements OwWorkitemRepository
{
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMRepository.class);
    private static final String BASE_URL = "BaseURL";

    private OwNetwork network;
    private OwXMLUtil config;
    private String baseURL;

    private AlfrescoRESTFulFactory restFulFactory;

    /**
     * This constructor is called through reflection.
     * 
     * @param network_p the initiating {@link OwNetwork} instance.
     * @param bpmConfig_p the BPM configuration XML snippet.
     * @throws OwConfigurationException thrown if there is was configuration exception 
     * preventing us from creating a fully configured instance of this repository. 
     */
    public OwAlfrescoBPMRepository(OwNetwork network_p, OwXMLUtil bpmConfig_p) throws OwConfigurationException
    {
        this.network = network_p;
        this.config = bpmConfig_p;
        this.init();
    }

    private void init() throws OwConfigurationException
    {
        this.baseURL = this.config.getSafeTextValue(BASE_URL, null);
        if (null == this.baseURL)
        {
            throw new OwConfigurationException("Missing " + BASE_URL + " configuration.");
        }

        try
        {
            this.restFulFactory = new AlfrescoRESTFulFactory(this.baseURL, this.network);
        }
        catch (Exception e)
        {
            throw new OwConfigurationException("Could not create a RESTful factory instance.", e);
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#refreshStaticClassdescriptions()
     */
    public void refreshStaticClassdescriptions() throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#canRefreshStaticClassdescriptions()
     */
    public boolean canRefreshStaticClassdescriptions() throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#doSearch(com.wewebu.ow.server.field.OwSearchNode, com.wewebu.ow.server.field.OwSort, java.util.Collection, int, int)
     */
    public OwObjectCollection doSearch(OwSearchNode searchCriteria_p, OwSort sortCriteria_p, Collection propertyNames_p, int iMaxSize_p, int iVersionSelection_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#getObjectFromDMSID(java.lang.String, boolean)
     */
    public OwObject getObjectFromDMSID(String strDMSID_p, boolean fRefresh_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#getObjectFromPath(java.lang.String, boolean)
     */
    public OwObject getObjectFromPath(String strPath_p, boolean fRefresh_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#getObjectClass(java.lang.String, com.wewebu.ow.server.ecm.OwResource)
     */
    public OwObjectClass getObjectClass(String strClassName_p, OwResource resource_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#getObjectClassNames(int[], boolean, boolean, com.wewebu.ow.server.ecm.OwResource)
     */
    public Map getObjectClassNames(int[] iTypes_p, boolean fExcludeHiddenAndNonInstantiable_p, boolean fRootOnly_p, OwResource resource_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#getResource(java.lang.String)
     */
    public OwResource getResource(String strID_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#getResourceIDs()
     */
    public Iterator getResourceIDs() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#getEventManager()
     */
    public OwEventManager getEventManager()
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#getDMSPrefix()
     */
    public String getDMSPrefix()
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#releaseResources()
     */
    public void releaseResources() throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#canBatch()
     */
    public boolean canBatch()
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#openBatch()
     */
    public OwBatch openBatch() throws OwException
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwRepository#closeBatch(com.wewebu.ow.server.ecm.OwBatch)
     */
    public void closeBatch(OwBatch batch_p) throws OwException
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.field.OwFieldDefinitionProvider#getFieldDefinition(java.lang.String, java.lang.String)
     */
    public OwFieldDefinition getFieldDefinition(String strFieldDefinitionName_p, String strResourceName_p) throws Exception, OwObjectNotFoundException
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.field.OwFieldDefinitionProvider#getWildCardDefinitions(java.lang.String, java.lang.String, int)
     */
    public Collection getWildCardDefinitions(String strFieldDefinitionName_p, String strResourceName_p, int iOp_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository#getWorkitemContainerIDs(boolean, int)
     */
    @SuppressWarnings("rawtypes")
    public Collection getWorkitemContainerIDs(boolean fRefresh_p, int iType_p) throws Exception
    {
        Collection<String> retNames = new ArrayList<String>();

        switch (iType_p)
        {
            case OwObjectReference.OBJECT_TYPE_USER_QUEUE_FOLDER:
            {
                retNames.add(OwAlfrescoBPMWorkitemContainer.ID_QUEUE_INBOX);
            }
            default:
                LOG.warn("Unknown type definition provided will return empty Collection, unknown value = " + iType_p);
        }

        return retNames;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository#getWorkitemContainer(java.lang.String, int)
     */
    public OwWorkitemContainer getWorkitemContainer(String sID_p, int iType_p) throws Exception
    {
        switch (iType_p)
        {
            case OwObjectReference.OBJECT_TYPE_USER_QUEUE_FOLDER:
            {
                return new OwAlfrescoBPMUserQueueContainer(this.network, this, sID_p);
            }
        }

        String msg = "Object not found, Type = " + iType_p + ", ID = " + sID_p;
        LOG.error(msg);
        throw new OwObjectNotFoundException(msg);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository#getWorkitemContainerName(java.lang.String, int)
     */
    public String getWorkitemContainerName(String sID_p, int iType_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository#hasContainer(int)
     */
    public boolean hasContainer(int iType_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository#createProxy()
     */
    public OwProxyInfo createProxy() throws Exception, OwNotSupportedException
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository#setProxies(java.util.Collection, java.lang.String)
     */
    @SuppressWarnings("rawtypes")
    public void setProxies(Collection proxies_p, String absentpersonID_p) throws Exception, OwNotSupportedException
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository#getProxies(java.lang.String)
     */
    @SuppressWarnings("rawtypes")
    public Collection getProxies(String absentpersonID_p) throws Exception, OwNotSupportedException
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository#canProxy()
     */
    public boolean canProxy()
    {
        return true;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository#getLaunchableWorkflowDescriptions(java.util.Collection)
     */
    @SuppressWarnings({ "rawtypes" })
    public Collection getLaunchableWorkflowDescriptions(Collection attachmentobjects_p) throws Exception
    {
        //There are no Subscriptions in Alfresco BPM, so we always return all workflow descriptions
        List<OwAlfrescoBPMWorkflowDescription> result = getDefaultWorkflowDescriptions();
        java.util.Collections.sort(result, new WorkflowDescriptionNameComparator());
        return result;
    }

    private List<OwAlfrescoBPMWorkflowDescription> getDefaultWorkflowDescriptions() throws OwRestException
    {
        WorkflowDefinitionsResource res = this.restFulFactory.workflowDefinitionsResource();
        try
        {
            WorkflowDefinitions wdefinitions = res.list();
            List<OwAlfrescoBPMWorkflowDescription> result = new ArrayList<OwAlfrescoBPMWorkflowDescription>();
            for (WorkflowDefinition definition : wdefinitions.data)
            {
                result.add(new OwAlfrescoBPMWorkflowDescription(definition, this));
            }
            return result;
        }
        catch (ResourceException resEx)
        {
            LOG.error(res.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not load workflow descriptions.", resEx);
        }
        finally
        {
            res.getClientResource().release();
        }
    }

    @SuppressWarnings("rawtypes")
    public OwWorkitem createLaunchableItem(OwWorkflowDescription workflowDescription_p, Collection attachmentobjects_p) throws Exception
    {
        OwAlfrescoBPMLaunchableWorkitemContainer workitemContainer = new OwAlfrescoBPMLaunchableWorkitemContainer(this.network, this);
        OwAlfrescoBPMWorkflowDescription alfrescoWFDescription = (OwAlfrescoBPMWorkflowDescription) workflowDescription_p;
        alfrescoWFDescription.load();
        return workitemContainer.createLaunchableWorkItem(alfrescoWFDescription, attachmentobjects_p);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository#canLaunch()
     */
    public boolean canLaunch()
    {
        return true;
    }

    /**
     * @return The base URL of the server we are connecting to.
     */
    public String getBaseURL()
    {
        return this.baseURL;
    }

    public OwNetworkContext getContext()
    {
        return this.network.getContext();
    }

    /**
     * @return the restFulFactory
     */
    public AlfrescoRESTFulFactory getRestFulFactory()
    {
        return restFulFactory;
    }

    /**
     * @return the network
     */
    public OwNetwork getNetwork()
    {
        return network;
    }
}
