package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.restlet.resource.ResourceException;

import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecmimpl.OwCredentialsConstants;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstances;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstancesResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.WorkflowStatus;
import com.wewebu.ow.server.field.OwSearchNode;

/**
 *<p>
 * Inbox queues for Alfresco BPM users.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public class OwAlfrescoBPMUserQueueContainer extends OwAlfrescoBPMWorkitemContainer
{
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMUserQueueContainer.class);

    /**
     * @param bpmRepository
     * @param sID_p
     */
    public OwAlfrescoBPMUserQueueContainer(OwNetwork network, OwAlfrescoBPMRepository bpmRepository, String sID_p)
    {
        super(network, bpmRepository, sID_p);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#hasChilds(int[], int)
     */
    public boolean hasChilds(int[] iObjectTypes_p, int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /**
     * 
     * @param filterCriteria_p null to get all results.
     * @param iMaxSize_p -1 to get all the results.
     * @return A list of tasks for this container.
     * @throws Exception
     */
    protected List<OwAlfrescoBPMWorkItem> getChildren(OwSearchNode filterCriteria_p, int iMaxSize_p) throws Exception
    {
        String user = this.network.getCredentials().getAuthInfo(OwCredentialsConstants.LOGIN_USR);
        TaskInstancesResource res = this.bpmRepository.getRestFulFactory().taskInstancesResource(user, WorkflowStatus.IN_PROGRESS, filterCriteria_p, iMaxSize_p);
        try
        {
            TaskInstances tasks = res.list();
            List<OwAlfrescoBPMWorkItem> result = new ArrayList<OwAlfrescoBPMWorkItem>();
            for (TaskInstance instance : tasks.data)
            {
                result.add(new OwAlfrescoBPMWorkItem(instance, this, this.bpmRepository));
            }
            return result;
        }
        catch (ResourceException re)
        {
            LOG.error(res.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not fetch children.", re);
        }
        finally
        {
            res.getClientResource().release();
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getType()
     */
    public int getType()
    {
        return OwObjectReference.OBJECT_TYPE_USER_QUEUE_FOLDER;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getMIMEType()
     */
    public String getMIMEType() throws Exception
    {
        return "ow_workitemcontainer/user";
    }
}
