package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.resource.ResourceException;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwStatusContextDefinitions;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemProcessorInfo;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.classes.OwAlfrescoBPMObjectClass;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceDetails;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceEndResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.WorkflowInstance;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwString1;

/**
 *<p>
 * Alfresco BPM based implementation of a {@link OwWorkitem}.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
@SuppressWarnings({ "unchecked", "rawtypes" })
public class OwAlfrescoBPMWorkItem implements OwWorkitem
{
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMWorkItem.class);

    protected TaskInstance taskInstance;
    protected IfOwAlfrescoBPMWporkitemContainer container;
    protected OwAlfrescoBPMObjectClass objectClass;
    protected OwAlfrescoBPMRepository bpmRepository;
    protected Map<String, OwProperty> properties;

    protected Collection attachmentobjects;

    private transient boolean lock;

    public OwAlfrescoBPMWorkItem(TaskInstance taskInstance, IfOwAlfrescoBPMWporkitemContainer container, OwAlfrescoBPMRepository bpmRepository) throws OwException
    {
        this.taskInstance = taskInstance;
        this.container = container;
        this.bpmRepository = bpmRepository;
        try
        {
            OwNetwork network = container.getNetwork();
            OwObjectClass nativeClass = network.getObjectClass("D:" + this.taskInstance.getName(), null);

            this.objectClass = new OwAlfrescoBPMWorkItemObjectClass(nativeClass);
        }
        catch (Exception e)
        {
            throw new OwServerException("Could not get class for task instance!", e);
        }

        this.properties = new HashMap<String, OwProperty>();
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getClassName()
     */
    public String getClassName()
    {
        return getObjectClass().getClassName();
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getObjectClass()
     */
    public OwObjectClass getObjectClass()
    {
        return this.objectClass;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getParents()
     */
    public OwObjectCollection getParents() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getChilds(int[], java.util.Collection, com.wewebu.ow.server.field.OwSort, int, int, com.wewebu.ow.server.field.OwSearchNode)
     */
    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#hasChilds(int[], int)
     */
    public boolean hasChilds(int[] iObjectTypes_p, int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getChildCount(int[], int)
     */
    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return 0;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#changeClass(java.lang.String, com.wewebu.ow.server.ecm.OwPropertyCollection, com.wewebu.ow.server.ecm.OwPermissionCollection)
     */
    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canChangeClass()
     */
    public boolean canChangeClass() throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canFilterChilds()
     */
    public boolean canFilterChilds() throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getFilterProperties(java.util.Collection)
     */
    public Collection getFilterProperties(Collection propertynames_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getVersionSeries()
     */
    public OwVersionSeries getVersionSeries() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#hasVersionSeries()
     */
    public boolean hasVersionSeries() throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getVersion()
     */
    public OwVersion getVersion() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getProperty(java.lang.String)
     */
    public OwProperty getProperty(String strPropertyName_p) throws Exception
    {
        if (OwAlfrescoBPMObjectClass.PROP_OW_ATTACHMENTS.equals(strPropertyName_p))
        {
            Object[] array = null;
            if (null == this.attachmentobjects)
            {
                loadAttachments();
            }
            array = this.attachmentobjects.toArray();
            return new OwStandardProperty(array, this.getObjectClass().getPropertyClass(strPropertyName_p));
        }

        if (OwAlfrescoBPMObjectClass.PROP_OW_TASK_TITLE.endsWith(strPropertyName_p))
        {
            String title = this.taskInstance.getTitle();
            return new OwStandardProperty(title, this.getObjectClass().getPropertyClass(strPropertyName_p));
        }

        String propertyClassName = this.getObjectClass().getPropertyClass(strPropertyName_p).getClassName();
        if (!this.properties.containsKey(propertyClassName))
        {
            loadProperty(propertyClassName);
        }

        OwProperty property = this.properties.get(propertyClassName);
        if (null == property)
        {
            throw new OwObjectNotFoundException("Property not found " + strPropertyName_p);
        }
        return property;
    }

    protected void loadAttachments() throws Exception
    {
        //TODO load attachments from folder denoted by bpm:package
        OwObject attachmentFolder = getAttachmentsFolder();
        OwObjectCollection existingAttachments = attachmentFolder.getChilds(new int[] { OwObjectReference.OBJECT_TYPE_FOLDER, OwObjectReference.OBJECT_TYPE_DOCUMENT }, null, null, 100, 0, null);

        this.attachmentobjects = new ArrayList();
        this.attachmentobjects.addAll(existingAttachments);
    }

    /**
     * A clean implementation of DMSIDs could be achieved by plugging the adaptor with some
     * custom properties/factories.
     * <p> 
     * See 
     * <ul>
     * <li>com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory</li>
     * <li>import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISIdDMSIDConverter</li>
     * </ul>
     * </p>
     * 
     * @return the folder reserved by the process engine for storing this workflow's Attachments
     * @throws Exception
     */
    private OwObject getAttachmentsFolder() throws Exception
    {
        OwProperty bpmPackage = this.getProperty(OwAlfrescoBPMObjectClass.PROP_BPM_PACKAGE);
        String bpmPackagePath = (String) bpmPackage.getValue();

        OwNetwork network = this.bpmRepository.getNetwork();
        String resourceId = network.getResource(null).getID();
        String dmsId = "cmis," + resourceId + "," + bpmPackagePath;

        OwObject attachmentFolder = network.getObjectFromDMSID(dmsId, true);
        return attachmentFolder;
    }

    /**
     * @param propertyClassName
     * @throws OwException
     */
    private void loadProperty(String propertyClassName) throws OwException
    {
        try
        {
            OwPropertyClass propertyClass = getObjectClass().getPropertyClass(propertyClassName);
            Object nativeValue = loadPropertyValue(propertyClassName, propertyClass);
            OwAlfrescoBPMProperty property = new OwAlfrescoBPMProperty(nativeValue, propertyClass);
            this.properties.put(propertyClassName, property);
        }
        catch (RuntimeException re)
        {
            throw re;
        }
        catch (Exception e)
        {
            LOG.error("Could not get property: " + propertyClassName, e);
            throw new OwServerException("Could not load property " + propertyClassName, e);
        }
    }

    /**
     * Makes sure the type of the returned value matches {@link OwPropertyClass#getJavaClassName()}. 
     * 
     * @param strPropertyName_p
     * @param propertyClass 
     * @return Object
     * @throws ClassNotFoundException 
     */
    protected Object loadPropertyValue(String strPropertyName_p, OwPropertyClass propertyClass) throws Exception
    {
        String translatedPropertyName = strPropertyName_p.replace(':', '_');
        Object nativeValue = null;

        Map<String, Object> taskProperties = this.taskInstance.getProperties();

        if (taskProperties.containsKey(translatedPropertyName))
        {
            nativeValue = taskProperties.get(translatedPropertyName);
        }
        else
        {
            //retry for CMIS dotted value
            String[] dotSplitPropertyName = strPropertyName_p.split("\\.");
            if (dotSplitPropertyName.length == 2)
            {
                String translatedDotSplitName = dotSplitPropertyName[1].replace(':', '_');
                if (taskProperties.containsKey(translatedDotSplitName))
                {
                    nativeValue = taskProperties.get(translatedDotSplitName);
                }
            }
        }

        return nativeValue;
    }

    public OwPropertyCollection getProperties(Collection propertyNames_p) throws Exception
    {
        if (propertyNames_p == null)
        {
            OwObjectClass clazz = getObjectClass();
            propertyNames_p = clazz.getPropertyClassNames();
        }

        //TODO: add proper implementation
        OwPropertyCollection result = new OwStandardPropertyCollection();
        for (Iterator i = propertyNames_p.iterator(); i.hasNext();)
        {
            String propertyName = (String) i.next();
            OwProperty property = getProperty(propertyName);
            result.put(propertyName, property);
        }
        return result;
    }

    public OwPropertyCollection getClonedProperties(Collection propertyNames_p) throws Exception
    {
        return OwStandardPropertyClass.getClonedProperties(this, propertyNames_p);
    }

    public void setProperties(OwPropertyCollection properties_p) throws Exception
    {
        Collection<OwProperty> values = properties_p.values();
        for (OwProperty owProperty : values)
        {
            storeProperty(owProperty);
        }

        save();
    }

    /**
     * @param owProperty
     * @throws Exception
     */
    private void storeProperty(OwProperty owProperty) throws Exception
    {
        String propertyClassName = owProperty.getPropertyClass().getClassName();
        if (OwAlfrescoBPMObjectClass.PROP_OW_ATTACHMENTS.equals(propertyClassName))
        {
            Object[] array = (Object[]) owProperty.getValue();
            if (null == array)
            {
                this.attachmentobjects = null;
            }
            else
            {
                this.attachmentobjects.clear();
                this.attachmentobjects.addAll(Arrays.asList(array));
            }
            return;
        }

        if (OwAlfrescoBPMObjectClass.PROP_OW_TASK_TITLE.equals(propertyClassName))
        {
            //this is readonly
            return;
        }

        this.properties.put(propertyClassName, owProperty);
    }

    /**
     * @throws Exception 
     * 
     */
    protected void save() throws Exception
    {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        TaskInstanceResource resource = restfulFactory.taskInstanceResource(this.getID());
        try
        {
            Map<String, Object> parameters = prepareParameters();
            JSONObject jsonObject = new JSONObject(parameters);
            LOG.log(Level.INFO, jsonObject);

            TaskInstanceDetails updatedTaskInstance = resource.save(new JsonRepresentation(jsonObject));
            if (LOG.isDebugEnabled())
            {
                LOG.debug("OwAlfrescoBPMWrokItem.save(): Props done, task-Id = " + updatedTaskInstance.data.getId());
            }
            saveAttachments();
        }
        catch (ResourceException re)
        {
            LOG.error(resource.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not save workitem.", re);
        }
        finally
        {
            resource.getClientResource().release();
        }
    }

    protected void saveAttachments() throws Exception
    {
        if (null != this.attachmentobjects)
        {
            OwObject attachmentsFolder = getAttachmentsFolder();
            OwObjectCollection existingAttachments = attachmentsFolder.getChilds(new int[] { OwObjectReference.OBJECT_TYPE_FOLDER, OwObjectReference.OBJECT_TYPE_DOCUMENT }, null, null, 100, 0, null);
            ArrayList attachmentsToDelete = new ArrayList(existingAttachments);
            attachmentsToDelete.removeAll(this.attachmentobjects);

            if (!attachmentsToDelete.isEmpty())
            {
                // delete them
                for (Object element : attachmentsToDelete)
                {
                    OwObject owObject = (OwObject) element;
                    attachmentsFolder.removeReference(owObject);
                }
            }

            ArrayList attachmentsToBeAdded = new ArrayList(this.attachmentobjects);
            attachmentsToBeAdded.removeAll(existingAttachments);
            if (!attachmentsToBeAdded.isEmpty())
            {
                for (Object element : attachmentsToBeAdded)
                {
                    OwObject owObject = (OwObject) element;
                    attachmentsFolder.add(owObject);
                }
            }
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#setProperties(com.wewebu.ow.server.ecm.OwPropertyCollection, java.lang.Object)
     */
    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws Exception
    {
        this.setProperties(properties_p);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canSetProperties(int)
     */
    public boolean canSetProperties(int iContext_p) throws Exception
    {
        return true;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canGetProperties(int)
     */
    public boolean canGetProperties(int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canLock()
     */
    public boolean canLock() throws Exception
    {
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#setLock(boolean)
     */
    public boolean setLock(boolean fLock_p) throws Exception
    {
        return this.lock = fLock_p;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getLock(int)
     */
    public boolean getLock(int iContext_p) throws Exception
    {
        return this.lock;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getMyLock(int)
     */
    public boolean getMyLock(int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getLockUserID(int)
     */
    public String getLockUserID(int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#delete()
     */
    public void delete() throws Exception
    {
        String workflowInstanceId = this.taskInstance.getWorkflowInstance().getId();
        AlfrescoRESTFulFactory restFulFactory = this.bpmRepository.getRestFulFactory();
        WorkflowInstanceResource resource = restFulFactory.workflowInstance(workflowInstanceId);
        try
        {
            resource.delete();
        }
        finally
        {
            resource.getClientResource().release();
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canDelete(int)
     */
    public boolean canDelete(int iContext_p) throws Exception
    {
        return true;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#removeReference(com.wewebu.ow.server.ecm.OwObject)
     */
    public void removeReference(OwObject oObject_p) throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canRemoveReference(com.wewebu.ow.server.ecm.OwObject, int)
     */
    public boolean canRemoveReference(OwObject oObject_p, int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#add(com.wewebu.ow.server.ecm.OwObject)
     */
    public void add(OwObject oObject_p) throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canAdd(com.wewebu.ow.server.ecm.OwObject, int)
     */
    public boolean canAdd(OwObject oObject_p, int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#move(com.wewebu.ow.server.ecm.OwObject, com.wewebu.ow.server.ecm.OwObject)
     */
    public void move(OwObject oObject_p, OwObject oldParent_p) throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canMove(com.wewebu.ow.server.ecm.OwObject, com.wewebu.ow.server.ecm.OwObject, int)
     */
    public boolean canMove(OwObject oObject_p, OwObject oldParent_p, int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getSearchTemplate()
     */
    public OwSearchTemplate getSearchTemplate() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getColumnInfoList()
     */
    public Collection getColumnInfoList() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getResource()
     */
    public OwResource getResource() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getPermissions()
     */
    public OwPermissionCollection getPermissions() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getClonedPermissions()
     */
    public OwPermissionCollection getClonedPermissions() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canGetPermissions()
     */
    public boolean canGetPermissions() throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canSetPermissions()
     */
    public boolean canSetPermissions() throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#setPermissions(com.wewebu.ow.server.ecm.OwPermissionCollection)
     */
    public void setPermissions(OwPermissionCollection permissions_p) throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getContentCollection()
     */
    public OwContentCollection getContentCollection() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#setContentCollection(com.wewebu.ow.server.ecm.OwContentCollection)
     */
    public void setContentCollection(OwContentCollection content_p) throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canSetContent(int, int)
     */
    public boolean canSetContent(int iContentType_p, int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#canGetContent(int, int)
     */
    public boolean canGetContent(int iContentType_p, int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#refreshProperties()
     */
    public void refreshProperties() throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#refreshProperties(java.util.Collection)
     */
    public void refreshProperties(Collection props_p) throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getNativeObject()
     */
    public Object getNativeObject() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getPath()
     */
    public String getPath() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getResourceID()
     */
    public String getResourceID() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getInstance()
     */
    public OwObject getInstance() throws Exception
    {
        return this;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getName()
     */
    public String getName()
    {
        try
        {
            String title = (String) getProperty(OwAlfrescoBPMObjectClass.PROP_OW_TASK_TITLE).getValue();
            String description = (String) getProperty("bpm:description").getValue();
            String name = String.format("%s (%s)", title, description);
            return name;
        }
        catch (Exception e)
        {
            return "[undef]";
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getID()
     */
    public String getID()
    {
        return taskInstance.getId();
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getType()
     */
    public int getType()
    {
        return OwObjectReference.OBJECT_TYPE_WORKITEM;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getDMSID()
     */
    public String getDMSID() throws Exception
    {
        return taskInstance.getId();
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getPageCount()
     */
    public int getPageCount() throws Exception
    {
        // TODO Auto-generated method stub
        return 0;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getMIMEType()
     */
    public String getMIMEType() throws Exception
    {
        return this.container.createContaineeMIMEType(this);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getMIMEParameter()
     */
    public String getMIMEParameter() throws Exception
    {
        return this.container.createContaineeMIMEParameter(this);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#hasContent(int)
     */
    public boolean hasContent(int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.field.OwFieldProvider#getField(java.lang.String)
     */
    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.field.OwFieldProvider#setField(java.lang.String, java.lang.Object)
     */
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.field.OwFieldProvider#getSafeFieldValue(java.lang.String, java.lang.Object)
     */
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p)
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.field.OwFieldProvider#getFields()
     */
    public Collection getFields() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.field.OwFieldProvider#getFieldProviderType()
     */
    public int getFieldProviderType()
    {
        // TODO Auto-generated method stub
        return 0;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.field.OwFieldProvider#getFieldProviderSource()
     */
    public Object getFieldProviderSource()
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.field.OwFieldProvider#getFieldProviderName()
     */
    public String getFieldProviderName()
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#getStepProcessorInfo()
     */
    public OwWorkitemProcessorInfo getStepProcessorInfo() throws OwObjectNotFoundException
    {
        String strJspPage = "";
        try
        {
            strJspPage = getProperty(OwAlfrescoBPMObjectClass.PROP_OW_STEPPROCESSOR_JSP_PAGE).getValue().toString();
        }
        catch (Exception e)
        {
            // ignore
        }

        if (strJspPage.length() == 0)
        {
            return new OwAlfrescoBPMProcessorInfo(this);
        }
        else
        {
            return new OwAlfrescoBPMProcessorInfo(this, strJspPage);
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#setResponse(java.lang.String)
     */
    public void setResponse(String strResponse_p) throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#canResponse()
     */
    public boolean canResponse()
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#getResponse()
     */
    public String getResponse() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#getResponses()
     */
    public Collection getResponses() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#forcedelete()
     */
    public void forcedelete() throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#canForcedelete(int)
     */
    public boolean canForcedelete(int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#dispatch()
     */
    public void dispatch() throws Exception
    {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        TaskInstanceEndResource resource = restfulFactory.taskInstanceEndResource(this.getID());
        try
        {
            resource.end();
        }
        catch (ResourceException re)
        {
            LOG.error(resource.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not end task.", re);
        }
        finally
        {
            resource.getClientResource().release();
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#canDispatch(int)
     */
    public boolean canDispatch(int iContext_p) throws Exception
    {
        return true;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#returnToSource()
     */
    public void returnToSource() throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#canReturnToSource(int)
     */
    public boolean canReturnToSource(int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#reassignToPublicContainer(java.lang.String, boolean)
     */
    public void reassignToPublicContainer(String containername_p, boolean delegateFlag_p) throws Exception
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#reassignToUserContainer(java.lang.String, boolean)
     */
    public void reassignToUserContainer(String participant_p, boolean delegateFlag_p) throws Exception
    {
        if (delegateFlag_p)
        {
            throw new OwInvalidOperationException("Task delegation is not implemented yet.");
        }
        OwUserInfo toUser = this.bpmRepository.getNetwork().getUserFromID(participant_p);

        OwProperty cmOwner = this.getProperty(OwAlfrescoBPMObjectClass.PROP_CM_OWNER);
        cmOwner.setValue(toUser.getUserName());

        OwPropertyCollection newProperties = new OwStandardPropertyCollection();
        newProperties.put(cmOwner.getPropertyClass(), cmOwner);
        this.setProperties(newProperties);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#canReassignToPublicContainer(int)
     */
    public boolean canReassignToPublicContainer(int iContext_p) throws Exception
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#canReassignToUserContainer(int)
     */
    public boolean canReassignToUserContainer(int iContext_p) throws Exception
    {
        return this.taskInstance.isReassignable();
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#resubmit(java.util.Date)
     */
    public void resubmit(Date date_p) throws Exception
    {
        if (!this.canResubmit(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS))
        {
            throw new OwConfigurationException("This item does not support resubmission.");
        }
        try
        {
            OwPropertyCollection properties = new OwStandardPropertyCollection();
            OwProperty resubmitProperty = getProperty(OwAlfrescoBPMObjectClass.PROP_OW_RESUBMIT_DATE);
            resubmitProperty.setValue(date_p);
            properties.put(resubmitProperty.getPropertyClass().getClassName(), resubmitProperty);

            setProperties(properties);
        }
        catch (OwObjectNotFoundException e)
        {
            LOG.error("No exposed resubmit property defined: " + OwAlfrescoBPMObjectClass.PROP_OW_RESUBMIT_DATE + " in workitem: " + getName(), e);
            throw new OwConfigurationException(new OwString1("ecmimpl.fncm.bpm.resubmissioninvalid", "The work item allows no resubmission. Probably the queue is not configured with this property (%1).",
                    OwAlfrescoBPMObjectClass.PROP_OW_RESUBMIT_DATE), e);
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#canResubmit(int)
     */
    public boolean canResubmit(int iContext_p) throws Exception
    {
        try
        {
            OwProperty resubmitProp = getProperty(OwAlfrescoBPMObjectClass.PROP_OW_RESUBMIT_DATE);
            return !resubmitProp.isReadOnly(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS);
        }
        catch (OwObjectNotFoundException e)
        {
            return false;
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitem#getResubmitDate(int)
     */
    public Date getResubmitDate(int iContext_p) throws Exception
    {
        try
        {
            OwProperty resubmitProperty = getProperty(OwAlfrescoBPMObjectClass.PROP_OW_RESUBMIT_DATE);

            Date resdate = (Date) resubmitProperty.getValue();

            if ((resdate == null) || (resdate.getTime() <= new Date().getTime()))
            {
                return null;
            }

            return resdate;
        }
        catch (OwObjectNotFoundException e)
        {
            return null;
        }
    }

    @Override
    public String toString()
    {
        return this.taskInstance.toString();
    }

    protected String shrinkPropertyName(String longPropertyName)
    {
        //retry for CMIS dotted value
        String[] dotSplitPropertyName = longPropertyName.split("\\.");
        if (dotSplitPropertyName.length == 2)
        {
            return dotSplitPropertyName[1].replace(':', '_');
        }

        return longPropertyName;
    }

    /**
     * Construct a map with parameters suitable for JSon encoding, 
     * from the properties of this object.
     * 
     * @return a map between property names and property values
     * @throws Exception
     */
    protected Map<String, Object> prepareParameters() throws Exception
    {
        Map<String, Object> parameters = new HashMap<String, Object>();
        Set<String> propertyNames = this.properties.keySet();
        for (String propName : propertyNames)
        {
            OwProperty property = this.properties.get(propName);
            boolean isUpdatable = !property.isReadOnly(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS) && !property.getPropertyClass().isReadOnly(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS)
                    && !property.getPropertyClass().isSystemProperty();
            //HACK cm:owner is ReadOnly, still we have to be able to update its value :(
            boolean isCmOwner = property.getPropertyClass().getClassName().equals("cm:owner");
            if (isCmOwner || isUpdatable)
            {
                //TODO translate to simple property name without namespace etc.
                String translatedPropName = this.shrinkPropertyName(propName);
                Object value = property.getNativeObject();
                parameters.put(translatedPropName, value);
            }
        }

        return parameters;
    }

    public String getWorkflowInstanceId()
    {
        WorkflowInstance workflowInstance = this.taskInstance.getWorkflowInstance();
        if (null != workflowInstance)
        {
            return workflowInstance.getId();
        }

        return null;
    }
}
