package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.classes.OwAlfrescoBPMObjectClass;

/**
 *<p>
 * {@link OwObjectClass} for {@link OwAlfrescoBPMWorkItem} instances.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public class OwAlfrescoBPMWorkItemObjectClass extends OwAlfrescoBPMObjectClass
{

    /**
     * @param wrappedObjectClass
     */
    public OwAlfrescoBPMWorkItemObjectClass(OwObjectClass wrappedObjectClass)
    {
        super(wrappedObjectClass);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.classes.OwAlfrescoBPMObjectClass#addVirtualProperties()
     */
    @Override
    protected void addVirtualProperties()
    {
        Format dateFormat = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'S");
        OwAlfrescoStandardPropertyClass cmCreatedPropertyClass = new OwAlfrescoStandardPropertyClass(PROP_CM_CREATED, Date.class, new OwAlfrescoBPMFormat(dateFormat));
        cmCreatedPropertyClass.setSystem(true);
        cmCreatedPropertyClass.setReadOnly(true);
        this.virtualProperties.put(cmCreatedPropertyClass.getClassName(), cmCreatedPropertyClass);

        //TODO get rid of this as soon as the CMIS adaptor implements Associations properties.
        OwAlfrescoStandardPropertyClass bpmPackagePropertyClass = new OwAlfrescoStandardPropertyClass(PROP_BPM_PACKAGE, String.class, null);
        bpmPackagePropertyClass.setSystem(true);
        bpmPackagePropertyClass.setReadOnly(true);
        this.virtualProperties.put(bpmPackagePropertyClass.getClassName(), bpmPackagePropertyClass);

        //TODO get rid of this as soon as the CMIS adaptor implements Associations properties.
        //        OwAlfrescoStandardPropertyClass cmOwnerPropertyClass = new OwAlfrescoStandardPropertyClass(PROP_CM_OWNER, String.class, null);
        //        cmOwnerPropertyClass.setSystem(true);
        //        cmOwnerPropertyClass.setReadOnly(true);
        //        this.virtualProperties.put(cmOwnerPropertyClass.getClassName(), cmOwnerPropertyClass);

        OwAlfrescoStandardPropertyClass owAttachmentsPropClass = new OwAlfrescoStandardPropertyClass(PROP_OW_ATTACHMENTS, OwObject.class, null);
        owAttachmentsPropClass.setSystem(false);
        owAttachmentsPropClass.setIsArray(true);
        this.virtualProperties.put(owAttachmentsPropClass.getClassName(), owAttachmentsPropClass);

        OwAlfrescoStandardPropertyClass owTitlePropClass = new OwAlfrescoStandardPropertyClass(PROP_OW_TASK_TITLE, String.class, null);
        owTitlePropClass.setSystem(true);
        owTitlePropClass.setReadOnly(true);
        owTitlePropClass.setIsArray(false);
        this.virtualProperties.put(owTitlePropClass.getClassName(), owTitlePropClass);
    }
}
