package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import org.apache.log4j.Logger;
import org.restlet.resource.ResourceException;

import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemProcessorInfo;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowDefinitionDetails;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowDefinitionDetailsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.WorkflowDefinition;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;

/**
 *<p>
 * Alfresco BPM based implementation of {@link OwWorkflowDescription}.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public class OwAlfrescoBPMWorkflowDescription implements OwWorkflowDescription
{
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMWorkflowDescription.class);

    private WorkflowDefinition wfDefinition;
    private OwAlfrescoBPMRepository bpmRepository;

    public OwAlfrescoBPMWorkflowDescription(WorkflowDefinition wfDefinition, OwAlfrescoBPMRepository bpmRepository)
    {
        this.wfDefinition = wfDefinition;
        this.bpmRepository = bpmRepository;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription#getStepProcessorInfo()
     */
    public OwWorkitemProcessorInfo getStepProcessorInfo() throws OwObjectNotFoundException
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription#getId()
     */
    public String getId()
    {
        return this.wfDefinition.getId();
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription#getName()
     */
    public String getName()
    {
        return this.wfDefinition.getTitle();
    }

    /* (non-Javadoc)
    * @see java.lang.Object#toString()
    */
    @Override
    public String toString()
    {
        return this.wfDefinition.toString();
    }

    public String getStartTaskDefinitionType()
    {
        return this.wfDefinition.getStartTaskDefinitionType();
    }

    //TODO implement some kind of automatic lazy loading
    public void load() throws OwException
    {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        WorkflowDefinitionDetailsResource res = restfulFactory.workflowDefinitionDetailsResource(this.getId());
        try
        {
            WorkflowDefinitionDetails details = res.get();
            this.wfDefinition = details.data;
        }
        catch (ResourceException resEx)
        {
            LOG.error(res.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not load WorkflowDescription details.", resEx);
        }
        finally
        {
            res.getClientResource().release();
        }
    }
}
