package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;

import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStatusContextDefinitions;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;

/**
 *<p>
 * Alfresco BPM based implementation of {@link OwWorkitemContainer}.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public abstract class OwAlfrescoBPMWorkitemContainer extends OwAlfrescoBPMBaseContainer
{
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMWorkitemContainer.class);

    public static final String ID_QUEUE_INBOX = "Inbox";

    protected String id;

    public OwAlfrescoBPMWorkitemContainer(OwNetwork network, OwAlfrescoBPMRepository bpmRepository, String sID_p)
    {
        super(network, bpmRepository);
        this.bpmRepository = bpmRepository;
        this.id = sID_p;
    }

    public String createContaineeMIMEType(OwAlfrescoBPMWorkItem item)
    {
        return "ow_workitem/item";
    }

    public String createContaineeMIMEParameter(OwAlfrescoBPMWorkItem item)
    {
        return "";
    }

    protected OwNetworkContext getBPMRepositoryContext()
    {
        return this.bpmRepository.getContext();
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getName()
     */
    public String getName()
    {
        return this.id;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObjectReference#getID()
     */
    public String getID()
    {
        return this.id;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMBaseContainer#pull(com.wewebu.ow.server.field.OwSort, java.util.Set)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public OwWorkitem pull(OwSort sort_p, Set exclude_p) throws Exception, OwObjectNotFoundException, OwServerException
    {
        OwObjectCollection children = this.getChilds(new int[] { OwObjectReference.OBJECT_TYPE_ALL_WORKFLOW_OBJECTS }, null, sort_p, 1, 0, null);
        if (children.isEmpty())
        {
            String message = getNetwork().getContext().localize("plug.owbpm.OwBPMPullFunction.pullfailed", "There is no work item to edit.");
            LOG.error(message);
            throw new OwObjectNotFoundException(message);
        }
        return (OwWorkitem) children.get(0);
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMBaseContainer#canPull(int)
     */
    @Override
    public boolean canPull(int iContext_p) throws Exception, OwStatusContextException
    {
        return true;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMBaseContainer#getFilterProperties(java.util.Collection)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public Collection getFilterProperties(Collection columnsInfo_p) throws Exception
    {
        Collection<OwFieldDefinition> filterProperties = new ArrayList<OwFieldDefinition>();
        // bpm:dueDate
        for (Object objColumnInfo : columnsInfo_p)
        {
            OwFieldColumnInfo columnInfo = (OwFieldColumnInfo) objColumnInfo;
            String propertyName = columnInfo.getPropertyName();
            if (propertyName.endsWith("bpm:dueDate"))
            {
                OwFieldDefinition fieldDefinition = this.network.getFieldDefinition(propertyName, null);
                filterProperties.add(fieldDefinition);
            }
        }
        return filterProperties;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer#canResubmit()
     */
    public boolean canResubmit() throws Exception
    {
        return true;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getChilds(int[], java.util.Collection, com.wewebu.ow.server.field.OwSort, int, int, com.wewebu.ow.server.field.OwSearchNode)
     */
    @SuppressWarnings({ "rawtypes", "unchecked" })
    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception
    {
        //TODO: the implementation must adhere to the sort_p, iMaxSize_p, iVersionSelection_p etc. parameters
        Set<Integer> types = new HashSet<Integer>();
        for (int i = 0; i < iObjectTypes_p.length; i++)
        {
            types.add(iObjectTypes_p[i]);
        }

        //This type of Queue only recognizes WORKITEMs
        OwObjectCollection result = new OwStandardObjectCollection();
        for (Integer type : types)
        {
            switch (type)
            {
                case OwObjectReference.OBJECT_TYPE_ALL_WORKFLOW_OBJECTS:
                case OwObjectReference.OBJECT_TYPE_WORKITEM:
                    result.addAll(getChildren(filterCriteria_p, iMaxSize_p));
            }
        }

        if (null != sort_p)
        {
            result.sort(sort_p);
        }

        //TODO: remove this when we have proper support for REST queries.
        int fType = getFilterType();
        if (fType == FILTER_TYPE_NORMAL)
        {
            Date now = new Date();
            OwObjectCollection copy = new OwStandardObjectCollection();
            copy.addAll(result);
            for (Object object : copy)
            {
                OwWorkitem item = (OwWorkitem) object;
                Date resubmitDate = item.getResubmitDate(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS);
                if (null != resubmitDate && resubmitDate.after(now))
                {
                    result.remove(item);
                }
            }
        }
        else if (fType == FILTER_TYPE_RESUBMISSION)
        {
            Date now = new Date();
            OwObjectCollection copy = new OwStandardObjectCollection();
            copy.addAll(result);
            for (Object object : copy)
            {
                OwWorkitem item = (OwWorkitem) object;
                Date resubmitDate = item.getResubmitDate(OwStatusContextDefinitions.STATUS_CONTEXT_CORRECT_STATUS);
                if (null == resubmitDate || resubmitDate.before(now))
                {
                    result.remove(item);
                }
            }
        }

        return result;
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecm.OwObject#getChildCount(int[], int)
     */
    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws Exception
    {
        Set<Integer> types = new HashSet<Integer>();
        for (int i = 0; i < iObjectTypes_p.length; i++)
        {
            types.add(iObjectTypes_p[i]);
        }

        //This type of Queue only recognizes WORKITEMs
        int count = 0;
        for (Integer type : types)
        {
            switch (type)
            {
                case OwObjectReference.OBJECT_TYPE_ALL_WORKFLOW_OBJECTS:
                case OwObjectReference.OBJECT_TYPE_WORKITEM:
                    count += getChildren(null, -1).size();
            }
        }
        return count;
    }

    protected abstract List<OwAlfrescoBPMWorkItem> getChildren(OwSearchNode filterCriteria_p, int iMaxSize_p) throws Exception;
}
