package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans;

import java.util.Map;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 *<p>
 * TaskInstance.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class TaskInstance implements OwAlfrescoBPMNativeObject
{
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String title;
    @JsonProperty
    private String description;
    @JsonProperty
    private String state;
    @JsonProperty
    private boolean isPooled;
    @JsonProperty
    private boolean isEditable;
    @JsonProperty
    private boolean isReassignable;
    @JsonProperty
    private boolean isClaimable;
    @JsonProperty
    private boolean isReleasable;
    @JsonProperty
    private String outcome;

    @JsonProperty
    private WorkflowInstance workflowInstance;

    @JsonProperty
    private Map<String, Object> properties;
    @JsonProperty
    private TaskInstanceDefinition definition;

    /**
     * @return the title
     */
    public String getTitle()
    {
        return title;
    }

    /**
     * @return the state
     */
    public String getState()
    {
        return state;
    }

    /**
     * @return the description
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * @return the id
     */
    public String getId()
    {
        return id;
    }

    /**
     * The name also denotes the name of the associated ECM class definition for this task.
     * @return the name of this task instance.
     */
    public String getName()
    {
        return name;
    }

    @Override
    public String toString()
    {
        return String.format("WorkItem: %s , Title: %s, State: %s", this.id, this.title, this.state);
    }

    /**
     * @return the properties
     */
    public Map<String, Object> getProperties()
    {
        return properties;
    }

    /**
     * @param properties the properties to set
     */
    public void setProperties(Map<String, Object> properties)
    {
        this.properties = properties;
    }

    public void setProperty(String key, Object value)
    {
        this.properties.put(key, value);
    }

    /**
     * @param name the name to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return the definition
     */
    public TaskInstanceDefinition getDefinition()
    {
        return definition;
    }

    /**
     * @return the isReassignable
     */
    public boolean isReassignable()
    {
        return isReassignable;
    }

    /**
     * @return the isClaimable
     */
    public boolean isClaimable()
    {
        return isClaimable;
    }

    /**
     * @return the workflowInstance
     */
    public WorkflowInstance getWorkflowInstance()
    {
        return workflowInstance;
    }

    /**
     * @param workflowInstance the workflowInstance to set
     */
    public void setWorkflowInstance(WorkflowInstance workflowInstance)
    {
        this.workflowInstance = workflowInstance;
    }
}