package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 *<p>
 * WorkflowDefinition.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class WorkflowDefinition
{
    @JsonProperty
    private String id;
    @JsonProperty
    private String url;
    @JsonProperty
    private String name;
    @JsonProperty
    private String title;
    @JsonProperty
    private String description;
    @JsonProperty
    private String version;
    @JsonProperty
    private String startTaskDefinitionType;

    /**
     * @return the description
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * @return the title
     */
    public String getTitle()
    {
        return title;
    }

    /**
     * @return the id
     */
    public String getId()
    {
        return id;
    }

    @Override
    public String toString()
    {
        return String.format("Id: %s Title: %s Url: %s", this.id, this.title, this.url);
    }

    /**
     * @return the name
     */
    public String getName()
    {
        return name;
    }

    /**
     * @return the url
     */
    public String getUrl()
    {
        return url;
    }

    /**
     * @return the version
     */
    public String getVersion()
    {
        return version;
    }

    /**
     * @return the startTaskDefinitionType
     */
    public String getStartTaskDefinitionType()
    {
        return startTaskDefinitionType;
    }
}
