package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;

/**
 *<p>
 * Converts from {@link String} to {@link Date} and back.
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.0.0.0
 */
public class DateNativeValueConverter implements NativeValueConverter
{
    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverter#fromNative(java.lang.Object)
     */
    public Object fromNative(Object nativeValue) throws OwException
    {
        try
        {
            String strNative = (String) nativeValue;
            XMLGregorianCalendar xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(strNative);
            return xmlDate.toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException e)
        {
            throw new OwServerException("Could not get java value from native value " + nativeValue, e);
        }
    }

    /* (non-Javadoc)
     * @see com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverter#fromJava(java.lang.Object)
     */
    public Object fromJava(Object javaValue) throws OwException
    {
        try
        {
            Date dateValue = (Date) javaValue;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(dateValue);
            XMLGregorianCalendar xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            return xmlDate.toXMLFormat();
        }
        catch (DatatypeConfigurationException e)
        {
            throw new OwServerException("Could not get native value from java value " + javaValue, e);
        }
    }

}
