/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwValueExpression;
import java.util.Arrays;
import java.util.List;

public class OwColumnReference
implements OwValueExpression {
    private OwColumnQualifier m_qualifier;
    private String m_columnName;

    public OwColumnReference(OwColumnQualifier qualifier_p, String columnName_p) {
        this.m_qualifier = qualifier_p;
        this.m_columnName = columnName_p;
    }

    @Override
    public StringBuilder createValueExpressionSQLString() {
        StringBuilder builder = new StringBuilder();
        if (this.m_qualifier != null && this.m_qualifier.getQualifierString() != null) {
            builder.append(this.m_qualifier.getQualifierString());
            builder.append(".");
        }
        builder.append(this.createColumnName());
        return builder;
    }

    protected String createColumnName() {
        return this.m_columnName;
    }

    public OwColumnQualifier getQualifier() {
        return this.m_qualifier;
    }

    @Override
    public List<OwColumnQualifier> getColumnQualifiers() {
        if (this.m_qualifier == null) {
            return Arrays.asList(new OwColumnQualifier[0]);
        }
        return Arrays.asList(this.m_qualifier);
    }

    public int hashCode() {
        return this.m_columnName.hashCode();
    }

    public boolean equals(Object obj_p) {
        if (obj_p instanceof OwColumnReference) {
            OwColumnReference refObj = (OwColumnReference)obj_p;
            if (refObj.m_columnName.equals(this.m_columnName)) {
                if (this.m_qualifier == null) {
                    return refObj.m_qualifier == null;
                }
                return this.m_qualifier.equals(refObj.m_qualifier);
            }
        }
        return false;
    }

    public String toString() {
        String str = this.m_columnName + "@";
        str = this.m_qualifier != null ? str + this.m_qualifier : str + "?";
        return str;
    }

    public String getColumnName() {
        return this.m_columnName;
    }
}

