/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwJoinSpecification;
import com.wewebu.ow.csqlc.ast.OwJoinType;
import com.wewebu.ow.csqlc.ast.OwTableReference;
import java.util.LinkedList;
import java.util.List;

public class OwJoinedTable
implements OwTableReference {
    public static final String JOIN = "JOIN";
    private OwTableReference m_tableReference1;
    private OwJoinType m_joinType = OwJoinType.DEFAULT_JOIN_TYPE;
    private OwTableReference m_tableReference2;
    private OwJoinSpecification m_joinSpecification;

    public OwJoinedTable(OwTableReference tableReference1_p, OwTableReference tableReference2_p, OwJoinSpecification joinSpecification_p) {
        this(tableReference1_p, OwJoinType.DEFAULT_JOIN_TYPE, tableReference2_p, joinSpecification_p);
    }

    public OwJoinedTable(OwTableReference tableReference1_p, OwJoinType joinType_p, OwTableReference tableReference2_p, OwJoinSpecification joinSpecification_p) {
        this.m_tableReference1 = tableReference1_p;
        this.m_joinType = joinType_p;
        this.m_tableReference2 = tableReference2_p;
        this.m_joinSpecification = joinSpecification_p;
    }

    @Override
    public StringBuilder createTableReferenceSQLString() {
        StringBuilder builder = this.m_tableReference1.createTableReferenceSQLString();
        builder.append(this.m_joinType.getSqlString());
        builder.append(" ");
        builder.append(this.m_joinSpecification.getType());
        builder.append(JOIN);
        builder.append(" ");
        builder.append((CharSequence)this.m_tableReference2.createTableReferenceSQLString());
        builder.append(" ");
        builder.append((CharSequence)this.m_joinSpecification.createJoinSpectificationSQLString());
        return builder;
    }

    @Override
    public List<OwColumnQualifier> getColumnQualifiers() {
        LinkedList<OwColumnQualifier> qualifiers = new LinkedList<OwColumnQualifier>(this.m_tableReference1.getColumnQualifiers());
        qualifiers.addAll(this.m_tableReference2.getColumnQualifiers());
        qualifiers.addAll(this.m_joinSpecification.getColumnQualifiers());
        return qualifiers;
    }

    @Override
    public OwColumnQualifier getMainTableQualifier() {
        return this.m_tableReference1.getMainTableQualifier();
    }
}

