/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwCharacterStringLiteral;
import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwColumnReference;
import com.wewebu.ow.csqlc.ast.OwFormatPredicate;
import com.wewebu.ow.csqlc.ast.OwPredicateFormat;
import java.util.LinkedList;
import java.util.List;

public class OwLikePredicate
extends OwFormatPredicate {
    public static final String LIKE = "LIKE";
    public static final String NOT_LIKE = "NOT LIKE";
    public static final String NOT = "NOT";
    private OwColumnReference m_columnReference;
    private OwCharacterStringLiteral m_characterStringLiteral;

    public OwLikePredicate(OwColumnReference columnReference_p, OwCharacterStringLiteral characterStringLiteral_p, OwPredicateFormat format_p) {
        this(columnReference_p, characterStringLiteral_p, false, format_p);
    }

    public OwLikePredicate(OwColumnReference columnReference_p, OwCharacterStringLiteral characterStringLiteral_p, boolean negated_p, OwPredicateFormat format_p) {
        super(format_p, negated_p);
        this.m_columnReference = columnReference_p;
        this.m_characterStringLiteral = characterStringLiteral_p;
        if (!this.m_characterStringLiteral.isNull() && !this.m_characterStringLiteral.contains('%', false)) {
            this.m_characterStringLiteral = this.m_characterStringLiteral.insert(0, "%").append("%");
        }
    }

    @Override
    public boolean isValid() {
        return !this.m_characterStringLiteral.isNull();
    }

    @Override
    public List<OwColumnQualifier> getColumnQualifiers() {
        if (this.isValid()) {
            return this.m_columnReference.getColumnQualifiers();
        }
        return new LinkedList<OwColumnQualifier>();
    }

    @Override
    protected StringBuilder createLeftOperand() {
        return this.m_columnReference.createValueExpressionSQLString();
    }

    @Override
    protected StringBuilder createRightOperand() {
        return this.m_characterStringLiteral.createLiteralSQLString();
    }
}

