/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwCorrelatedTableName;
import com.wewebu.ow.csqlc.ast.OwFromClause;
import com.wewebu.ow.csqlc.ast.OwJoinSpecification;
import com.wewebu.ow.csqlc.ast.OwSelectList;
import com.wewebu.ow.csqlc.ast.OwWhereClause;
import java.util.LinkedList;
import java.util.List;

public class OwSimpleTable {
    public static final String SELECT = "SELECT";
    public static final String TOP = "TOP";
    private OwSelectList m_selectList;
    private OwFromClause m_fromClause;
    private OwWhereClause m_whereClause;
    private Integer maxRows;

    public OwSimpleTable(OwSelectList selectList_p, OwFromClause fromClause_p) {
        this(selectList_p, fromClause_p, null, null);
    }

    public OwSimpleTable(OwSelectList selectList_p, OwFromClause fromClause_p, Integer maxRows) {
        this(selectList_p, fromClause_p, null, maxRows);
    }

    public OwSimpleTable(OwSelectList selectList_p, OwFromClause fromClause_p, OwWhereClause whereClause_p) {
        this.m_selectList = selectList_p;
        this.m_fromClause = fromClause_p;
        this.m_whereClause = whereClause_p;
    }

    public OwSimpleTable(OwSelectList selectList_p, OwFromClause fromClause_p, OwWhereClause whereClause_p, Integer maxRows) {
        this.m_selectList = selectList_p;
        this.m_fromClause = fromClause_p;
        this.m_whereClause = whereClause_p;
        this.maxRows = maxRows;
    }

    public StringBuilder createSimpleTableSQLString() {
        StringBuilder builder = this.m_selectList.createSelectListSQLString();
        builder.insert(0, " ");
        builder.insert(0, SELECT);
        builder.append(" ");
        builder.append((CharSequence)this.m_fromClause.createFromClauseSQLString());
        if (this.m_whereClause != null && this.m_whereClause.isValid()) {
            builder.append(" ");
            builder.append((CharSequence)this.m_whereClause.createWhereClauseSQLString());
        }
        return this.addRowLimit(builder);
    }

    protected StringBuilder addRowLimit(StringBuilder statement) {
        if (this.maxRows != null) {
            String limit = " " + TOP + " " + this.maxRows;
            statement.insert(SELECT.length(), limit);
        }
        return statement;
    }

    public List<OwColumnQualifier> getColumnQualifiers() {
        LinkedList<OwColumnQualifier> qualifiers = null;
        qualifiers = this.m_whereClause != null ? new LinkedList<OwColumnQualifier>(this.m_whereClause.getColumnQualifiers()) : new LinkedList<OwColumnQualifier>();
        qualifiers.addAll(this.m_fromClause.getColumnQualifiers());
        if (this.m_selectList != null) {
            qualifiers.addAll(this.m_selectList.getColumnQualifiers());
        }
        return qualifiers;
    }

    public OwColumnQualifier getMainTableQualifier() {
        return this.m_fromClause.getMainTableQualifier();
    }

    public void addJoin(OwCorrelatedTableName joinedTableReference_p, OwJoinSpecification joinSpec_p) {
        this.m_fromClause.addJoin(joinedTableReference_p, joinSpec_p);
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public OwSelectList getSelectList() {
        return this.m_selectList;
    }
}

