/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwCharacterStringLiteral;
import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwColumnReference;
import com.wewebu.ow.csqlc.ast.OwPredicate;
import java.util.LinkedList;
import java.util.List;

public class OwTextSearchPredicate
extends OwPredicate {
    protected OwColumnQualifier contentJoinedColumn;
    protected OwColumnReference columnReference;
    private OwCharacterStringLiteral searchExpression;
    private String dialect;

    public OwTextSearchPredicate(OwCharacterStringLiteral searchExpression_p, OwColumnReference columnReference_p, OwColumnQualifier contentJoinedColumn_p, String dialect_p) {
        this.searchExpression = searchExpression_p;
        this.columnReference = columnReference_p;
        this.dialect = dialect_p;
        this.contentJoinedColumn = contentJoinedColumn_p;
    }

    @Override
    public boolean isValid() {
        return this.getSearchExpression() != null && !this.getSearchExpression().isNull();
    }

    @Override
    public List<OwColumnQualifier> getColumnQualifiers() {
        if (this.isValid()) {
            LinkedList<OwColumnQualifier> qualifiers = new LinkedList<OwColumnQualifier>();
            if (this.contentJoinedColumn != null) {
                qualifiers.add(this.contentJoinedColumn);
            }
            if (this.columnReference != null) {
                qualifiers.addAll(this.columnReference.getColumnQualifiers());
            }
            return qualifiers;
        }
        return new LinkedList<OwColumnQualifier>();
    }

    @Override
    public StringBuilder createPredicateSQLString() {
        StringBuilder builder = this.getSearchExpression().createLiteralSQLString();
        if (this.getDialect() != null) {
            builder.append(",");
            builder.append(this.getDialect());
        }
        if (this.columnReference != null) {
            builder.insert(0, ",");
            builder.insert(0, this.columnReference.createValueExpressionSQLString());
        } else if (this.contentJoinedColumn != null && this.contentJoinedColumn.getQualifierString() != null) {
            builder.insert(0, ",");
            builder.insert(0, this.contentJoinedColumn.getQualifierString());
        }
        builder.insert(0, "CONTAINS(");
        builder.append(")");
        return builder;
    }

    protected OwCharacterStringLiteral getSearchExpression() {
        return this.searchExpression;
    }

    protected String getDialect() {
        return this.dialect;
    }
}

