/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOContext;
import com.wewebu.ow.server.ao.OwAOManager;
import com.wewebu.ow.server.ao.OwAOType;
import com.wewebu.ow.server.ao.OwConfigurableManager;
import com.wewebu.ow.server.ao.OwManagerConfiguration;
import com.wewebu.ow.server.ao.OwSupportsConfiguration;
import com.wewebu.ow.server.ecm.OwAttributeBagsSupport;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import java.util.Collection;
import org.apache.log4j.Logger;

public class OwAttributeBagsManager
implements OwAOManager,
OwConfigurableManager {
    private static final String INVERTED_PARAMETER = "inverted";
    private static final String SUPPORT_PARAMETER = "support";
    private static final Logger LOG = OwLogCore.getLogger(OwAttributeBagsManager.class);
    private OwAOType<?> aoType;
    private OwAttributeBagsSupport attributeBagsSupport;
    private boolean nameKey;
    private OwNetworkContext networkContext;

    public OwAttributeBagsManager() {
    }

    public OwAttributeBagsManager(OwNetworkContext networkContext_p, OwAOType<?> type_p, boolean nameKey_p, OwAttributeBagsSupport attributeBagsSupport_p) {
        this.initialize(networkContext_p, type_p, nameKey_p, attributeBagsSupport_p);
    }

    private void initialize(OwNetworkContext networkContext_p, OwAOType<?> type_p, boolean nameKey_p, OwAttributeBagsSupport attributeBagsSupport_p) {
        this.aoType = type_p;
        this.nameKey = nameKey_p;
        this.attributeBagsSupport = attributeBagsSupport_p;
        this.networkContext = networkContext_p;
    }

    @Override
    public Object getApplicationObject(String strName_p, Object param_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        if (!forceUserSpecificObject_p) {
            LOG.error((Object)"OwSimpleAttributeBagManager.getApplicationObject(): Attribute Bags are always user specific, set forceUserSpecificObject_p = true");
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwAOManager.invalid.application.object.request", "Invalid application object request!"));
        }
        try {
            if (this.nameKey) {
                return this.attributeBagsSupport.getNameKeyAttributeBag(this.networkContext, strName_p, (String)param_p);
            }
            return this.attributeBagsSupport.getUserKeyAttributeBagWriteable(this.networkContext, strName_p, (String)param_p);
        }
        catch (Exception e) {
            LOG.error((Object)"OwSimpleAttributeBagManager.getApplicationObject(): Attribute Bags are always user specific, set forceUserSpecificObject_p = true", (Throwable)e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwAOManager.invalid.application.object.request", "Invalid application object request!"), (Throwable)e);
        }
    }

    @Override
    public Object getApplicationObject(String strName_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        return this.getApplicationObject(strName_p, null, forceUserSpecificObject_p, createIfNotExist_p);
    }

    @Override
    public Collection<?> getApplicationObjects(String strName_p, boolean forceUserSpecificObject_p) throws OwException {
        LOG.fatal((Object)"OwAttributeBagsManager.getApplicationObjects():Not supported application object request!Could not retrieve attribute bag objects - not implemented !");
        throw new OwNotSupportedException(new OwString("ecmimpl.OwAOManager.not.supported.application.object.request", "Not supported application object request!"));
    }

    @Override
    public final int getManagedType() {
        return this.aoType.getType();
    }

    public final OwAOType<?> getType() {
        return this.aoType;
    }

    public String toString() {
        return "OwSimpleAttributeBagManager(type=" + this.aoType.getType() + ")->" + this.attributeBagsSupport;
    }

    @Override
    public void init(OwAOType<?> type, OwManagerConfiguration configuration, OwSupportsConfiguration supports, OwAOContext context) throws OwConfigurationException {
        try {
            String supportId = configuration.getParameterValue(SUPPORT_PARAMETER);
            OwAttributeBagsSupport support = supports.getSupport(supportId, OwAttributeBagsSupport.class);
            String invertedValue = configuration.getParameterValue(INVERTED_PARAMETER);
            boolean inverted = Boolean.parseBoolean(invertedValue);
            this.initialize(context.getNetwork().getContext(), type, inverted, support);
        }
        catch (OwInvalidOperationException e) {
            throw new OwConfigurationException("Bad sdupport reference.", (Throwable)e);
        }
    }
}

