/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOConfigurationPart;
import com.wewebu.ow.server.ao.OwAOContext;
import com.wewebu.ow.server.ao.OwConfigurableSupport;
import com.wewebu.ow.server.ao.OwSupportConfiguration;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwSupportsConfiguration
extends OwAOConfigurationPart {
    private static final Logger LOG = OwLogCore.getLogger(OwSupportsConfiguration.class);
    private Map<String, Object> supports;
    private OwXMLUtil configuration;

    public OwSupportsConfiguration(OwXMLUtil configuration, OwAOContext context) throws OwConfigurationException {
        super(configuration);
        this.configuration = configuration;
        this.supports = this.readSupports(configuration, Object.class, context);
    }

    private <S> Map<String, S> readSupports(OwXMLUtil supportsConfiguration, Class<S> supportClass, OwAOContext context) throws OwConfigurationException {
        HashMap<String, S> supports = new HashMap<String, S>();
        List supportConfigurations = supportsConfiguration.getSafeUtilList("Support");
        for (OwXMLUtil supportConfig : supportConfigurations) {
            String accessorClassName = supportConfig.getSafeStringAttributeValue("class", null);
            String accessorId = supportConfig.getSafeStringAttributeValue("id", null);
            if (accessorClassName != null && accessorId != null) {
                S accessor = this.safeInstanceFromName(accessorClassName, supportClass);
                if (accessor instanceof OwConfigurableSupport) {
                    OwConfigurableSupport configurableSupport = (OwConfigurableSupport)accessor;
                    configurableSupport.init(new OwSupportConfiguration(supportConfig), context);
                    LOG.debug((Object)("Loaded configurable AO support " + accessor));
                } else {
                    LOG.debug((Object)("Loaded non configurable AO support " + accessor));
                }
                supports.put(accessorId, accessor);
                continue;
            }
            throw new OwConfigurationException("Invalid supports configuration.");
        }
        return supports;
    }

    public <S> S getSupport(String id, Class<S> supportClass) throws OwInvalidOperationException {
        Object support = this.supports.get(id);
        if (!supportClass.isAssignableFrom(support.getClass())) {
            throw new OwInvalidOperationException("Unexpected support class " + support.getClass() + ". Requested class was " + supportClass);
        }
        return (S)support;
    }
}

