/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOContext;
import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ao.OwAOType;
import com.wewebu.ow.server.ao.OwManagerConfiguration;
import com.wewebu.ow.server.ao.OwSupportBasedManager;
import com.wewebu.ow.server.ao.OwSupportsConfiguration;
import com.wewebu.ow.server.ao.OwVirtualFolderFactory;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.OwAOConstants;
import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OwVirtualFoldersManager
extends OwSupportBasedManager {
    private static final Logger LOG = OwLogCore.getLogger(OwVirtualFoldersManager.class);
    public static final String DEFAULT_BASE_PATH = "other";
    private OwVirtualFolderFactory virtualFolderFactory;
    private OwRoleManager roleManager;

    public OwVirtualFoldersManager() {
    }

    public OwVirtualFoldersManager(OwAOSupport aoSupport_p, OwVirtualFolderFactory virtualFolderFactory_p) {
        this(aoSupport_p, virtualFolderFactory_p, null, DEFAULT_BASE_PATH);
    }

    public OwVirtualFoldersManager(OwAOSupport aoSupport_p, OwVirtualFolderFactory virtualFolderFactory_p, OwRoleManager roleManager_p, String basePath_p) {
        super(aoSupport_p, basePath_p != null ? basePath_p : DEFAULT_BASE_PATH);
        this.virtualFolderFactory = virtualFolderFactory_p;
        this.roleManager = roleManager_p;
    }

    private OwObject toVirtualFolder(OwObject supportObject_p, String strName_p) throws OwException {
        try {
            OwContentCollection contentCollection = supportObject_p.getContentCollection();
            OwContentElement firstElement = contentCollection.getContentElement(1, 1);
            InputStream contentStream = firstElement.getContentStream(null);
            Document xmlDocument = null;
            xmlDocument = OwXMLDOMUtil.getDocumentFromInputStream(contentStream);
            Node xmlFirstChild = xmlDocument.getFirstChild();
            return this.virtualFolderFactory.createVirtualFolder(xmlFirstChild, strName_p, null);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.fatal((Object)"OwVirtualFolderManager.getApplicationObject():Could not create virtual folder application object!", (Throwable)e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwAOManager.invalid.application.object.request", "Invalid application object request!"), (Throwable)e);
        }
    }

    @Override
    public OwObject getApplicationObject(String strName_p, Object param_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        if (param_p != null) {
            LOG.error((Object)"OwVirtualFolderManager.getApplicationObject():Could not process non null search template parameter - not implemented !");
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwAOManager.invalid.application.object.request", "Invalid application object request!"));
        }
        boolean allowed = false;
        try {
            if (this.roleManager != null) {
                allowed = this.roleManager.isAllowed(12, strName_p);
            }
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Could not create application object.", (Throwable)e);
        }
        if (allowed) {
            OwObject supportObject = this.getAOSupportObject(strName_p, forceUserSpecificObject_p, createIfNotExist_p);
            return this.toVirtualFolder(supportObject, strName_p);
        }
        LOG.warn((Object)("OwVirtualFoldersManager.getApplicationObject : Access to virtual folder " + strName_p + " was denied."));
        throw new OwAccessDeniedException(new OwString1("app.OwAOProvider.acces.denied", "Access to the application object %1 was denied", strName_p));
    }

    @Override
    public final OwObject getApplicationObject(String strName_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        return this.getApplicationObject(strName_p, null, forceUserSpecificObject_p, createIfNotExist_p);
    }

    public List<OwObject> getApplicationObjects(String strName_p, boolean forceUserSpecificObject_p) throws OwException {
        LinkedList<OwObject> virtualFolders = new LinkedList<OwObject>();
        if (forceUserSpecificObject_p && this.roleManager != null) {
            try {
                Collection allowedVirtualFolders = this.roleManager.getAllowedResources(12);
                for (String virtualFolderName : allowedVirtualFolders) {
                    OwObject virtualFolder = this.getApplicationObject(virtualFolderName, forceUserSpecificObject_p, false);
                    virtualFolders.add(virtualFolder);
                }
            }
            catch (OwException e) {
                throw e;
            }
            catch (Exception e) {
                throw new OwInvalidOperationException("Could not create application objects.", (Throwable)e);
            }
        } else {
            OwObject[] supportObjects;
            for (OwObject supportObject : supportObjects = this.getAOSupportObjects("", forceUserSpecificObject_p, false)) {
                try {
                    OwObject virtualFolder = this.toVirtualFolder(supportObject, supportObject.getName());
                    virtualFolders.add(virtualFolder);
                }
                catch (OwInvalidOperationException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Creation of virtual folder faild", (Throwable)e);
                }
            }
        }
        return virtualFolders;
    }

    @Override
    public final int getManagedType() {
        return 1;
    }

    public final OwAOType<?> getType() {
        return OwAOConstants.AO_VIRTUAL_FOLDER;
    }

    @Override
    public void init(OwAOType<?> type, OwManagerConfiguration configuration, OwSupportsConfiguration supports, OwAOContext context) throws OwConfigurationException {
        super.init(type, configuration, supports, context);
        this.virtualFolderFactory = (OwVirtualFolderFactory)((Object)context.getNetwork());
        this.roleManager = context.isRoleManaged() ? context.getNetwork().getRoleManager() : null;
    }

    @Override
    public String toString() {
        return "OwVirtualFoldersManager(virtualFolderFactory=" + this.virtualFolderFactory + ")->" + super.toString();
    }
}

