/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.log.OwLogCore;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OwAppVersion {
    private static final Logger LOG = OwLogCore.getLogger(OwAppVersion.class);
    private static final String PROP_VERSION = "version";
    private static final String PROP_BUILDNUMBER = "buildNumber";
    private static final String PROP_EDITION = "edition";
    private String versionString;
    private String buildNumber;
    private String editionString;

    private OwAppVersion(String versionString, String buildNumber, String edition) {
        this.versionString = versionString;
        this.buildNumber = buildNumber;
        this.editionString = edition;
    }

    public static OwAppVersion unknownVersion() {
        return new OwAppVersion("default.OwMainLayout.jsp.footer.versionString", "", "default.OwMainLayout.jsp.footer.development");
    }

    public static OwAppVersion fromProperties(Properties properties) {
        String versionString = properties.getProperty(PROP_VERSION);
        String buildNumberString = properties.getProperty(PROP_BUILDNUMBER);
        String editionString = properties.getProperty(PROP_EDITION);
        return new OwAppVersion(versionString, buildNumberString, editionString);
    }

    public static OwAppVersion fromProperties(URL versionPropertiesURL) {
        if (null == versionPropertiesURL) {
            throw new IllegalArgumentException("versionPropertiesURL can not be null !");
        }
        Properties versionProperties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = versionPropertiesURL.openStream();
            versionProperties.load(inputStream);
            OwAppVersion owAppVersion = OwAppVersion.fromProperties(versionProperties);
            return owAppVersion;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read version information !", e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Could not close stream !", (Throwable)e);
                }
            }
        }
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getEditionString() {
        return this.editionString;
    }
}

