/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwComboModel;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class OwBaseComboboxRenderer
implements OwComboboxRenderer {
    protected OwMainAppContext m_context = null;
    protected OwComboModel m_model = null;
    protected String m_fieldId = null;
    protected OwFieldDefinition m_fieldDefinition = null;
    protected OwFieldProvider m_fieldProvider = null;
    protected boolean m_ignoreDefaultStylesheets;
    protected boolean enabled = true;
    protected OwString m_description;
    protected Map m_events = new HashMap();
    protected static final Logger LOG = OwLogCore.getLogger(OwBaseComboboxRenderer.class);
    protected Set m_styleClasses = new LinkedHashSet();

    @Override
    public void setEnabled(boolean enabled_p) {
        this.enabled = enabled_p;
    }

    protected String renderStyleClasses(Set defaultStyleClasses_p) {
        StringBuffer result = new StringBuffer();
        result.append("class=\"");
        if (!this.m_ignoreDefaultStylesheets) {
            for (String styleClass : defaultStyleClasses_p) {
                result.append(styleClass);
                result.append(" ");
            }
        }
        if (this.m_fieldDefinition != null) {
            result.append(" OwInputControl_");
            result.append(this.m_fieldDefinition.getClassName());
        }
        for (String styleClass : this.m_styleClasses) {
            result.append(styleClass);
            result.append(" ");
        }
        result.append("\" ");
        return result.toString();
    }

    protected OwMainAppContext getContext() {
        return this.m_context;
    }

    @Override
    public void addStyleClass(String styleClass_p) {
        this.m_styleClasses.add(styleClass_p);
    }

    @Override
    public void addStyleClass(String styleClass_p, boolean ignoreDefaultStyleClasses_p) {
        this.m_ignoreDefaultStylesheets = ignoreDefaultStyleClasses_p;
        this.m_styleClasses.add(styleClass_p);
    }

    @Override
    public void addStyleClasses(String[] styleClasses_p) {
        this.m_styleClasses.addAll(Arrays.asList(styleClasses_p));
    }

    @Override
    public void addStyleClasses(String[] styleClasses_p, boolean ignoreDefaultStyleClasses_p) {
        this.m_ignoreDefaultStylesheets = ignoreDefaultStyleClasses_p;
        this.m_styleClasses.addAll(Arrays.asList(styleClasses_p));
    }

    @Override
    public void addEvent(String eventName_p, String eventHandler_p) {
        this.m_events.put(eventName_p, eventHandler_p);
    }

    @Override
    public String[] getAllEventsNames() {
        return this.m_events.keySet().toArray(new String[this.m_events.size()]);
    }

    protected String getEventHandler(String eventName_p) {
        return eventName_p == null ? null : (String)this.m_events.get(eventName_p);
    }

    @Override
    public void setContext(OwMainAppContext context_p) {
        this.m_context = context_p;
    }

    @Override
    public void setModel(OwComboModel model_p) {
        this.m_model = model_p;
    }

    @Override
    public void setFieldDescription(OwString description_p) {
        this.m_description = description_p;
    }

    @Override
    public void setFieldId(String fieldId_p) {
        this.m_fieldId = fieldId_p;
    }

    @Override
    public void setFieldDefinition(OwFieldDefinition fieldDefinition_p) {
        this.m_fieldDefinition = fieldDefinition_p;
    }

    @Override
    public void setFieldProvider(OwFieldProvider fieldProvider_p) {
        this.m_fieldProvider = fieldProvider_p;
    }
}

