/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwClipboardContentOwField;
import com.wewebu.ow.server.app.OwClipboardContentOwObject;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwField;
import java.util.LinkedList;
import java.util.List;

public class OwClipboard {
    public static final int CONTENT_TYPE_EMPTY = 0;
    public static final int CONTENT_TYPE_OW_OBJECT = 1;
    public static final int CONTENT_TYPE_OW_WORKITEM = 2;
    public static final int CONTENT_TYPE_OW_FIELD = 3;
    public static final OwClipboardOperation COPY = new OwClipboardOperation(){

        @Override
        public boolean isCutOperation() {
            return false;
        }

        @Override
        public boolean isCopyOperation() {
            return true;
        }
    };
    public static final OwClipboardOperation CUT = new OwClipboardOperation(){

        @Override
        public boolean isCutOperation() {
            return true;
        }

        @Override
        public boolean isCopyOperation() {
            return false;
        }
    };
    protected int m_iContentType = 0;
    protected List<OwClipboardContent> m_contentList = new LinkedList<OwClipboardContent>();
    private boolean m_fCut = false;
    private OwMainAppContext m_context;

    public List<OwClipboardContent> getContent() {
        return this.m_contentList;
    }

    public void setContent(OwObject content_p, OwObject parent_p) throws Exception {
        this.m_contentList.clear();
        this.m_contentList.add(new OwClipboardContentOwObject(content_p, parent_p));
        this.m_iContentType = 1;
        this.setCut(false);
    }

    public void setCut() {
        this.setCut(true);
    }

    public void setCut(boolean flag_p) {
        this.m_fCut = flag_p;
    }

    public boolean getCut() {
        return this.m_fCut;
    }

    public void setContent(List clipboarditems_p, int iContenttype_p) {
        this.m_contentList = clipboarditems_p;
        this.m_iContentType = iContenttype_p;
        this.m_fCut = false;
    }

    public void addContent(OwObject content_p, OwObject parent_p) throws Exception {
        if (this.m_iContentType != 0 && this.m_iContentType != 1) {
            throw new OwInvalidOperationException("Mixing contenttype in clipboard not allowed");
        }
        OwClipboardContentOwObject clipboardContentObject = new OwClipboardContentOwObject(content_p, parent_p);
        if (!this.m_contentList.contains(clipboardContentObject)) {
            this.m_contentList.add(clipboardContentObject);
            this.m_iContentType = 1;
        }
    }

    public void clearContent() {
        this.m_contentList.clear();
        this.m_iContentType = 0;
        this.m_fCut = false;
    }

    public int getContentType() {
        return this.m_iContentType;
    }

    public void addContent(OwField content_p) throws Exception {
        if (this.m_iContentType != 0 && this.m_iContentType != 3) {
            throw new OwInvalidOperationException("Mixing contentype in clipboard not allowed");
        }
        this.m_contentList.add(new OwClipboardContentOwField(content_p));
        this.m_iContentType = 3;
        this.m_fCut = false;
    }

    public void setContent(OwField content_p) throws Exception {
        if (this.m_iContentType != 0) {
            this.clearContent();
        }
        this.addContent(content_p);
    }

    public boolean canAdd() {
        int size = this.getContent() != null ? this.getContent().size() : 0;
        int maxClipboardSize = this.m_context.getMaxClipboardSize();
        return size < maxClipboardSize;
    }

    public void postWarningMessage() {
        String localizedWarningMessage = this.m_context.localize("com.wewebu.ow.server.app.OwClipboard.cannotadd", "You can not add more items to the clipboard, the maximum clipboard size is exceeded.");
        this.m_context.postMessage(localizedWarningMessage);
    }

    public void init(OwMainAppContext owMainAppContext_p) {
        this.m_context = owMainAppContext_p;
    }

    public static interface OwClipboardContent {
    }

    public static interface OwClipboardOperation {
        public boolean isCutOperation();

        public boolean isCopyOperation();
    }
}

