/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardContentOwField;
import com.wewebu.ow.server.app.OwClipboardContentOwObject;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwClipboardView
extends OwView {
    private static final String PLUGIN_ID_PARAMETER = "PLUGIN_ID";
    private static final Logger LOG = OwLogCore.getLogger(OwClipboardView.class);
    protected OwMimeManager m_MimeManager = new OwMimeManager();

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_MimeManager.attach(this.getContext(), null);
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
        switch (clipboard.getContentType()) {
            case 1: {
                this.renderOwObjectContentType(w_p, clipboard);
                break;
            }
            case 2: {
                this.renderOwWorkitemContentType(w_p, clipboard);
                break;
            }
            case 3: {
                this.renderOwFieldContentType(w_p, clipboard);
            }
        }
    }

    private void renderOwWorkitemContentType(Writer w_p, OwClipboard clipboard_p) throws Exception {
        throw new OwNotSupportedException("OwClipboardView.renderOwWorkitemContentType: Not implemented");
    }

    private void renderOwObjectContentType(Writer w_p, OwClipboard clipboard_p) throws Exception {
        this.m_MimeManager.reset();
        List<OwClipboard.OwClipboardContent> contentItems = clipboard_p.getContent();
        if (contentItems.size() > 0) {
            w_p.write("<div class='OwClipboardView'>");
            w_p.write("<span>" + this.getContext().localize("app.OwClipboardView.title", "Clipboard"));
            if (clipboard_p.getCut()) {
                String tooltip = this.getContext().localize("app.OwClipboardView.cuttooltip", "The content will be moved when pasted.");
                w_p.write("&nbsp;(<img alt='" + tooltip + "' title='" + tooltip + "' src='" + this.getContext().getDesignURL() + "/images/plug/owdoccopy/cut.png'>)");
            }
            if (contentItems.size() > 1) {
                w_p.write(" (" + String.valueOf(contentItems.size()) + ")");
            }
            w_p.write(":</span><ul>");
            for (int i = 0; i < contentItems.size(); ++i) {
                if (i > 2) {
                    w_p.write("<li class='OwClipboardView'>...</li>");
                    break;
                }
                OwObject obj = ((OwClipboardContentOwObject)contentItems.get(i)).getObject();
                w_p.write("<li>");
                this.m_MimeManager.insertIconLink(w_p, obj);
                this.m_MimeManager.insertTextLink(w_p, obj.getName(), obj);
                w_p.write("</li>");
            }
            w_p.write("</ul>");
            w_p.write(this.getClearButton());
            this.renderPluginButtons(w_p);
            w_p.write("</div>");
        }
    }

    private void renderPluginButtons(Writer w_p) throws Exception {
        Collection pluginIds = ((OwMainAppContext)this.getContext()).getClipboardAvailableDocFunctionIds();
        for (String pluginId : pluginIds) {
            try {
                OwDocumentFunction plugIn = ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunction(pluginId);
                w_p.write("<a href=\"" + this.getEventURL("ClipboardPluginEvent", "PLUGIN_ID=" + pluginId) + "\">");
                String title = plugIn.getTooltip();
                w_p.write("<img title='" + title + "' alt='" + title + "' src='" + plugIn.getIcon() + "' />");
                w_p.write("</a>");
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot render the plugin: " + pluginId), (Throwable)e);
            }
        }
    }

    protected void renderOwFieldContentType(Writer w_p, OwClipboard clipboard_p) throws Exception {
        String icon = this.getContext().getDesignURL() + "/images/plug/owdocprops/info.png";
        List<OwClipboard.OwClipboardContent> contentItems = clipboard_p.getContent();
        if (contentItems != null && contentItems.size() > 0) {
            w_p.write("<div class=\"OwClipboardView\" ");
            w_p.write("<span>");
            w_p.write(this.getContext().localize("app.OwClipboardView.title", "Clipboard"));
            if (contentItems.size() > 3) {
                w_p.write(contentItems.size() + ")");
            }
            w_p.write(":</span><ul>\n");
            OwFieldManager fieldManager = ((OwMainAppContext)this.getContext()).createFieldManager();
            for (int i = 0; i < contentItems.size(); ++i) {
                if (i > 2) {
                    w_p.write("<li class=\"OwClipboardView\">...</li>");
                    break;
                }
                OwField elem = ((OwClipboardContentOwField)contentItems.get(i)).getField();
                w_p.write("<li class=\"OwClipboardView\" title=\"");
                w_p.write(elem.getFieldDefinition().getClassName());
                w_p.write("\"><img alt='' title='' src=\"");
                w_p.write(icon);
                w_p.write("\">&nbsp;");
                w_p.write(elem.getFieldDefinition().getDisplayName(this.getContext().getLocale()));
                w_p.write("&nbsp;=&nbsp;");
                fieldManager.insertReadOnlyFieldInternal(w_p, elem.getFieldDefinition(), elem.getValue());
                w_p.write("</li>\n");
            }
            w_p.write("</ul>");
            w_p.write(this.getClearButton());
            w_p.write("</div>");
        }
    }

    public String getClearButton() {
        StringBuffer buf = new StringBuffer("<a href=\"");
        buf.append(this.getContext().getEventURL(this, "ClearClipboard", null));
        buf.append("\"><img src=\"");
        try {
            buf.append(this.getContext().getDesignURL());
        }
        catch (Exception e) {
            buf.append("./designs/default41");
        }
        buf.append("/images/clipboard_delete.png\" title=\"");
        String title = this.getContext().localize("app.OwClipboardView.deletebtn.title", "Clear Clipboard");
        buf.append(title);
        buf.append("\" alt=\"" + title + "\"/> </a>");
        return buf.toString();
    }

    public void onClearClipboard(HttpServletRequest req_p) {
        ((OwMainAppContext)this.getContext()).getClipboard().clearContent();
    }

    public void onClipboardPluginEvent(HttpServletRequest request_p) throws Exception {
        int size;
        OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
        List<OwClipboard.OwClipboardContent> items = clipboard.getContent();
        int n = size = items != null ? items.size() : 0;
        if (size == 0) {
            return;
        }
        OwDocumentFunction plugIn = null;
        try {
            String pluginId = request_p.getParameter(PLUGIN_ID_PARAMETER);
            plugIn = ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunction(pluginId);
        }
        catch (Exception e) {
            LOG.error((Object)"OwClipboardView.onClipboardPluginEvent: Send as attachment plugin not found. Please check your configuration.", (Throwable)e);
            throw new OwInvalidOperationException(this.getContext().localize("app.OwClipboardView.exception.plugin_not_found", "The plugin to send e-mail attachments was not found. Please contact your administrator."), (Throwable)e);
        }
        if (plugIn != null) {
            if (size == 1) {
                plugIn.onClickEvent(((OwClipboardContentOwObject)items.get(0)).getObject(), null, null);
            } else if (size > 1) {
                LinkedList<OwObject> owObjectsList = new LinkedList<OwObject>();
                for (OwClipboardContentOwObject owClipboardContentOwObject : items) {
                    owObjectsList.add(owClipboardContentOwObject.getObject());
                }
                plugIn.onMultiselectClickEvent(owObjectsList, null, null);
            }
        }
    }
}

