/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwEditablePropertyString;
import com.wewebu.ow.server.app.OwFieldManagerException;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwEditablePropertyDate
extends OwEditablePropertyString {
    private static final Logger LOG = OwLogCore.getLogger(OwEditablePropertyDate.class);
    public static final int TYPE_DATE = 1;
    public static final int TYPE_TIME = 2;
    public static final int TYPE_EMPTY_DATE_POSSIBLE = 4;
    protected OwMainAppContext m_context;
    protected String m_sDateFormatString;
    private boolean ignoreTime = true;
    private static OwDateControlListItemsSingleton m_ListItems = new OwDateControlListItemsSingleton();

    public static void insertEditHTML(OwMainAppContext context_p, Locale locale_p, Writer w_p, Date date_p, String strID_p, boolean fUseJS_Control_p, boolean fEmptyDataPossible_p, String sDateFormat_p) throws Exception {
        OwEditablePropertyDate.insertEditHTML(context_p, locale_p, w_p, date_p, strID_p, fUseJS_Control_p, fEmptyDataPossible_p, sDateFormat_p, null);
    }

    public static void insertEditHTML(OwMainAppContext context_p, Locale locale_p, Writer w_p, Date date_p, String strID_p, boolean fUseJS_Control_p, boolean fEmptyDataPossible_p, String sDateFormat_p, String timeFormat) throws Exception {
        if (!fUseJS_Control_p) {
            OwEditablePropertyDate.insertNonJSControl(context_p, locale_p, w_p, date_p, strID_p, fEmptyDataPossible_p, timeFormat);
        } else {
            OwEditablePropertyDate.insertJSControl(context_p, locale_p, w_p, date_p, strID_p, fEmptyDataPossible_p, sDateFormat_p);
        }
    }

    public static void insertJSControl(OwMainAppContext context_p, Locale locale_p, Writer w_p, Date date_p, String strID_p, boolean fEmptyDataPossible_p, String sDateFormat_p) throws IOException, Exception {
        Node node;
        String strID = OwEditablePropertyDate.buildControlId(strID_p);
        Calendar calendar = OwEditablePropertyDate.buildCalendar(date_p);
        w_p.write("<script type=\"text/javascript\">\n");
        w_p.write("Ext.BLANK_IMAGE_URL = \"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(context_p.getBaseURL() + "/js/extjs/resources/images/default/s.gif"));
        w_p.write("\";\n");
        String[] months = new String[12];
        System.arraycopy(OwDateTimeUtil.getMonthNames(locale_p), 0, months, 0, 12);
        w_p.write("Date.monthNames =\n");
        OwEditablePropertyDate.writeJSArrayValues(w_p, months);
        OwEditablePropertyDate.writeDateJSMonthNumbersMap(locale_p, w_p);
        w_p.write("Date.dayNames =\n");
        String[] weekDays = new String[7];
        System.arraycopy(OwDateTimeUtil.getWeekDays(locale_p), 1, weekDays, 0, 7);
        OwEditablePropertyDate.writeJSArrayValues(w_p, weekDays);
        OwEditablePropertyDate.writeDateJSHelperFunctions(w_p);
        w_p.write("if(Ext.DatePicker){\n");
        w_p.write("   Ext.apply(Ext.DatePicker.prototype, {\n");
        Node fieldManagerNode = context_p.getConfiguration().getFieldManagerConfiguration().getNode();
        if (fieldManagerNode != null && (node = OwXMLDOMUtil.getChildNode(fieldManagerNode, "DatePickerStartDay")) != null) {
            String startDay = node.getFirstChild().getNodeValue().trim();
            w_p.write("      startDay : " + startDay + ",\n");
        }
        String jsEncJsDate = OwHTMLHelper.encodeJavascriptString(OwEditablePropertyDate.convertDateFormat(sDateFormat_p));
        w_p.write("      todayText         : \"" + OwString.localize(locale_p, "app.OwEditablePropertyDate.Today", "Today") + "\",\n");
        w_p.write("      minText           : \"" + OwString.localize(locale_p, "app.OwEditablePropertyDate.BeforeMinimumDate", "This date is below the minimum date.") + "\",\n");
        w_p.write("      maxText           : \"" + OwString.localize(locale_p, "app.OwEditablePropertyDate.AfterMaximumDate", "This date exceeds the maximum date.") + "\",\n");
        w_p.write("      okText            : \"" + OwString.localize(locale_p, "app.OwEditablePropertyDate.okText", "OK") + "\",\n");
        w_p.write("      cancelText        : \"" + OwString.localize(locale_p, "app.OwEditablePropertyDate.cancelText", "Cancel") + "\",\n");
        w_p.write("      disabledDaysText  : \"\",\n");
        w_p.write("      disabledDatesText : \"\",\n");
        w_p.write("      monthNames        : Date.monthNames,\n");
        w_p.write("      dayNames          : Date.dayNames,\n");
        w_p.write("      nextText          : \"" + OwString.localize(locale_p, "app.OwEditablePropertyDate.NextMonth", "Next Month (Ctrl+Right)") + "\",\n");
        w_p.write("      prevText          : \"" + OwString.localize(locale_p, "app.OwEditablePropertyDate.PreviousMonth", "Previous Month (Ctrl+Left)") + "\",\n");
        w_p.write("      monthYearText     : \"" + OwString.localize(locale_p, "app.OwEditablePropertyDate.ChooseMonth", "Select a month (Ctrl+Up/Down to change the years)") + "\",\n");
        w_p.write("      todayTip          : \"" + OwString.localize(locale_p, "app.OwEditablePropertyDate.Spacebar", "{0} (space bar)") + "\",\n");
        w_p.write("      format            : \"" + jsEncJsDate + "\",\n");
        w_p.write("      altFormats        : \"" + jsEncJsDate + "\"\n");
        w_p.write("   });\n");
        w_p.write("}\n");
        w_p.write("</script>\n");
        String formatedDate = "";
        if (!fEmptyDataPossible_p || date_p != null) {
            SimpleDateFormat dateFormat = OwDateTimeUtil.createDateFromat(locale_p, sDateFormat_p);
            formatedDate = dateFormat.format(calendar.getTime());
        }
        StringWriter htmlEncId = new StringWriter();
        OwHTMLHelper.writeSecureHTML(htmlEncId, strID);
        w_p.write("<input title='(");
        OwHTMLHelper.writeSecureHTML(w_p, sDateFormat_p);
        w_p.write(")' class='OwInputControl OwInputControlDate OwAjaxComponent' id='");
        w_p.write(htmlEncId.getBuffer().toString());
        w_p.write("' value='");
        OwHTMLHelper.writeSecureHTML(w_p, formatedDate);
        w_p.write("' name='");
        w_p.write(htmlEncId.getBuffer().toString());
        w_p.write("'>\n");
        String varName = "converted_" + OwHTMLHelper.encodeJavascriptString(strID);
        w_p.write("<script type=\"text/javascript\">\n");
        w_p.write("     Ext.onReady(function(){\n");
        w_p.write("     var " + varName + " = new Ext.form.DateField({\n");
        w_p.write("         allowBlank: " + (fEmptyDataPossible_p ? "true" : "false") + ",\n");
        w_p.write("         format: '" + jsEncJsDate + "',\n");
        w_p.write("         altFormats: '" + OwEditablePropertyDate.convertToAlternativeDateFormat(jsEncJsDate) + "',\n");
        w_p.write("         enableKeyEvents: true,\n");
        w_p.write("         hideMode: 'visibility'\n");
        w_p.write("     });\n");
        w_p.write("     " + varName + ".applyToMarkup('");
        w_p.write(htmlEncId.getBuffer().toString());
        w_p.write("');\n");
        w_p.write("     });\n");
        w_p.write("</script>\n");
    }

    private static String buildControlId(String strID_p) {
        String strID = strID_p.startsWith("-") ? strID_p.replace('-', '_') : strID_p;
        return strID;
    }

    public static void insertNonJSControl(OwMainAppContext context_p, Locale locale_p, Writer w_p, Date date_p, String strID_p, boolean fEmptyDataPossible_p, String timerFormat) throws IOException, Exception {
        String strID = OwEditablePropertyDate.buildControlId(strID_p);
        Calendar calendar = OwEditablePropertyDate.buildCalendar(date_p);
        w_p.write("<table border='0' cellpadding='0' cellspacing='0'>\r\n");
        w_p.write("<tr>\r\n");
        if (fEmptyDataPossible_p) {
            w_p.write("<td>");
            w_p.write("<input class='OwInputControl OwInputControlDate' name='EN_");
            OwHTMLHelper.writeSecureHTML(w_p, strID);
            w_p.write("' type='checkbox'");
            if (date_p != null) {
                w_p.write(" checked ");
            }
            w_p.write("></input>&nbsp;&nbsp;");
            w_p.write("</td>\r\n");
        }
        w_p.write("<td>");
        OwEditablePropertyDate.renderChoiceList(locale_p, w_p, m_ListItems.m_Time_Days, "D_" + strID, String.valueOf(calendar.get(5)));
        w_p.write("</td>\r\n");
        w_p.write("<td>");
        OwEditablePropertyDate.renderChoiceList(locale_p, w_p, m_ListItems.m_Time_Month, "M_" + strID, String.valueOf(calendar.get(2)));
        w_p.write("</td>\r\n");
        w_p.write("<td>");
        OwEditablePropertyDate.renderChoiceList(locale_p, w_p, m_ListItems.m_Time_Years, "Y_" + strID, String.valueOf(calendar.get(1)));
        w_p.write("</td>\r\n");
        if (null != timerFormat) {
            w_p.write("<td>");
            String timeId = "T_" + strID;
            SimpleDateFormat format = new SimpleDateFormat(timerFormat);
            String value = format.format(calendar.getTime());
            w_p.write("<input type='text' size='" + value.length() + "' name='" + timeId + "' value='" + value + "'/>");
            w_p.write("</td>\r\n");
        }
        w_p.write("</tr>\r\n");
        w_p.write("</table>");
    }

    private static Calendar buildCalendar(Date date_p) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (null == date_p) {
            calendar.setTime(new Date());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        } else {
            calendar.setTime(date_p);
        }
        return calendar;
    }

    private static String convertToAlternativeDateFormat(String dateFormat_p) {
        String altJsEncJsDate = dateFormat_p.replace(".", "");
        altJsEncJsDate = altJsEncJsDate.replace(":", "");
        altJsEncJsDate = altJsEncJsDate.replace("/", "");
        altJsEncJsDate = altJsEncJsDate.replace("-", "");
        return altJsEncJsDate;
    }

    private static void writeDateJSHelperFunctions(Writer w_p) throws IOException {
        w_p.write("Date.getShortMonthName = function(month) {\n");
        w_p.write("     return Date.monthNames[month].substring(0, 3);\n");
        w_p.write("};\n");
        w_p.write("Date.getMonthNumber = function(name) {\n");
        w_p.write("     return Date.monthNumbers[name.substring(0, 3)];\n");
        w_p.write("};\n");
        w_p.write("Date.getShortDayName = function(day) {\n");
        w_p.write("      return Date.dayNames[day].substring(0, 3);\n");
        w_p.write("};\n");
    }

    private static void writeDateJSMonthNumbersMap(Locale locale_p, Writer w_p) throws IOException {
        String[] shortMonthNames = new String[12];
        System.arraycopy(OwDateTimeUtil.getShortMonthNames(locale_p), 0, shortMonthNames, 0, 12);
        w_p.write("Date.monthNumbers =\n");
        w_p.write("{");
        for (int i = 0; i < shortMonthNames.length; ++i) {
            w_p.write(shortMonthNames[i] + ":" + i);
            if (i < shortMonthNames.length - 1) {
                w_p.write(" ,\n");
                continue;
            }
            w_p.write("\n};\n");
        }
    }

    private static void writeJSArrayValues(Writer w_p, String[] values_p) throws IOException {
        w_p.write("[");
        for (int i = 0; i < values_p.length; ++i) {
            w_p.write("'" + values_p[i] + "'");
            if (i < values_p.length - 1) {
                w_p.write(" ,\n");
                continue;
            }
            w_p.write("\n];\n");
        }
    }

    public static String convertDateFormat(String javaSimpleDateFormat_p) {
        StringBuffer sPhpDateFormat = new StringBuffer();
        int iPos = 0;
        while (iPos < javaSimpleDateFormat_p.length()) {
            int iNextPatternStartPos;
            char cCurrentPattern = javaSimpleDateFormat_p.charAt(iPos);
            for (iNextPatternStartPos = iPos; iNextPatternStartPos < javaSimpleDateFormat_p.length() && javaSimpleDateFormat_p.charAt(iNextPatternStartPos) == cCurrentPattern; ++iNextPatternStartPos) {
            }
            int iPatternLength = iNextPatternStartPos - iPos;
            block0 : switch (cCurrentPattern) {
                case 'G': {
                    sPhpDateFormat.append("\\A\\D");
                    break;
                }
                case 'y': {
                    if (iPatternLength <= 2) {
                        sPhpDateFormat.append('y');
                        break;
                    }
                    sPhpDateFormat.append('Y');
                    break;
                }
                case 'M': {
                    switch (iPatternLength) {
                        case 0: 
                        case 1: {
                            sPhpDateFormat.append('n');
                            break block0;
                        }
                        case 2: {
                            sPhpDateFormat.append('m');
                            break block0;
                        }
                        case 3: {
                            sPhpDateFormat.append('M');
                            break block0;
                        }
                    }
                    sPhpDateFormat.append('F');
                    break;
                }
                case 'w': {
                    sPhpDateFormat.append('W');
                    break;
                }
                case 'W': {
                    break;
                }
                case 'D': {
                    break;
                }
                case 'd': {
                    if (iPatternLength <= 1) {
                        sPhpDateFormat.append('j');
                        break;
                    }
                    sPhpDateFormat.append('d');
                    break;
                }
                case 'F': {
                    break;
                }
                case 'E': {
                    if (iPatternLength <= 3) {
                        sPhpDateFormat.append('D');
                        break;
                    }
                    sPhpDateFormat.append('l');
                    break;
                }
                case 'a': {
                    sPhpDateFormat.append('A');
                    break;
                }
                case 'H': {
                    if (iPatternLength <= 1) {
                        sPhpDateFormat.append('G');
                        break;
                    }
                    sPhpDateFormat.append('H');
                    break;
                }
                case 'k': {
                    break;
                }
                case 'K': {
                    break;
                }
                case 'h': {
                    if (iPatternLength <= 1) {
                        sPhpDateFormat.append('g');
                        break;
                    }
                    sPhpDateFormat.append('h');
                    break;
                }
                case 'm': {
                    sPhpDateFormat.append('i');
                    break;
                }
                case 's': {
                    sPhpDateFormat.append('s');
                    break;
                }
                case 'S': {
                    sPhpDateFormat.append('u');
                    break;
                }
                case 'z': {
                    sPhpDateFormat.append('T');
                    break;
                }
                case 'Z': {
                    sPhpDateFormat.append('O');
                    break;
                }
                case '\'': {
                    int iNextPatternAfterString;
                    if (iPatternLength == 2) {
                        sPhpDateFormat.append('\'');
                        break;
                    }
                    for (iNextPatternAfterString = iPos + 1; iNextPatternAfterString < javaSimpleDateFormat_p.length(); ++iNextPatternAfterString) {
                        char cStringChar = javaSimpleDateFormat_p.charAt(iNextPatternAfterString);
                        if (cStringChar == '\'') {
                            if (iNextPatternAfterString + 1 >= javaSimpleDateFormat_p.length() || javaSimpleDateFormat_p.charAt(iNextPatternAfterString) != '\'') break;
                            sPhpDateFormat.append('\'');
                            ++iNextPatternAfterString;
                            continue;
                        }
                        if (OwEditablePropertyDate.isPhpSpecialChar(cStringChar)) {
                            sPhpDateFormat.append('\\');
                            sPhpDateFormat.append(cStringChar);
                            continue;
                        }
                        sPhpDateFormat.append(cStringChar);
                    }
                    iNextPatternStartPos = iNextPatternAfterString;
                    break;
                }
                default: {
                    int i;
                    if (OwEditablePropertyDate.isPhpSpecialChar(cCurrentPattern)) {
                        for (i = 0; i < iPatternLength; ++i) {
                            sPhpDateFormat.append('\\');
                            sPhpDateFormat.append(cCurrentPattern);
                        }
                    } else {
                        for (i = 0; i < iPatternLength; ++i) {
                            sPhpDateFormat.append(cCurrentPattern);
                        }
                    }
                }
            }
            iPos = iNextPatternStartPos;
        }
        return sPhpDateFormat.toString();
    }

    public static boolean isPhpSpecialChar(char testChar_p) {
        char[] specialChars = new char[]{'d', 'D', 'j', 'l', 'S', 'w', 'z', 'W', 'F', 'm', 'M', 'n', 't', 'L', 'Y', 'y', 'a', 'A', 'g', 'G', 'h', 'H', 'i', 's', 'O', 'T', 'Z'};
        for (int i = 0; i < specialChars.length; ++i) {
            if (specialChars[i] != testChar_p) continue;
            return true;
        }
        return false;
    }

    private static void renderChoiceList(Locale locale_p, Writer w_p, List list_p, String name_p, String selectedItem_p) throws Exception {
        if (list_p != null) {
            w_p.write("<select size='1' class='OwInputControl' name='");
            OwHTMLHelper.writeSecureHTML(w_p, name_p);
            w_p.write("'>\n");
            for (OwListBoxItem oItem : list_p) {
                w_p.write("<option value='");
                OwHTMLHelper.writeSecureHTML(w_p, oItem.m_value);
                w_p.write("' ");
                if (selectedItem_p != null && selectedItem_p.equals(oItem.m_value)) {
                    w_p.write("selected ");
                }
                w_p.write(">");
                OwHTMLHelper.writeSecureHTML(w_p, oItem.m_displayText.getString(locale_p));
                w_p.write("</option>\n");
            }
            w_p.write("</select>\n");
        }
    }

    public static Date updateField(Locale locale_p, HttpServletRequest request_p, String strID_p, boolean fUseJS_Control_p, Date oldDate_p, boolean fEmptyDataPossible_p, String sDateFormat_p) throws Exception {
        return OwEditablePropertyDate.updateField(locale_p, request_p, strID_p, fUseJS_Control_p, oldDate_p, fEmptyDataPossible_p, sDateFormat_p, null);
    }

    public static Date updateField(Locale locale_p, HttpServletRequest request_p, String strID_p, boolean fUseJS_Control_p, Date oldDate_p, boolean fEmptyDataPossible_p, String sDateFormat_p, String timeFormatString) throws OwException {
        GregorianCalendar calendar = new GregorianCalendar();
        String dateFromRequest = null;
        String strID = OwEditablePropertyDate.buildControlId(strID_p);
        if (!fUseJS_Control_p) {
            try {
                if (request_p.getParameter("EN_" + strID) == null && fEmptyDataPossible_p) {
                    return null;
                }
                String day = request_p.getParameter("D_" + strID);
                day = day == null ? "" : day;
                String month = request_p.getParameter("M_" + strID);
                month = month == null ? "" : month;
                String year = request_p.getParameter("Y_" + strID);
                year = year == null ? "" : year;
                dateFromRequest = "" + day + "/" + month + "/" + year;
                String timeStr = request_p.getParameter("T_" + strID);
                if (null != timeStr && null != timeFormatString) {
                    dateFromRequest = dateFromRequest + " " + timeStr;
                    SimpleDateFormat timeFormat = new SimpleDateFormat(timeFormatString);
                    Date time = timeFormat.parse(timeStr);
                    calendar.setTime(time);
                }
                calendar.set(5, Integer.parseInt(day));
                calendar.set(2, Integer.parseInt(month));
                calendar.set(1, Integer.parseInt(year));
            }
            catch (Exception e) {
                LOG.debug((Object)"Invalid input: The date or time format is invalid.", (Throwable)e);
                LOG.debug((Object)("Date from request: " + dateFromRequest));
                dateFromRequest = dateFromRequest != null ? dateFromRequest : "";
                throw new OwFieldManagerException(OwString.localize1(locale_p, "app.OwDateTimeControl.dateinvalid", "The date or time format (%1) is invalid.", dateFromRequest) + " (" + (null != timeFormatString ? timeFormatString : "") + ")");
            }
        }
        try {
            dateFromRequest = request_p.getParameter(strID);
            if ((dateFromRequest == null || dateFromRequest.length() == 0) && fEmptyDataPossible_p) {
                return null;
            }
            SimpleDateFormat sdf = OwDateTimeUtil.createDateFromat(locale_p, sDateFormat_p);
            calendar.setLenient(false);
            Date date = sdf.parse(dateFromRequest);
            calendar.setTime(date);
            if (calendar.get(1) > 9999) {
                throw new ParseException("Invalid year. Year should be smaller or equal than 9999, but is " + calendar.get(1) + ".", 6);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Invalid input: The date or time format is invalid.", (Throwable)e);
            LOG.debug((Object)("Date from request: " + dateFromRequest));
            dateFromRequest = dateFromRequest != null ? dateFromRequest : "";
            throw new OwFieldManagerException(OwString.localize1(locale_p, "app.OwDateTimeControl.dateinvalid", "The date or time format (%1) is invalid.", dateFromRequest) + " (" + sDateFormat_p + ")");
        }
        return calendar.getTime();
    }

    public OwEditablePropertyDate(OwMainAppContext context_p) {
        this.m_sDateFormatString = context_p.getDateFormatString();
        this.m_context = context_p;
    }

    public OwEditablePropertyDate(OwMainAppContext context_p, String sDateFormat_p) {
        this(context_p, sDateFormat_p, true);
    }

    public OwEditablePropertyDate(OwMainAppContext context_p, String sDateFormat_p, boolean ignoreTime) {
        this.m_sDateFormatString = sDateFormat_p;
        this.m_context = context_p;
        this.ignoreTime = ignoreTime;
    }

    public void render(Locale locale_p, Writer w_p) throws Exception {
        boolean useJS_DateControl = this.m_context.useJS_DateControl();
        if (useJS_DateControl) {
            OwEditablePropertyDate.insertJSControl(this.m_context, this.m_context.getLocale(), w_p, (Date)this.getValue(), this.getFormElementID(), false, this.m_sDateFormatString);
        } else {
            OwEditablePropertyDate.insertNonJSControl(this.m_context, this.m_context.getLocale(), w_p, (Date)this.getValue(), this.getFormElementID(), false, this.ignoreTime ? null : this.m_context.getTimeFormatString());
        }
    }

    @Override
    protected Object getValueFromRequest(Locale locale_p, HttpServletRequest request_p, String strID_p) throws Exception {
        return OwEditablePropertyDate.updateField(locale_p, request_p, this.getFormElementID(), this.m_context.useJS_DateControl(), (Date)this.getValue(), false, this.m_sDateFormatString);
    }

    private static class OwDateControlListItemsSingleton {
        private List m_Time_Days = new ArrayList();
        private List m_Time_Month = new ArrayList();
        private List m_Time_Years = new ArrayList();

        public OwDateControlListItemsSingleton() {
            String strDay;
            String strID;
            int i;
            for (i = 1; i < 32; ++i) {
                strDay = strID = String.valueOf(i);
                if (i < 10) {
                    strDay = "0" + strDay;
                }
                this.m_Time_Days.add(new OwListBoxItem(strDay, strID));
            }
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.january", "January"), "0"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.february", "February"), "1"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.march", "March"), "2"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.april", "April"), "3"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.may", "May"), "4"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.juni", "June"), "5"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.july", "July"), "6"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.august", "August"), "7"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.september", "September"), "8"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.october", "October"), "9"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.november", "November"), "10"));
            this.m_Time_Month.add(new OwListBoxItem(new OwString("app.OwDateControl.december", "December"), "11"));
            for (i = 1900; i < 2100; ++i) {
                strDay = strID = String.valueOf(i);
                this.m_Time_Years.add(new OwListBoxItem(strDay, strID));
            }
        }
    }

    private static class OwListBoxItem {
        private OwString m_displayText;
        private String m_value;

        public OwListBoxItem(OwString displayText_p, String value_p) {
            this.m_displayText = displayText_p;
            this.m_value = value_p;
        }

        public OwListBoxItem(String strDisplayText_p, String value_p) {
            this.m_displayText = new OwString(strDisplayText_p);
            this.m_value = value_p;
        }
    }
}

