/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwBaseComboboxRenderer;
import com.wewebu.ow.server.app.OwComboItem;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class OwExtJSComboboxRenderer
extends OwBaseComboboxRenderer {
    private static final Set<String> EXTJS_STYLE_CLASSES = new LinkedHashSet<String>();
    protected static final Map<String, String> JS_2_EXT_JS_EVENTS_MAP;

    @Override
    public void renderCombo(Writer w_p) throws Exception {
        String secureFieldId = OwHTMLHelper.encodeToSecureHTML(this.m_fieldId);
        w_p.write("<div ");
        w_p.write(this.renderStyleClasses(EXTJS_STYLE_CLASSES));
        w_p.write(" id=\"r");
        w_p.write(secureFieldId);
        w_p.write("\"></div>\n");
        if (this.m_model.hasItemOutOfRange()) {
            w_p.write("<span class=\"OwInstructionName\">");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwStandardFieldManager.outofrangelist", "(!) Out of range list"));
            w_p.write("</span>");
        }
        w_p.write("<script type=\"text/javascript\">\nExt.BLANK_IMAGE_URL =\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(this.getContext().getBaseURL() + "/js/extjs/resources/images/default/s.gif"));
        w_p.write("\";\n");
        String convertedVarId = "converted_" + OwHTMLHelper.encodeJavascriptVariableName(this.m_fieldId);
        String encodedFieldId = OwHTMLHelper.encodeJavascriptString(this.m_fieldId);
        w_p.write("Ext.onReady(function(){\n");
        w_p.write("     var ");
        w_p.write(convertedVarId);
        w_p.write(" = new Ext.form.ComboBox({\n");
        w_p.write("     renderTo:'r");
        w_p.write(secureFieldId);
        w_p.write("',\n");
        w_p.write("     id:'");
        w_p.write(secureFieldId);
        w_p.write("',\n");
        w_p.write("     typeAhead: true,\n");
        w_p.write("     triggerAction: 'all',\n");
        w_p.write("     mode: 'local',\n");
        w_p.write("     valueField: 'value',\n     displayField: 'label',\n");
        w_p.write("     store: new Ext.data.ArrayStore({\n");
        w_p.write("          storeId: 'store");
        w_p.write(encodedFieldId);
        w_p.write("',\n          fields: ['value', 'label'],\n");
        w_p.write("          data: [");
        String selectedValue = null;
        for (int i = 0; i < this.m_model.getSize(); ++i) {
            w_p.write("[\"");
            OwComboItem item = this.m_model.getItemAt(i);
            String encSelectVal = OwHTMLHelper.encodeToSecureHTML(item.getValue());
            w_p.write(encSelectVal);
            w_p.write("\", ");
            if (this.m_model.isSelectedItem(item)) {
                selectedValue = encSelectVal;
            }
            w_p.write("\"");
            OwHTMLHelper.writeSecureHTML(w_p, item.getDisplayName());
            w_p.write("\"]\n");
            if (i + 1 >= this.m_model.getSize()) continue;
            w_p.write("          ,");
        }
        w_p.write("          ]}),\n");
        w_p.write("     hiddenId:'extCmb");
        w_p.write(encodedFieldId);
        w_p.write("',\n");
        w_p.write("     hiddenName:'");
        w_p.write(encodedFieldId);
        w_p.write("',\n");
        if (selectedValue != null) {
            w_p.write("     hiddenValue:\"");
            w_p.write(selectedValue);
            w_p.write("\",\n");
            w_p.write("     value:\"");
            w_p.write(selectedValue);
            w_p.write("\",\n");
        }
        w_p.write("     grow:true,\n");
        w_p.write("     autoWidth:'auto',\n");
        w_p.write("     listWidth:'auto',\n");
        w_p.write("     cls:'OwAjaxComponentCombo',\n");
        w_p.write("     selectOnFocus: true,\n");
        if (!this.enabled) {
            w_p.write("     disabled: true,\n");
        }
        w_p.write("     forceSelection:true\n");
        w_p.write("});\n");
        String fieldClassName = "";
        String javaClassName = "";
        int fieldProviderType = -1;
        String fieldProviderName = "";
        if (this.m_fieldDefinition != null) {
            fieldClassName = this.m_fieldDefinition.getClassName();
            javaClassName = this.m_fieldDefinition.getJavaClassName();
        }
        if (this.m_fieldProvider != null) {
            fieldProviderType = this.m_fieldProvider.getFieldProviderType();
            fieldProviderName = this.m_fieldProvider.getFieldProviderName();
        }
        w_p.write(convertedVarId);
        w_p.write(".addListener('select',function(cb,record,index){onFieldManagerFieldExit(\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(fieldClassName));
        w_p.write("\",\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(javaClassName));
        w_p.write("\",\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(Integer.toString(fieldProviderType)));
        w_p.write("\",\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(fieldProviderName));
        w_p.write("\",\"");
        w_p.write(encodedFieldId);
        w_p.write("\",record.data[cb.valueField || cb.displayField]);});\n");
        w_p.write(this.renderEvents(convertedVarId));
        w_p.write("});\n");
        w_p.write("</script>\n");
    }

    protected String renderEvents(String convertedVarId_p) {
        String[] eventsNames = this.getAllEventsNames();
        StringBuilder eventCode = new StringBuilder();
        for (int i = 0; i < eventsNames.length; ++i) {
            String event = eventsNames[i];
            String transformedEvent = event.startsWith("on") ? event.substring(2) : event;
            StringBuilder buff = new StringBuilder(convertedVarId_p).append(".addListener(");
            String realExtJSTransformedEvent = JS_2_EXT_JS_EVENTS_MAP.get(transformedEvent);
            if (realExtJSTransformedEvent != null) {
                transformedEvent = realExtJSTransformedEvent;
            }
            buff.append("'").append(transformedEvent).append("',");
            String handler = this.getEventHandler(event);
            int idx = handler.indexOf(40);
            if (idx > 0) {
                buff.append(handler.substring(0, idx));
            } else {
                buff.append(handler);
            }
            buff.append(");\n");
            eventCode.append((CharSequence)buff);
        }
        return eventCode.toString();
    }

    static {
        EXTJS_STYLE_CLASSES.add("OwInputControl");
        EXTJS_STYLE_CLASSES.add("OwInputControlAdvancedChoice");
        JS_2_EXT_JS_EVENTS_MAP = new HashMap<String, String>();
        JS_2_EXT_JS_EVENTS_MAP.put("change", "select");
        JS_2_EXT_JS_EVENTS_MAP.put("click", "focus");
    }
}

