/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwPlugin;
import com.wewebu.ow.server.app.OwSettingsProperty;
import com.wewebu.ow.server.app.OwSettingsSet;
import com.wewebu.ow.server.conf.OwBaseConfiguration;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class OwFunction
implements OwPlugin {
    public static final String DRAG_DROP_PROPERTY_MAX_FILESIZE = "max_upload";
    private static final Logger LOG = OwLogCore.getLogger(OwFunction.class);
    public static final String DESCRIPTION_KEY_OBJ_TYPES = "objecttypes";
    public static final String DESCRIPTION_KEY_CLASSES = "objectclasses";
    private OwXMLUtil m_PluginDescriptionNode;
    protected OwMainAppContext m_MainContext;
    public static final String DESCRIPTION_KEY_TYPE = "type";
    private OwSettingsSet m_SettingsInfo;
    private Set m_supportedObjectClassNames;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        this.m_PluginDescriptionNode = node_p;
        this.m_MainContext = context_p;
        this.m_SettingsInfo = this.getContext().getSettings().getSettingsInfo(this.m_PluginDescriptionNode.getSafeTextValue("id", null));
        this.m_supportedObjectClassNames = this.getSupportedObjectClassesFromDescriptor(DESCRIPTION_KEY_CLASSES);
    }

    @Override
    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/function_plugin.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/function_plugin_24.png");
    }

    public boolean isObjectClassSupported(String strClassName_p) {
        if (this.m_supportedObjectClassNames == null) {
            return true;
        }
        return this.m_supportedObjectClassNames.contains(strClassName_p);
    }

    public String getHelpPath() {
        return this.getConfigNode().getSafeTextValue("helppath", null);
    }

    public String getName() {
        return this.getConfigNode().getSafeTextValue("Name", "unbekannt");
    }

    public boolean getNoEvent() {
        return false;
    }

    public boolean isDragDropTarget() {
        return false;
    }

    public Properties getDragDropProperties() {
        return null;
    }

    public boolean getContextMenu() {
        return false;
    }

    @Override
    public OwXMLUtil getConfigNode() {
        return this.m_PluginDescriptionNode;
    }

    @Override
    public String getPluginTitle() {
        return this.getContext().getConfiguration().getLocalizedPluginTitle(this.getConfigNode());
    }

    @Override
    public String getPluginID() {
        return this.getConfigNode().getSafeTextValue("id", null);
    }

    @Override
    public String getPluginTypeDisplayName() {
        return OwBaseConfiguration.getPluginTypeDisplayName(this.getPluginType(), this.getContext().getLocale());
    }

    protected OwMainAppContext getContext() {
        return this.m_MainContext;
    }

    public Object getSafeSetting(String strName_p, Object default_p) {
        try {
            return ((OwSettingsProperty)this.m_SettingsInfo.getProperties().get(strName_p)).getValue();
        }
        catch (Exception e) {
            return default_p;
        }
    }

    public void setSafeSetting(String strName_p, Object value_p) throws Exception {
        ((OwSettingsProperty)this.m_SettingsInfo.getProperties().get(strName_p)).setValue(value_p);
    }

    protected OwEventManager getEventManager() {
        return this.getContext().getHistoryManager();
    }

    protected Set getSupportedObjectTypesFromDescriptor(String strKey_p) throws OwConfigurationException {
        List supportetTypesList = this.getConfigNode().getSafeStringList(strKey_p);
        if (supportetTypesList.size() == 0) {
            return null;
        }
        HashSet<Object> retSet = new HashSet<Object>();
        for (int i = 0; i < supportetTypesList.size(); ++i) {
            try {
                retSet.add(OwObjectReference.class.getField(supportetTypesList.get(i).toString()).get(null));
                continue;
            }
            catch (Exception e) {
                try {
                    retSet.add(new Integer(supportetTypesList.get(i).toString()));
                    continue;
                }
                catch (Exception e2) {
                    String msg = "Could not resolve objecttype in plugin descriptor = " + supportetTypesList.get(i).toString();
                    LOG.error((Object)msg, (Throwable)e2);
                    throw new OwConfigurationException(msg, (Throwable)e2);
                }
            }
        }
        return retSet;
    }

    protected Set getSupportedObjectClassesFromDescriptor(String strKey_p) throws OwConfigurationException {
        List supportetTypesList = this.getConfigNode().getSafeStringList(strKey_p);
        if (supportetTypesList.size() == 0) {
            return null;
        }
        HashSet retSet = new HashSet();
        for (int i = 0; i < supportetTypesList.size(); ++i) {
            retSet.add(supportetTypesList.get(i));
        }
        return retSet;
    }

    public String getTooltip() throws Exception {
        return this.getContext().getConfiguration().getLocalizedPluginDescription(this.getConfigNode());
    }
}

