/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwKeySetting;
import com.wewebu.ow.server.ui.OwOSFamilyKeyCodeSetting;
import com.wewebu.ow.server.ui.ua.OwOSFamily;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwPluginKeyBoardMaping {
    private static final Logger LOG = OwLogCore.getLogger(OwPluginKeyBoardMaping.class);
    private static final String CMD_STRING_SEPARATOR = ",";
    private String m_cmdstring;

    public static Map<String, OwKeySetting> toKeySettings(Collection<OwPluginKeyBoardMaping> mappings) {
        HashMap<String, ArrayList<OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode>> keyCodes = new HashMap<String, ArrayList<OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode>>();
        for (OwPluginKeyBoardMaping mapping : mappings) {
            OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode keyCode = new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode(mapping.getOSFamily(), mapping.getKeyCode(), mapping.getCtrlCode());
            String pluginId = mapping.getPluginID();
            ArrayList<OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode> codes = (ArrayList<OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode>)keyCodes.get(pluginId);
            if (codes == null) {
                codes = new ArrayList<OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode>();
                keyCodes.put(pluginId, codes);
            }
            codes.add(keyCode);
        }
        HashMap<String, OwKeySetting> keySettings = new HashMap<String, OwKeySetting>();
        Set codeEntries = keyCodes.entrySet();
        for (Map.Entry pluginCodes : codeEntries) {
            OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode[] codesArray = ((List)pluginCodes.getValue()).toArray(new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode[0]);
            String pluginId = (String)pluginCodes.getKey();
            keySettings.put(pluginId, new OwOSFamilyKeyCodeSetting(pluginId, codesArray));
        }
        return keySettings;
    }

    public OwPluginKeyBoardMaping(OwPluginKeyBoardMaping map_p) {
        this.init(map_p.toString());
    }

    public OwPluginKeyBoardMaping(Node valueNode_p) {
        this.init(valueNode_p.getFirstChild().getNodeValue());
    }

    public OwPluginKeyBoardMaping() {
    }

    public OwPluginKeyBoardMaping(String strPluginID, int iKeyCode, int iCtrlCode) {
        this(strPluginID, iKeyCode, iCtrlCode, OwOSFamily.UNKNOWN);
    }

    public OwPluginKeyBoardMaping(String strPluginID, int iKeyCode, int iCtrlCode, OwOSFamily osFamily) {
        String family = OwOSFamily.UNKNOWN != osFamily ? CMD_STRING_SEPARATOR + osFamily.name() : "";
        this.m_cmdstring = String.valueOf(iKeyCode) + CMD_STRING_SEPARATOR + String.valueOf(iCtrlCode) + CMD_STRING_SEPARATOR + strPluginID + family;
    }

    public String toString() {
        return this.m_cmdstring == null ? "" : this.m_cmdstring;
    }

    private void init(String strValue_p) {
        this.m_cmdstring = strValue_p;
    }

    public String getPluginID() {
        String[] split;
        if (this.m_cmdstring != null && (split = this.m_cmdstring.split(CMD_STRING_SEPARATOR)).length > 2) {
            return split[2];
        }
        return "";
    }

    public int getKeyCode() {
        block3: {
            String[] split;
            if (this.m_cmdstring != null && (split = this.m_cmdstring.split(CMD_STRING_SEPARATOR)).length > 0) {
                try {
                    return Integer.parseInt(split[0]);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)("Propvided value is not a number, value = " + split[0]), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public int getCtrlCode() {
        block3: {
            String[] split;
            if (this.m_cmdstring != null && (split = this.m_cmdstring.split(CMD_STRING_SEPARATOR)).length > 1) {
                try {
                    return Integer.parseInt(split[1]);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)("Propvided value is not a number, value = " + split[1]), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public OwOSFamily getOSFamily() {
        if (this.m_cmdstring == null) {
            return OwOSFamily.UNKNOWN;
        }
        StringTokenizer tokens = new StringTokenizer(this.m_cmdstring, CMD_STRING_SEPARATOR);
        tokens.nextToken();
        tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            tokens.nextToken();
            if (tokens.hasMoreTokens()) {
                String osFamilyValue = tokens.nextToken();
                return OwOSFamily.from(osFamilyValue);
            }
            return OwOSFamily.UNKNOWN;
        }
        return OwOSFamily.UNKNOWN;
    }
}

