/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwSettingsProperty;
import com.wewebu.ow.server.app.OwSettingsPropertyControl;
import com.wewebu.ow.server.app.OwSettingsSet;
import com.wewebu.ow.server.conf.OwBaseConfiguration;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwStandardContentCollection;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.settingsimpl.OwSettingsPropertyLanguageString;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class OwSettings {
    private static final Logger LOG = OwLogCore.getLogger(OwSettings.class);
    protected static final String BASE_NODE_NAME = "OwSettings";
    protected OwMainAppContext m_Context;
    protected OwObject m_UserPreferences;
    protected OwObject m_SitePreferences;
    protected Map m_SettingsSetMap;
    protected List m_SettingsSetList;

    public OwSettings(OwMainAppContext context_p) throws Exception {
        this.m_Context = context_p;
        try {
            this.m_UserPreferences = (OwObject)this.m_Context.getNetwork().getApplicationObject(2, BASE_NODE_NAME, true, true);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not access user preference object.", (Throwable)e);
        }
        try {
            this.m_SitePreferences = (OwObject)this.m_Context.getNetwork().getApplicationObject(2, BASE_NODE_NAME, false, true);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not access site preference object.", (Throwable)e);
        }
        try {
            this.loadSettingsFromPlugDescriptor();
        }
        catch (Exception e) {
            throw new OwConfigurationException(this.m_Context.localize("app.OwSettings.parsefailed", "The user or site settings could not be read. The XML object is incorrect."), (Throwable)e);
        }
    }

    private OwXMLUtil getPersistentUserNode() throws Exception {
        OwStandardXMLUtil userNode = null;
        if (this.m_UserPreferences != null && this.m_UserPreferences.canGetContent(1, 2) && this.m_UserPreferences.getContentCollection().getPageCount() > 0) {
            try {
                InputStream contentStream = this.m_UserPreferences.getContentCollection().getContentElement(1, 1).getContentStream(null);
                userNode = new OwStandardXMLUtil(contentStream, BASE_NODE_NAME);
            }
            catch (OwObjectNotFoundException owObjectNotFoundException) {
                // empty catch block
            }
        }
        return userNode;
    }

    private OwXMLUtil getPersistentAppNode() throws Exception {
        OwStandardXMLUtil appNode = null;
        if (this.m_SitePreferences != null && this.m_SitePreferences.canGetContent(1, 2) && this.m_SitePreferences.getContentCollection().getPageCount() > 0) {
            try {
                InputStream contentStream = this.m_SitePreferences.getContentCollection().getContentElement(1, 1).getContentStream(null);
                appNode = new OwStandardXMLUtil(contentStream, BASE_NODE_NAME);
            }
            catch (OwObjectNotFoundException owObjectNotFoundException) {
                // empty catch block
            }
        }
        return appNode;
    }

    public void refresh() throws Exception {
        this.m_SettingsSetMap = null;
        this.m_SettingsSetList = null;
        this.loadSettingsFromPlugDescriptor();
    }

    private void loadSettingsFromPlugDescriptor() throws Exception {
        if (this.m_SettingsSetMap == null) {
            OwXMLUtil userNode = this.getPersistentUserNode();
            OwXMLUtil appNode = this.getPersistentAppNode();
            this.m_SettingsSetMap = new HashMap();
            this.m_SettingsSetList = new ArrayList();
            for (int i = 0; i < OwBaseConfiguration.getPluginTypeDefinitions().length; ++i) {
                List pluginList = this.m_Context.getConfiguration().getAllowedPlugins(OwBaseConfiguration.getPluginTypeDefinitions()[i].getType());
                if (OwBaseConfiguration.getPluginTypeDefinitions()[i].getType().equals("ow_app") && pluginList == null) {
                    LOG.warn((Object)"OwSettings.loadSettingsFromPlugDescriptor: ow_app plugin definition missing, using default settings for application.");
                }
                if (pluginList == null) continue;
                for (OwXMLUtil pluginDescriptionNode : pluginList) {
                    Node pluginSettingsNode = pluginDescriptionNode.getSubNode("settingsset");
                    if (pluginSettingsNode == null) continue;
                    String strPluginID = pluginDescriptionNode.getSafeTextValue("id", null);
                    Node currentUserValueNodeSet = null;
                    if (userNode != null) {
                        currentUserValueNodeSet = userNode.getSubNode(strPluginID);
                    }
                    Node currentAppValueNodeSet = null;
                    if (appNode != null) {
                        currentAppValueNodeSet = appNode.getSubNode(strPluginID);
                    }
                    Map properties = this.createProperties(pluginSettingsNode, strPluginID, currentUserValueNodeSet, currentAppValueNodeSet);
                    OwSettingsSet newSet = new OwSettingsSet(strPluginID, properties, this.m_Context.getConfiguration().getLocalizedPluginTitle(pluginDescriptionNode));
                    this.m_SettingsSetMap.put(strPluginID, newSet);
                    this.m_SettingsSetList.add(newSet);
                }
            }
        }
    }

    private Map createProperties(Node pluginSettingsNode_p, String strPluginID_p, Node currentUserValueNodeSet_p, Node currentAppValueNodeSet_p) throws Exception {
        LinkedHashMap<String, OwSettingsProperty> propertyMap = new LinkedHashMap<String, OwSettingsProperty>();
        OwStandardXMLUtil currentUserValueNodeSet = null;
        OwStandardXMLUtil currentAppValueNodeSet = null;
        if (currentUserValueNodeSet_p != null) {
            currentUserValueNodeSet = new OwStandardXMLUtil(currentUserValueNodeSet_p);
        }
        if (currentAppValueNodeSet_p != null) {
            currentAppValueNodeSet = new OwStandardXMLUtil(currentAppValueNodeSet_p);
        }
        for (Node propertyDefinitionNode = pluginSettingsNode_p.getFirstChild(); propertyDefinitionNode != null; propertyDefinitionNode = propertyDefinitionNode.getNextSibling()) {
            if (propertyDefinitionNode.getNodeType() != 1) continue;
            Node currentValueNode = null;
            if (propertyDefinitionNode.getAttributes().getNamedItem("scope").getNodeValue().equals("user")) {
                if (currentUserValueNodeSet != null) {
                    currentValueNode = currentUserValueNodeSet.getSubNode(propertyDefinitionNode.getNodeName());
                }
            } else if (currentAppValueNodeSet != null) {
                currentValueNode = currentAppValueNodeSet.getSubNode(propertyDefinitionNode.getNodeName());
            }
            if (currentValueNode == null) {
                currentValueNode = propertyDefinitionNode;
            }
            OwSettingsProperty newProperty = this.createNewProperty(propertyDefinitionNode, currentValueNode, strPluginID_p);
            propertyMap.put(newProperty.getName(), newProperty);
        }
        return propertyMap;
    }

    private OwSettingsProperty createNewProperty(Node propertyDefinitionNode_p, Node currentValueNode_p, String strSetName_p) throws Exception {
        String strJavaClassName = OwXMLDOMUtil.getSafeStringAttributeValue(propertyDefinitionNode_p, "type", null);
        Class<?> propClass = Class.forName(strJavaClassName);
        OwSettingsProperty newProperty = (OwSettingsProperty)propClass.newInstance();
        if (newProperty instanceof OwSettingsPropertyLanguageString) {
            OwSettingsPropertyLanguageString dateProperty = (OwSettingsPropertyLanguageString)newProperty;
            dateProperty.setLocaleFromContext(this.m_Context);
        }
        newProperty.init(propertyDefinitionNode_p, currentValueNode_p, strSetName_p);
        if (newProperty.isEditable()) {
            ((OwSettingsPropertyControl)newProperty).attach(this.m_Context, null);
        }
        return newProperty;
    }

    public void saveUserPrefs() throws Exception {
        this.savePrefs(this.m_UserPreferences, true);
    }

    public void saveSitePrefs() throws Exception {
        this.savePrefs(this.m_SitePreferences, false);
    }

    protected void savePrefs(OwObject prefsObject_p, boolean fUser_p) throws Exception {
        if (prefsObject_p != null) {
            OwXMLDOMUtil saveNode = new OwXMLDOMUtil(BASE_NODE_NAME);
            for (OwSettingsSet info : this.m_SettingsSetMap.values()) {
                Node infoSetNode;
                try {
                    infoSetNode = saveNode.addNode(info.getName());
                }
                catch (DOMException ex) {
                    LOG.fatal((Object)("== cannot create node for infoSetName = " + info.getName()));
                    throw ex;
                }
                for (OwSettingsProperty prop : info.getProperties().values()) {
                    if (prop.isUser() != fUser_p) continue;
                    infoSetNode.appendChild(prop.getValueNode(infoSetNode.getOwnerDocument()));
                }
            }
            prefsObject_p.setContentCollection(new OwStandardContentCollection(saveNode.getInputStream(), 1, 1));
        }
    }

    public Collection getCollection() {
        return this.m_SettingsSetList;
    }

    public OwSettingsProperty getProperty(String strID_p, String strName_p) throws Exception {
        OwSettingsSet info = (OwSettingsSet)this.m_SettingsSetMap.get(strID_p);
        if (info != null) {
            return (OwSettingsProperty)info.getProperties().get(strName_p);
        }
        return null;
    }

    public OwSettingsSet getSettingsInfo(String strID_p) throws Exception {
        return (OwSettingsSet)this.m_SettingsSetMap.get(strID_p);
    }
}

