/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwComboModel;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwEditablePropertyDate;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwFieldManagerComboModel;
import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwFieldManagerException;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.ecm.OwStandardObjectClass;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInaccessibleException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwEnum;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFormat;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwStandardDecoratorFieldDefinition;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwStandardFieldManager
extends OwFieldManager {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardFieldManager.class);
    public static final String ARRAY_ITEM_INDEX_KEY = "aitem";
    public static final String FIELD_ID_KEY = "fieldid";
    public static final String THRESHOLD_CONFIG_NODE = "TextAreaThreshold";
    public static final String MAX_STRING_SIZE_CONFIG_NODE = "DefaultStringMaxSize";
    protected static final String COMPLEX_ID_DELIMITER = "_";
    protected DateFormat m_DateFormat;
    protected DateFormat m_TimeFormat;
    protected DateFormat m_DateWithoutTimeFormat;
    protected NumberFormat m_NumberFormat;
    protected Map<String, OwFieldManagerControl> m_FieldCtrlMap = new LinkedHashMap<String, OwFieldManagerControl>();
    protected OwMimeManager m_MimeManager = new OwMimeManager();
    protected int m_textareaThreshold;
    protected int m_defMaxStringSize;
    protected boolean m_restoreFromRequestStrategy = true;

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_MimeManager.attach(this.getContext(), null);
        this.attachFieldControlsFromConfiguration();
        this.m_DateFormat = OwDateTimeUtil.createDateFromat(this.getContext().getLocale(), ((OwMainAppContext)this.getContext()).getDateFormatString());
        this.m_TimeFormat = OwDateTimeUtil.createDateFromat(this.getContext().getLocale(), ((OwMainAppContext)this.getContext()).getDateFormatStringWithoutDate());
        this.m_DateWithoutTimeFormat = OwDateTimeUtil.createDateFromat(this.getContext().getLocale(), ((OwMainAppContext)this.getContext()).getDateFormatStringWithoutTime());
        this.m_NumberFormat = NumberFormat.getNumberInstance(this.getContext().getLocale());
        this.m_NumberFormat.setGroupingUsed(false);
        this.m_textareaThreshold = this.getConfigNode().getSafeIntegerValue(THRESHOLD_CONFIG_NODE, 255);
        this.m_defMaxStringSize = this.getConfigNode().getSafeIntegerValue(MAX_STRING_SIZE_CONFIG_NODE, 32);
    }

    protected void attachFieldControlsFromConfiguration() throws Exception {
        Node fieldcontrols = this.getConfigNode().getSubNode("FieldControls");
        if (fieldcontrols != null) {
            for (Node field = fieldcontrols.getFirstChild(); field != null; field = field.getNextSibling()) {
                if (field.getNodeType() != 1 || !field.getNodeName().equals("FieldControl")) continue;
                String strFieldClass = OwXMLDOMUtil.getSafeStringAttributeValue(field, "fieldclass", null);
                String strJavaType = OwXMLDOMUtil.getSafeStringAttributeValue(field, "javatype", null);
                String strObjectType = OwXMLDOMUtil.getSafeStringAttributeValue(field, "objecttype", null);
                OwFieldManagerControl newControl = null;
                try {
                    Class<?> newClass = Class.forName(strFieldClass);
                    newControl = (OwFieldManagerControl)newClass.newInstance();
                }
                catch (Exception e) {
                    LOG.fatal((Object)("Fieldcontrol could not be created: " + strFieldClass), (Throwable)e);
                    continue;
                }
                if (strJavaType != null) {
                    this.attachFieldControlByType(strJavaType, newControl, field);
                    continue;
                }
                if (strObjectType != null) {
                    this.attachFieldControlByClass(strObjectType, newControl, field);
                    continue;
                }
                LOG.fatal((Object)"OwStandardFieldManager.attachFieldControlsFromConfiguration: Please define either javatype or objecttype in FieldControl.");
            }
        }
    }

    @Override
    public OwMimeManager getMimeManager() {
        return this.m_MimeManager;
    }

    protected NumberFormat getNumberFormater() {
        return this.m_NumberFormat;
    }

    protected DateFormat getDateFormater() {
        return this.m_DateFormat;
    }

    protected DateFormat getTimeFormater() {
        return this.m_TimeFormat;
    }

    protected DateFormat getDateWithoutTimeFormater() {
        return this.m_DateWithoutTimeFormat;
    }

    @Override
    public void attachFieldControlByType(String strJavaClassName_p, OwFieldManagerControl control_p, Node configNode_p) throws Exception {
        this.attachFieldControlByClass(strJavaClassName_p, control_p, configNode_p);
    }

    @Override
    public void attachFieldControlByClass(String strFieldClassName_p, OwFieldManagerControl control_p, Node configNode_p) throws Exception {
        control_p.init(this, configNode_p);
        control_p.attach(this.getContext(), null);
        OwFieldManagerControl ctrl = this.m_FieldCtrlMap.get(strFieldClassName_p);
        if (null != ctrl) {
            LOG.warn((Object)("OwStandardFieldManager.attachFieldControlByClass: Check configuration! An existing field control is replaced for class = " + strFieldClassName_p));
            ctrl.detach();
        }
        this.m_FieldCtrlMap.put(strFieldClassName_p, control_p);
    }

    public OwFieldManagerControl getFieldControlByType(String strJavaClassName_p) {
        return this.m_FieldCtrlMap.get(strJavaClassName_p);
    }

    public OwFieldManagerControl getFieldControlByClass(String strFieldClassName_p) {
        return this.m_FieldCtrlMap.get(strFieldClassName_p);
    }

    protected OwFieldManagerControl getFieldControl(OwFieldDefinition fieldDef) {
        OwFieldManagerControl fieldCtrl = this.getFieldControlByClass(fieldDef.getClassName());
        if (fieldCtrl == null) {
            fieldCtrl = this.getFieldControlByType(fieldDef.getJavaClassName());
        }
        return fieldCtrl;
    }

    @Override
    public void detach() {
        super.detach();
        this.m_MimeManager.detach();
        for (OwFieldManagerControl fieldCtrl : this.m_FieldCtrlMap.values()) {
            fieldCtrl.detach();
        }
    }

    @Override
    protected void insertReadOnlyFieldInternal(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        OwFieldManagerControl fieldcontrol = this.getFieldControl(fieldDef_p);
        if (fieldcontrol != null) {
            try {
                fieldcontrol.insertReadOnlyField(w_p, fieldDef_p, value_p);
            }
            catch (Exception ex) {
                LOG.error((Object)"The fieldcontrol failed to execute insertReadOnlyField.", (Throwable)ex);
                w_p.write("The fieldontrol ");
                w_p.write(fieldcontrol.getClass().getName());
                w_p.write(" failed to execute with a ");
                w_p.write(ex.getClass().getName());
                w_p.write(".<br>");
                w_p.write("Error message: ");
                w_p.write(ex.toString());
                w_p.write("<br>");
                StackTraceElement[] trace = ex.getStackTrace();
                for (int i = 0; i < Math.min(trace.length, 20); ++i) {
                    w_p.write(trace[i].toString() + "<br>");
                }
            }
        } else if (value_p != null) {
            if (fieldDef_p.isArray()) {
                Object[] values = (Object[])value_p;
                boolean fDelimiter = false;
                for (int i = 0; i < values.length; ++i) {
                    if (fDelimiter) {
                        w_p.write("<div style='clear:left;padding-top:2px'>");
                        w_p.write("<hr class='OwStandardFieldManager_Array'>");
                        w_p.write("</div>");
                    }
                    this.insertSingleReadOnlyFieldInternal(w_p, fieldDef_p, values[i]);
                    fDelimiter = true;
                }
            } else {
                this.insertSingleReadOnlyFieldInternal(w_p, fieldDef_p, value_p);
            }
        }
    }

    @Override
    public void reset() {
        this.m_MimeManager.reset();
        super.reset();
    }

    public void insertSingleReadOnlyFieldInternal(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        if (fieldDef_p.isComplex()) {
            this.insertSingleComplexReadOnlyFieldInternal(w_p, fieldDef_p, (Object[])value_p);
        } else if (fieldDef_p.isEnum()) {
            OwHTMLHelper.writeSecureHTML(w_p, fieldDef_p.getEnums().getDisplayName(this.getContext().getLocale(), value_p));
        } else if (fieldDef_p.getJavaClassName().equalsIgnoreCase("java.util.Date")) {
            String stringFormatedValue = "";
            OwFormat format = fieldDef_p.getFormat();
            DateFormat filedDefDateFormat = this.getDateFormater();
            if (format == null) {
                filedDefDateFormat = this.getDateFormater();
            } else if (format.ignoreDate()) {
                filedDefDateFormat = this.getTimeFormater();
            } else if (format.ignoreTime()) {
                filedDefDateFormat = this.getDateWithoutTimeFormater();
            }
            stringFormatedValue = filedDefDateFormat.format((Date)value_p);
            OwHTMLHelper.writeSecureHTML(w_p, stringFormatedValue);
        } else if (fieldDef_p.getJavaClassName().equalsIgnoreCase("java.lang.Boolean")) {
            if (value_p != null) {
                if (((Boolean)value_p).booleanValue()) {
                    w_p.write("<input disabled type='checkbox' checked>");
                } else {
                    w_p.write("<input disabled type='checkbox'>");
                }
            }
        } else if (value_p != null) {
            String strText = value_p.toString();
            try {
                strText = this.getNumberFormater().format(value_p);
            }
            catch (Exception e) {
                // empty catch block
            }
            OwHTMLHelper.writeSecureHTML(w_p, strText, true);
        }
    }

    public void insertChoiceListControl(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p, boolean fAllowEmptyField_p) throws Exception {
        OwComboModel model = this.createComboBoxModel(fieldDef_p, value_p, fAllowEmptyField_p);
        OwComboboxRenderer renderer = this.m_MainContext.createComboboxRenderer(model, strID_p, fieldDef_p, this.getFieldProvider(), null);
        renderer.renderCombo(w_p);
    }

    protected OwComboModel createComboBoxModel(OwFieldDefinition fieldDef_p, Object value_p, boolean fAllowEmptyField_p) throws Exception {
        Locale locale = this.getContext().getLocale();
        OwEnumCollection enums = fieldDef_p.getEnums();
        int size = enums.size();
        String[] displayNames = new String[size];
        String[] values = new String[size];
        Iterator enumsIt = enums.iterator();
        int i = 0;
        while (enumsIt.hasNext()) {
            OwEnum enumItem = (OwEnum)enumsIt.next();
            displayNames[i] = enumItem.getDisplayName(locale);
            values[i] = enumItem.getValue() == null ? null : enumItem.getValue().toString();
            ++i;
        }
        OwFieldManagerComboModel model = new OwFieldManagerComboModel(locale, fAllowEmptyField_p, value_p == null ? null : value_p.toString(), displayNames, values);
        return model;
    }

    @Override
    protected void insertEditFieldInternal(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        OwFieldManagerControl fieldcontrol = this.getFieldControl(fieldDef_p);
        if (fieldcontrol != null) {
            try {
                fieldcontrol.insertEditField(w_p, fieldDef_p, field_p, strID_p);
            }
            catch (Exception ex) {
                LOG.error((Object)"The fieldcontrol failed to execute insertEditField.", (Throwable)ex);
                w_p.write("The fieldontrol ");
                w_p.write(fieldcontrol.getClass().getName());
                w_p.write(" failed to execute with a ");
                w_p.write(ex.getClass().getName());
                w_p.write(".<br>");
                w_p.write("Error message: ");
                w_p.write(ex.toString());
                w_p.write("<br>");
                StackTraceElement[] trace = ex.getStackTrace();
                for (int i = 0; i < Math.min(trace.length, 20); ++i) {
                    w_p.write(trace[i].toString() + "<br>");
                }
            }
        } else if (fieldDef_p.isArray()) {
            OwFieldDefinition definition = field_p.getFieldDefinition();
            String arrayFieldDisplayName = definition.getDisplayName(this.getContext().getLocale());
            w_p.write("<fieldset id='");
            String fieldId = String.valueOf(field_p.hashCode());
            w_p.write(fieldId);
            w_p.write("' class='accessibility'>");
            w_p.write("<legend class='accessibility'>");
            w_p.write(arrayFieldDisplayName);
            w_p.write("</legend>");
            Object[] values = (Object[])field_p.getValue();
            if (values != null) {
                w_p.write("<table>");
                for (int i = 0; i < values.length; ++i) {
                    w_p.write("<tr class='");
                    w_p.write(i % 2 == 0 ? "OwGeneralList_RowEven" : "OwGeneralList_RowOdd");
                    w_p.write("'><td valign='center'>");
                    this.insertSingleEditFieldInternal(w_p, fieldDef_p, values[i], strID_p + COMPLEX_ID_DELIMITER + String.valueOf(i));
                    w_p.write("</td><td>");
                    if (i == 0 && field_p instanceof OwSearchCriteria && values.length == 1) {
                        w_p.write("</td></tr>");
                        continue;
                    }
                    this.writeRemoveMultiValueItemLink(w_p, fieldDef_p, i, strID_p);
                    w_p.write("</td></tr>");
                }
                w_p.write("</table>");
            }
            this.writeAddMultiValueItemLink(w_p, fieldDef_p, strID_p);
            w_p.write("</fieldset>");
        } else {
            this.insertSingleEditFieldInternal(w_p, fieldDef_p, field_p.getValue(), strID_p);
        }
    }

    protected void writeRemoveMultiValueItemLink(Writer w_p, OwFieldDefinition fieldDef_p, int index_p, String strID_p) throws IOException, Exception {
        String tooltipText = "";
        if (fieldDef_p != null) {
            String fieldDisplayName = fieldDef_p.getDisplayName(this.getContext().getLocale());
            tooltipText = this.getContext().localize2("app.OwStandardFieldManager.delarrayitemindexed", "Delete element at position %1 from %2", "" + (index_p + 1), fieldDisplayName);
        }
        w_p.write("<a title=\"");
        w_p.write(this.getContext().localize("app.OwStandardFieldManager.delarrayitem", "Delete Element"));
        w_p.write("\" href=\"");
        w_p.write(this.getFormEventURL("DeleteArrayItem", "aitem=" + String.valueOf(index_p) + "&" + FIELD_ID_KEY + "=" + strID_p + "&" + "wddV" + "=true"));
        w_p.write("\"><img src=\"");
        w_p.write(this.getContext().getDesignURL());
        w_p.write("/images/deletebtn.png\"");
        w_p.write(" alt=\"");
        w_p.write(tooltipText);
        w_p.write("\" title=\"");
        w_p.write(tooltipText);
        w_p.write("\"/></a>");
    }

    protected void writeAddMultiValueItemLink(Writer w_p, OwFieldDefinition fieldDef_p, String strID_p) throws IOException, Exception {
        w_p.write("<a title=\"");
        w_p.write(this.getContext().localize("app.OwStandardFieldManager.addarrayitemtooltip", "Add Element"));
        w_p.write("\" href=\"");
        w_p.write(this.getFormEventURL("AddArrayItem", "fieldid=" + strID_p + "&" + "wddV" + "=true"));
        w_p.write("\"><img style=\"vertical-align:middle;border:0px none;margin:3px 0px;\" src=\"");
        w_p.write(this.getContext().getDesignURL());
        w_p.write("/images/addbtn.png\" ");
        String addItemTooltip = "";
        if (fieldDef_p != null) {
            addItemTooltip = this.getContext().localize1("app.OwStandardFieldManager.addarrayitemtooltipimg", "Add new item for %1.", fieldDef_p.getDisplayName(this.getContext().getLocale()));
        }
        w_p.write("alt=\"");
        w_p.write(addItemTooltip);
        w_p.write("\" title=\"");
        w_p.write(addItemTooltip);
        w_p.write("\"  /></a>");
    }

    @Override
    public OwField getField(String complexid_p) {
        int iComplexStart = complexid_p.indexOf(COMPLEX_ID_DELIMITER);
        if (-1 != iComplexStart) {
            String fieldid = complexid_p.substring(0, iComplexStart);
            String rest = complexid_p.substring(iComplexStart + 1);
            OwField field = super.getField(fieldid);
            return new OwInternalDimensionField(field, rest);
        }
        return super.getField(complexid_p);
    }

    public void onDeleteArrayItem(HttpServletRequest request_p) throws Exception {
        int iIndex = Integer.parseInt(request_p.getParameter(ARRAY_ITEM_INDEX_KEY));
        OwField field = this.getField(request_p.getParameter(FIELD_ID_KEY));
        Object[] values = (Object[])field.getValue();
        this.clearFieldError(field);
        if (values.length < 2) {
            field.setValue(null);
            return;
        }
        Object[] newValues = new Object[values.length - 1];
        int iNew = 0;
        int iOrigin = 0;
        do {
            if (iIndex == iOrigin) {
                // empty if block
            }
            int n = iNew++;
            int n2 = ++iOrigin;
            ++iOrigin;
            newValues[n] = values[n2];
        } while (iNew < newValues.length);
        field.setValue(newValues);
    }

    public void onAddArrayItem(HttpServletRequest request_p) throws Exception {
        String key = request_p.getParameter(FIELD_ID_KEY);
        OwField field = this.getField(key);
        Object[] values = (Object[])field.getValue();
        Object[] newValues = null;
        if (null == values) {
            newValues = new Object[1];
        } else {
            newValues = new Object[values.length + 1];
            for (int i = 0; i < values.length; ++i) {
                newValues[i] = values[i];
            }
        }
        newValues[newValues.length - 1] = OwStandardObjectClass.createInitialNullValue(field.getFieldDefinition(), true);
        field.setValue(newValues);
        StringBuilder strElementID = new StringBuilder(key).append(COMPLEX_ID_DELIMITER).append(newValues.length - 1);
        if (field.getFieldDefinition().isComplex()) {
            strElementID.append(COMPLEX_ID_DELIMITER).append("0");
        }
        this.setFocusControlID(strElementID.toString());
    }

    protected void insertSingleComplexReadOnlyFieldInternal(Writer w_p, OwFieldDefinition fieldDef_p, Object[] value_p) throws Exception {
        Object[] complexvalues = value_p;
        Iterator it = fieldDef_p.getComplexChildClasses().iterator();
        int i = 0;
        while (it.hasNext()) {
            OwFieldDefinition fielddef = (OwFieldDefinition)it.next();
            w_p.write("<div class=\"OwComplexPropertyControl\">");
            w_p.write("<div class=\"OwComplexPropertyControl_header\">");
            w_p.write(fielddef.getDisplayName(this.getContext().getLocale()));
            w_p.write("</div>");
            w_p.write("<div class=\"OwComplexPropertyControl_value\">");
            this.insertReadOnlyFieldInternal(w_p, fielddef, complexvalues[i]);
            w_p.write("</div>");
            w_p.write("</div>");
            ++i;
        }
    }

    protected void insertSingleComplexEditFieldInternal(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        String arrayFieldDisplayName = fieldDef_p.getDisplayName(this.getContext().getLocale());
        w_p.write("<fieldset id=\"");
        w_p.write(strID_p);
        w_p.write("\" class=\"accessibility\">");
        w_p.write("<legend class=\"accessibility\">");
        w_p.write(arrayFieldDisplayName);
        w_p.write("</legend>");
        Object[] complexvalues = (Object[])value_p;
        Iterator it = fieldDef_p.getComplexChildClasses().iterator();
        int i = 0;
        while (it.hasNext()) {
            OwFieldDefinition fielddef = (OwFieldDefinition)it.next();
            w_p.write("<div class=\"OwComplexPropertyControl\">");
            w_p.write("<div class=\"OwComplexPropertyControl_header\">");
            String complexId = strID_p + COMPLEX_ID_DELIMITER + String.valueOf(i);
            if (fielddef.isArray() || fielddef.isComplex()) {
                w_p.write(fielddef.getDisplayName(this.getContext().getLocale()));
            } else {
                w_p.write("<label for=\"");
                w_p.write(complexId);
                w_p.write("\">");
                w_p.write(fielddef.getDisplayName(this.getContext().getLocale()));
                w_p.write("</label>");
            }
            w_p.write("</div>");
            w_p.write("<div class=\"OwComplexPropertyControl_value\">");
            this.insertEditFieldInternal(w_p, fielddef, new OwSingleAttributeComplexInternalField(complexvalues, i, fielddef), complexId);
            w_p.write("</div>");
            w_p.write("</div>");
            ++i;
        }
        w_p.write("</fieldset>");
    }

    public void insertSingleEditFieldInternal(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        String valueFromRequest;
        Object value = value_p;
        if (this.m_restoreFromRequestStrategy && this.m_FieldErrors != null && (valueFromRequest = this.getContext().getHttpRequest().getParameter(strID_p)) != null) {
            String fieldId = strID_p.indexOf(COMPLEX_ID_DELIMITER) != -1 ? strID_p.substring(0, strID_p.indexOf(COMPLEX_ID_DELIMITER)) : strID_p;
            try {
                Integer fieldIdAsKey = Integer.valueOf(fieldId);
                if (this.m_FieldErrors.containsKey(fieldIdAsKey)) {
                    value = valueFromRequest;
                }
            }
            catch (NumberFormatException e) {
                LOG.debug((Object)("Cannot create the field ID from string: " + strID_p + ". The value submited by user is:  " + valueFromRequest));
            }
        }
        if (fieldDef_p.isComplex()) {
            this.insertSingleComplexEditFieldInternal(w_p, fieldDef_p, value, strID_p);
        } else if (fieldDef_p.getJavaClassName().equalsIgnoreCase("java.util.Date")) {
            boolean ignoreDate = false;
            boolean ignoreTime = false;
            if (fieldDef_p.getFormat() != null) {
                ignoreDate = fieldDef_p.getFormat().ignoreDate();
                ignoreTime = fieldDef_p.getFormat().ignoreTime();
            }
            String sDateFormatString = this.getDateFormatString(fieldDef_p);
            Date value_p_Casted = this.parseDate(value, sDateFormatString);
            if (ignoreDate) {
                if (ignoreTime) {
                    LOG.warn((Object)("OwStandardFieldManager.insertSingleEditFieldInternal: Invalid definition is to ignore date and time part of Date, ignore time will not be handled. FieldDef =  " + fieldDef_p.getClassName()));
                }
                String formatedTimeValue = "";
                if (value_p_Casted != null) {
                    SimpleDateFormat dateFormat = OwDateTimeUtil.createDateFromat(this.getContext().getLocale(), sDateFormatString);
                    formatedTimeValue = dateFormat.format(value_p_Casted);
                } else if (value != null) {
                    formatedTimeValue = value.toString();
                }
                this.insertEditableString(w_p, fieldDef_p, formatedTimeValue, strID_p);
            } else {
                OwMainAppContext owMainAppContext = (OwMainAppContext)this.getContext();
                boolean useJS_DateControl = this.m_MainContext.useJS_DateControl();
                OwEditablePropertyDate.insertEditHTML(owMainAppContext, owMainAppContext.getLocale(), w_p, value_p_Casted, strID_p, useJS_DateControl, !fieldDef_p.isRequired(), sDateFormatString, ignoreTime ? null : owMainAppContext.getTimeFormatString());
            }
        } else if (fieldDef_p.isEnum()) {
            this.insertChoiceListControl(w_p, fieldDef_p, value, strID_p, !fieldDef_p.isRequired());
        } else if (fieldDef_p.getJavaClassName().equalsIgnoreCase("java.lang.Boolean")) {
            this.insertEditableBoolean(w_p, fieldDef_p, value, strID_p);
        } else if (fieldDef_p.getJavaClassName().equalsIgnoreCase("java.lang.String")) {
            this.insertEditableString(w_p, fieldDef_p, value, strID_p);
        } else {
            boolean isNumber = false;
            String strText = null;
            if (value != null) {
                strText = value.toString();
                try {
                    strText = this.getNumberFormater().format(value);
                    isNumber = true;
                }
                catch (Exception e1) {
                    isNumber = false;
                }
            }
            w_p.write("<input id=\"");
            OwHTMLHelper.writeSecureHTML(w_p, strID_p);
            w_p.write("\" size=\"20\" title=\"");
            OwHTMLHelper.writeSecureHTML(w_p, fieldDef_p.getDescription(this.getContext().getLocale()));
            w_p.write("\" class=\"OwInputControl");
            if (isNumber) {
                w_p.write(" OwInputControlNumber");
            }
            w_p.write(" OwInputControl_");
            w_p.write(fieldDef_p.getClassName());
            w_p.write("\" name=\"");
            OwHTMLHelper.writeSecureHTML(w_p, strID_p);
            w_p.write("\" type=\"text\" value=\"");
            OwHTMLHelper.writeSecureHTML(w_p, strText);
            w_p.write("\" onblur='onFieldManagerFieldExit(\"");
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldDef_p.getClassName()));
            w_p.write("\",\"");
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldDef_p.getJavaClassName()));
            w_p.write("\",\"");
            if (this.getFieldProvider() != null) {
                OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(Integer.toString(this.getFieldProvider().getFieldProviderType())));
                w_p.write("\",\"");
                OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(this.getFieldProvider().getFieldProviderName()));
                w_p.write("\",\"");
            }
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(strID_p));
            w_p.write("\",this.value)'>");
        }
    }

    protected Date parseDate(Object value_p, String strDateFormat_p) {
        Date parsedValue = null;
        if (value_p != null) {
            if (value_p instanceof Date) {
                parsedValue = (Date)value_p;
            } else if (value_p instanceof String) {
                SimpleDateFormat dateFormat = OwDateTimeUtil.createDateFromat(this.getContext().getLocale(), strDateFormat_p);
                String stringValue = (String)value_p;
                try {
                    parsedValue = dateFormat.parse(stringValue);
                }
                catch (ParseException e) {
                    LOG.debug((Object)("OwStandardFieldManager.parseDate: Error converting to date=[" + value_p + "] to java.util.Date on..."), (Throwable)e);
                    parsedValue = null;
                }
            } else {
                LOG.debug((Object)("OwStandardFieldManager.parseDate: Unsupported type for parsing value=[" + value_p + "] to java.util.Date!"));
                parsedValue = null;
            }
        }
        return parsedValue;
    }

    protected String getValueIndexTitle(String strID_p) {
        String[] idElements = strID_p.split(COMPLEX_ID_DELIMITER);
        StringBuilder valueIndexInformation = new StringBuilder();
        if (idElements.length > 1) {
            for (int i = 1; i < idElements.length; ++i) {
                int index = -1;
                try {
                    index = Integer.parseInt(idElements[i]);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("OwStandardFieldManager.getValueIndexTitle(): Invalid indexed field ID component string : " + idElements[i]));
                }
                if (i == idElements.length - 1) {
                    valueIndexInformation.insert(0, this.getContext().localize1("app.OwStandardFieldManager.field.value.top.index", " - indexed value number %1", "" + (index + 1)));
                    continue;
                }
                valueIndexInformation.insert(0, this.getContext().localize1("app.OwStandardFieldManager.field.value.sub.index", " of  sub-indexed value number %1", "" + (index + 1)));
            }
        }
        return valueIndexInformation.toString();
    }

    protected void insertEditableString(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        String strText = "";
        if (value_p != null) {
            strText = value_p.toString();
        }
        int iMaxSize = this.m_defMaxStringSize;
        try {
            iMaxSize = (Integer)fieldDef_p.getMaxValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (iMaxSize > this.m_textareaThreshold && this.isFieldProviderType(1)) {
            w_p.write("<textarea id=\"");
            OwHTMLHelper.writeSecureHTML(w_p, strID_p);
            w_p.write("\" title=\"");
            OwHTMLHelper.writeSecureHTML(w_p, fieldDef_p.getDescription(this.getContext().getLocale()));
            OwHTMLHelper.writeSecureHTML(w_p, this.getValueIndexTitle(strID_p));
            w_p.write("\" cols=\"40\" rows=\"5\" class=\"OwInputControl OwInputControlMultiString OwInputControl_");
            w_p.write(fieldDef_p.getClassName());
            w_p.write("\" name=\"");
            OwHTMLHelper.writeSecureHTML(w_p, strID_p);
            w_p.write("\" onblur='onFieldManagerFieldExit(\"");
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldDef_p.getClassName()));
            w_p.write("\",\"");
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldDef_p.getJavaClassName()));
            w_p.write("\",\"");
            if (this.getFieldProvider() != null) {
                OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(Integer.toString(this.getFieldProvider().getFieldProviderType())));
                w_p.write("\",\"");
                OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(this.getFieldProvider().getFieldProviderName()));
                w_p.write("\",\"");
            }
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(strID_p));
            w_p.write("\",this.value)' onkeydown=\"event.cancelBubble=true\">");
            OwHTMLHelper.writeSecureHTML(w_p, strText);
            w_p.write("</textarea>");
        } else {
            int iVisibleSize = iMaxSize > 32 ? 32 : iMaxSize;
            w_p.write("<input id=\"");
            OwHTMLHelper.writeSecureHTML(w_p, strID_p);
            w_p.write("\" maxlength=\"");
            OwHTMLHelper.writeSecureHTML(w_p, String.valueOf(iMaxSize));
            w_p.write("\" size=\"");
            OwHTMLHelper.writeSecureHTML(w_p, String.valueOf(iVisibleSize));
            w_p.write("\" title=\"");
            OwHTMLHelper.writeSecureHTML(w_p, fieldDef_p.getDescription(this.getContext().getLocale()));
            OwHTMLHelper.writeSecureHTML(w_p, this.getValueIndexTitle(strID_p));
            w_p.write("\" class=\"OwInputControl OwInputControlString OwInputControl_");
            w_p.write(fieldDef_p.getClassName());
            w_p.write("\" name=\"");
            OwHTMLHelper.writeSecureHTML(w_p, strID_p);
            w_p.write("\" type=\"text\" value=\"");
            OwHTMLHelper.writeSecureHTML(w_p, strText);
            w_p.write("\" onblur='onFieldManagerFieldExit(\"");
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldDef_p.getClassName()));
            w_p.write("\",\"");
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldDef_p.getJavaClassName()));
            w_p.write("\",\"");
            if (this.getFieldProvider() != null) {
                OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(Integer.toString(this.getFieldProvider().getFieldProviderType())));
                w_p.write("\",\"");
                OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(this.getFieldProvider().getFieldProviderName()));
                w_p.write("\",\"");
            }
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(strID_p));
            w_p.write("\",this.value)'>");
        }
    }

    protected void insertEditableBoolean(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        Locale locale = this.getContext().getLocale();
        String[] displayNames = new String[]{this.getContext().localize("app.OwStandardFieldManager.yes", "Yes"), this.getContext().localize("app.OwStandardFieldManager.no", "No")};
        String[] values = new String[]{"true", "false"};
        OwFieldManagerComboModel model = new OwFieldManagerComboModel(locale, !fieldDef_p.isRequired(), value_p == null ? null : value_p.toString(), displayNames, values);
        OwComboboxRenderer renderer = this.m_MainContext.createComboboxRenderer(model, strID_p, fieldDef_p, this.getFieldProvider(), null);
        renderer.renderCombo(w_p);
    }

    @Override
    protected Object updateFieldInternal(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        OwField theField;
        String error;
        Object[] values;
        Object retObject = null;
        OwFieldManagerControl fieldcontrol = this.m_FieldCtrlMap.get(fieldDef_p.getClassName());
        if (fieldcontrol != null || (fieldcontrol = this.m_FieldCtrlMap.get(fieldDef_p.getJavaClassName())) != null) {
            try {
                retObject = fieldcontrol.updateField(request_p, fieldDef_p, value_p, strID_p);
            }
            catch (Exception e) {
                LOG.error((Object)"The fieldcontrol failed to execute updateField.", (Throwable)e);
                throw e;
            }
        } else if (fieldDef_p.isArray()) {
            values = (Object[])value_p;
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.updateSingleFieldInternal(request_p, fieldDef_p, values[i], strID_p + COMPLEX_ID_DELIMITER + Integer.toString(i));
                }
            }
            retObject = value_p;
        } else {
            retObject = this.updateSingleFieldInternal(request_p, fieldDef_p, value_p, strID_p);
        }
        if (!(!fieldDef_p.isArray() || (values = (Object[])retObject) == null || (error = this.getSafeFieldError(theField = this.getField(strID_p))) != null && error.length() != 0 || values.length <= 1 && theField instanceof OwSearchCriteria && values.length == 1)) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null && values[i].toString().length() != 0) continue;
                String errorMessage = this.getContext().localize("app.OwStandardFieldManager.emptyarrayfielditem", "The input fields can not be empty!");
                this.setFieldError(theField, errorMessage);
            }
        }
        if (fieldDef_p.isRequired() && (retObject == null || retObject.toString().length() == 0)) {
            throw new OwFieldManagerException(this.getContext().localize("app.OwStandardFieldManager.requiredfield", "This field is mandatory and must have a value."));
        }
        return retObject;
    }

    protected Object updateComplexSingleFieldInternal(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        Iterator it = fieldDef_p.getComplexChildClasses().iterator();
        int i = 0;
        while (it.hasNext()) {
            OwFieldDefinition fielddef = (OwFieldDefinition)it.next();
            ((Object[])value_p)[i] = this.updateFieldInternal(request_p, fielddef, ((Object[])value_p)[i], strID_p + COMPLEX_ID_DELIMITER + String.valueOf(i));
            ++i;
        }
        return value_p;
    }

    public Object updateSingleFieldInternal(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        if (fieldDef_p.isComplex()) {
            return this.updateComplexSingleFieldInternal(request_p, fieldDef_p, value_p, strID_p);
        }
        Object retObject = this.convertValue(request_p, fieldDef_p, value_p, strID_p);
        this.validateValue(retObject, fieldDef_p);
        return retObject;
    }

    private String getDateFormatString(OwFieldDefinition fieldDef_p) {
        String sDateFormatString = this.m_MainContext.getDateFormatString();
        if (null != fieldDef_p.getFormat()) {
            if (fieldDef_p.getFormat().ignoreTime()) {
                sDateFormatString = this.m_MainContext.getDateFormatStringWithoutTime();
            } else if (fieldDef_p.getFormat().ignoreDate()) {
                sDateFormatString = this.m_MainContext.getDateFormatStringWithoutDate();
            }
        }
        return sDateFormatString;
    }

    protected void validateValue(Object value_p, OwFieldDefinition fieldDef_p) throws Exception {
        if (null == value_p) {
            return;
        }
        OwFormat format = fieldDef_p.getFormat();
        if (null != format && format.canValidate()) {
            String message = format.validate(this.getFieldProvider().getFieldProviderType(), value_p, this.getContext().getLocale());
            if (null != message) {
                throw new OwFieldManagerException(message);
            }
            return;
        }
        String strJavaClassName = fieldDef_p.getJavaClassName();
        Object max = fieldDef_p.getMaxValue();
        Object min = fieldDef_p.getMinValue();
        if (strJavaClassName.equalsIgnoreCase("java.lang.String")) {
            if (max != null && ((String)value_p).length() > (Integer)max) {
                throw new OwFieldManagerException(this.getContext().localize1("app.OwStandardFieldManager.invalidmaxstringlen", "Value must not exceed %1 character(s).", ((Integer)max).toString()));
            }
            if (min != null && ((String)value_p).length() < (Integer)min) {
                throw new OwFieldManagerException(this.getContext().localize1("app.OwStandardFieldManager.invalidminstringlen", "Value must contain at least %1 character(s).", ((Integer)min).toString()));
            }
        } else if (!strJavaClassName.equalsIgnoreCase("java.lang.Boolean")) {
            if (max != null && ((Comparable)max).compareTo(value_p) < 0) {
                if (value_p instanceof Date) {
                    String dateFormat = this.getDateFormatString(fieldDef_p);
                    SimpleDateFormat formatter = OwDateTimeUtil.createDateFromat(this.getContext().getLocale(), dateFormat);
                    throw new OwFieldManagerException(this.getContext().localize1("app.OwStandardFieldManager.invalidmaxdate", "Value must be before (%1).", formatter.format((Date)max)));
                }
                throw new OwFieldManagerException(this.getContext().localize1("app.OwStandardFieldManager.invalidmax", "Value must be below (%1).", max.toString()));
            }
            if (min != null && ((Comparable)min).compareTo(value_p) > 0) {
                if (value_p instanceof Date) {
                    String dateFormat = this.getDateFormatString(fieldDef_p);
                    SimpleDateFormat formatter = OwDateTimeUtil.createDateFromat(this.getContext().getLocale(), dateFormat);
                    throw new OwFieldManagerException(this.getContext().localize1("app.OwStandardFieldManager.invalidmindate", "Value must be later than (%1).", formatter.format((Date)min)));
                }
                throw new OwFieldManagerException(this.getContext().localize1("app.OwStandardFieldManager.invalidmin", "Value must be greater than (%1).", min.toString()));
            }
        }
    }

    @Override
    public void insertLabel(Writer w_p, boolean readOnlyView_p, boolean readOnly_p, OwField property_p, String suffix_p, boolean writeLabel_p) throws Exception {
        OwFieldDefinition fieldDefinition = property_p.getFieldDefinition();
        OwFieldManagerControl fieldcontrol = this.m_FieldCtrlMap.get(fieldDefinition.getClassName());
        if (fieldcontrol == null) {
            fieldcontrol = this.m_FieldCtrlMap.get(fieldDefinition.getJavaClassName());
        }
        if (fieldcontrol != null) {
            fieldcontrol.insertLabel(w_p, suffix_p, property_p, String.valueOf(property_p.hashCode()), writeLabel_p);
        } else if (readOnlyView_p || readOnly_p || fieldDefinition.isArray() || fieldDefinition.isComplex()) {
            w_p.write("<span>");
            w_p.write(fieldDefinition.getDisplayName(this.getContext().getLocale()));
            if (suffix_p != null) {
                w_p.write(suffix_p);
            }
            w_p.write("</span>");
        } else {
            w_p.write("<label for='");
            String fieldId = String.valueOf(property_p.hashCode());
            w_p.write(fieldId);
            w_p.write("'>");
            w_p.write(fieldDefinition.getDisplayName(this.getContext().getLocale()));
            if (suffix_p != null) {
                w_p.write(suffix_p);
            }
            w_p.write("</label>");
        }
    }

    @Override
    public Object convertValue(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws OwException {
        String strJavaClassName = fieldDef_p.getJavaClassName();
        Comparable<Boolean> retObject = null;
        if (strJavaClassName.equalsIgnoreCase("java.util.Date")) {
            String sDateFormatString = this.getDateFormatString(fieldDef_p);
            Date value_p_Casted = null;
            if (value_p != null) {
                try {
                    value_p_Casted = (Date)value_p;
                }
                catch (ClassCastException e) {
                    LOG.debug((Object)("OwStandardFieldManager.updateSingleFieldInternal: Error casting date=[" + value_p + "] to java.util.Date on..."), (Throwable)e);
                    value_p_Casted = null;
                }
            }
            OwMainAppContext owMainAppContext = (OwMainAppContext)this.getContext();
            try {
                retObject = OwEditablePropertyDate.updateField(this.getContext().getLocale(), request_p, strID_p, this.m_MainContext.useJS_DateControl(), value_p_Casted, !fieldDef_p.isRequired(), sDateFormatString, owMainAppContext.getTimeFormatString());
            }
            catch (OwFieldManagerException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot access definition of field for required check", (Throwable)e);
                throw new OwInaccessibleException(this.getContext().localize("app.OwStandardFieldManager.convertValue.inAccessibleRequiredField", "Could not read FieldDefintion (isRequire) information"), (Throwable)e, "FieldManager");
            }
        }
        String strRequestString = request_p.getParameter(strID_p);
        if (strRequestString == null || strRequestString.length() == 0) {
            retObject = null;
        } else if (strJavaClassName.equalsIgnoreCase("java.lang.Boolean")) {
            retObject = strRequestString.length() == 0 ? null : Boolean.valueOf(strRequestString);
        } else {
            Constructor<?> constr;
            Class<?> newClass = null;
            try {
                newClass = Class.forName(strJavaClassName);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Cannot instantiate class: " + strJavaClassName), (Throwable)e);
                throw new OwConfigurationException(this.getContext().localize1("app.OwStandardFieldManager.invalidType", "Invalid type %1", strJavaClassName), (Throwable)e);
            }
            if (Number.class.isAssignableFrom(newClass)) {
                ParsePosition pp = new ParsePosition(0);
                Number n = null;
                try {
                    n = this.getNumberFormater().parse(strRequestString, pp);
                }
                catch (Exception e) {
                    LOG.debug((Object)("Invalid input=" + strRequestString + " / Please insert a number."), (Throwable)e);
                    throw new OwFieldManagerException(this.getContext().localize("app.OwStandardFieldManager.invalidnumbervalue", "Please insert a number."));
                }
                if (pp.getIndex() == strRequestString.length()) {
                    strRequestString = n.toString();
                } else {
                    String character = strRequestString.substring(pp.getIndex(), pp.getIndex() + 1);
                    throw new OwFieldManagerException(this.getContext().localize1("app.OwStandardFieldManager.invalidnumbervalue.withPosition", "Please insert a number. Char '%1' is wrong.", character));
                }
            }
            try {
                constr = newClass.getConstructor(String.class);
            }
            catch (SecurityException e) {
                throw new OwConfigurationException(this.getContext().localize1("app.OwStandardFieldManager.type", "Cannot access Constructor of type %1", strJavaClassName), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new OwServerException(this.getContext().localize1("app.OwStandardFieldManager.type.method", "No simple Constructor(String) available for type %1", strJavaClassName), (Throwable)e);
            }
            strRequestString = strRequestString.trim();
            try {
                retObject = constr.newInstance(strRequestString);
            }
            catch (IllegalArgumentException e) {
                throw new OwServerException(this.getContext().localize("app.OwStandardFieldManager.convert.param", "Invalid parameter for type creation"), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new OwServerException(this.getContext().localize1("app.OwStandardFieldManager.convert.nonInstance", "Conversion failed: Instances of type %1 cannot be created.", strJavaClassName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new OwServerException(this.getContext().localize("app.OwStandardFieldManager.convert.illegalAccess", "Conversion failed: Access to Constructor is not allowed"), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new OwServerException(this.getContext().localize("app.OwStandardFieldManager.convert.target", "Conversion failed: See log for details."), (Throwable)e);
            }
        }
        return retObject;
    }

    private static class OwInternalDimensionField
    implements OwField {
        private int m_dimension;
        private OwFieldDefinition m_fielddefinition;
        private Object m_value;

        public OwInternalDimensionField(OwField basefield_p, String dimensionid_p) {
            try {
                StringTokenizer tokens = new StringTokenizer(dimensionid_p, OwStandardFieldManager.COMPLEX_ID_DELIMITER);
                Object oldvalue = this.m_value = basefield_p.getValue();
                this.m_fielddefinition = basefield_p.getFieldDefinition();
                while (tokens.hasMoreTokens()) {
                    this.m_value = oldvalue;
                    String token = tokens.nextToken();
                    this.m_dimension = Integer.parseInt(token);
                    if (this.m_fielddefinition.isArray()) {
                        this.m_fielddefinition = new OwInternalNoArrayDimensionFieldDefinition(this.m_fielddefinition);
                    } else if (this.m_fielddefinition.isComplex()) {
                        this.m_fielddefinition = (OwFieldDefinition)this.m_fielddefinition.getComplexChildClasses().get(this.m_dimension);
                    }
                    oldvalue = ((Object[])this.m_value)[this.m_dimension];
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public OwFieldDefinition getFieldDefinition() throws Exception {
            return this.m_fielddefinition;
        }

        @Override
        public Object getValue() throws Exception {
            return ((Object[])this.m_value)[this.m_dimension];
        }

        @Override
        public void setValue(Object value_p) throws Exception {
            ((Object[])this.m_value)[this.m_dimension] = value_p;
        }
    }

    private static class OwInternalNoArrayDimensionFieldDefinition
    extends OwStandardDecoratorFieldDefinition {
        private OwFieldDefinition m_fielddefinition;

        public OwInternalNoArrayDimensionFieldDefinition(OwFieldDefinition fielddefinition_p) {
            this.m_fielddefinition = fielddefinition_p;
        }

        @Override
        public OwFieldDefinition getWrappedFieldDefinition() {
            return this.m_fielddefinition;
        }

        @Override
        public boolean isArray() throws Exception {
            return false;
        }
    }

    private static class OwSingleAttributeComplexInternalField
    implements OwField {
        private OwFieldDefinition m_fielddefinition;
        private int m_index;
        private Object[] m_value;

        public OwSingleAttributeComplexInternalField(Object[] values_p, int index_p, OwFieldDefinition fielddefinition_p) throws Exception {
            this.m_value = values_p;
            this.m_index = index_p;
            this.m_fielddefinition = fielddefinition_p;
        }

        @Override
        public OwFieldDefinition getFieldDefinition() throws Exception {
            return this.m_fielddefinition;
        }

        @Override
        public Object getValue() throws Exception {
            return this.m_value[this.m_index];
        }

        @Override
        public void setValue(Object value_p) throws Exception {
            this.m_value[this.m_index] = value_p;
        }
    }
}

