/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwDynamicLayoutSettings;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwLayout;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OwSubLayout
extends OwLayout {
    private static final int DEFAULT_NAVIGATION_PANEL_WIDTH = 235;
    private static Logger LOG = OwLogCore.getLogger(OwSubLayout.class);
    private static final String OW_SUB_LAYOUT_JSP = "OwSubLayout.jsp";
    private static final String OW_DYNAMIC_SUB_LAYOUT_JSP = "OwSubLayoutDynamic.jsp";
    public static final int NAVIGATION_REGION = 0;
    public static final int MENU_REGION = 1;
    public static final int MAIN_REGION = 2;
    public static final int HOT_KEY_REGION = 3;
    public static final int DND_REGION = 4;
    public static final int SECONDARY_REGION = 5;
    protected OwMainAppContext m_MainContext;
    protected OwConfiguration m_Configuration;
    protected boolean m_isDynamicSplitInUse = false;
    protected boolean m_saveSplitPosition = true;
    protected OwDynamicLayoutSettings m_settings = null;
    private String m_layoutBagPrefix = null;
    private Map<Integer, Map<String, String>> customRegionAttributes = new HashMap<Integer, Map<String, String>>();
    private ReentrantLock customRegionLock = new ReentrantLock();

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_MainContext = (OwMainAppContext)this.getContext();
        this.m_Configuration = this.m_MainContext.getConfiguration();
        this.m_isDynamicSplitInUse = this.m_Configuration.isDynamicSplitInUse();
        this.m_layoutBagPrefix = this.m_Configuration.getLayoutConfigurationBagPrefix();
    }

    protected OwDynamicLayoutSettings createLayoutSettings() {
        return new OwDynamicLayoutSettings(this.m_saveSplitPosition, this.getContext(), this.getBagID());
    }

    protected OwDynamicLayoutSettings getLayoutSettings() {
        if (this.m_settings == null) {
            this.m_settings = this.createLayoutSettings();
        }
        return this.m_settings;
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        String jspPath = this.m_isDynamicSplitInUse ? OW_DYNAMIC_SUB_LAYOUT_JSP : OW_SUB_LAYOUT_JSP;
        this.serverSideDesignInclude(jspPath, w_p);
        if (this.m_isDynamicSplitInUse) {
            this.getContext().renderJSInclude("/js/owsublayout.js", w_p);
        }
    }

    public void onAjaxNavigationPanelResize(HttpServletRequest request_p, HttpServletResponse response_p) {
        String width = request_p.getParameter("width");
        if (this.m_isDynamicSplitInUse) {
            try {
                if (width != null && !width.isEmpty()) {
                    this.getLayoutSettings().setWidth(Integer.parseInt(width));
                }
            }
            catch (NumberFormatException e) {
                LOG.debug((Object)"OwSubLayout.onAjaxNavigationPanelResize(): Cannot convert the values as int values", (Throwable)e);
            }
        }
    }

    public void onAjaxPanelCollapsedStateChanged(HttpServletRequest request_p, HttpServletResponse response_p) {
        String strPanelId = request_p.getParameter("panelId");
        String strCollapsedState = request_p.getParameter("collapsedState");
        if ("navContentPanel".equals(strPanelId)) {
            this.setCustomRegionAttribute(0, "data-collapsed", strCollapsedState);
        } else if ("secContentPanel".equals(strPanelId)) {
            this.setCustomRegionAttribute(5, "data-collapsed", strCollapsedState);
        }
    }

    public int getNavigationPanelWidth() {
        int result = 235;
        if (this.m_isDynamicSplitInUse) {
            result = this.getLayoutSettings().getWidth();
        }
        return result;
    }

    protected String getBagID() {
        return this.m_layoutBagPrefix + this.m_MainContext.getCurrentMasterPluginID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomRegionAttribute(int regionId_p, String attribute_p, String value_p) {
        this.customRegionLock.lock();
        try {
            Map<String, String> regionAttributes;
            if (this.customRegionAttributes == null) {
                this.customRegionAttributes = new HashMap<Integer, Map<String, String>>();
            }
            if ((regionAttributes = this.customRegionAttributes.get(regionId_p)) == null) {
                regionAttributes = new HashMap<String, String>();
                this.customRegionAttributes.put(regionId_p, regionAttributes);
            }
            regionAttributes.put(attribute_p, value_p);
        }
        finally {
            this.customRegionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomRegionAttributes(Map<Integer, Map<String, String>> customRegionAttributes) {
        this.customRegionLock.lock();
        try {
            this.customRegionAttributes = customRegionAttributes;
        }
        finally {
            this.customRegionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Map<String, String>> getCustomRegionAttributes() {
        this.customRegionLock.lock();
        try {
            Map<Integer, Map<String, String>> map = this.customRegionAttributes;
            return map;
        }
        finally {
            this.customRegionLock.unlock();
        }
    }

    public synchronized String createRegionCustomAttributes(int regionId_p) {
        Map<String, String> attributes;
        if (this.customRegionAttributes != null && (attributes = this.customRegionAttributes.get(regionId_p)) != null) {
            StringBuilder attributeString = new StringBuilder();
            Set<Map.Entry<String, String>> attEntries = attributes.entrySet();
            for (Map.Entry<String, String> entry : attEntries) {
                attributeString.append(" ");
                attributeString.append(entry.getKey());
                attributeString.append("=\"");
                attributeString.append(entry.getValue());
                attributeString.append("\"");
            }
            return attributeString.toString();
        }
        return "";
    }
}

