/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app.impl.viid;

import com.wewebu.ow.server.app.id.OwIdDecoder;
import com.wewebu.ow.server.app.id.viid.OwVIId;
import com.wewebu.ow.server.app.id.viid.OwVIIdFactory;
import com.wewebu.ow.server.app.id.viid.OwVIIdType;
import com.wewebu.ow.server.app.impl.viid.OwSimpleVIId;
import com.wewebu.ow.server.app.impl.viid.OwSimpleVIIdDecoder;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwInaccessibleException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.util.OwString;

public class OwSimpleVIIdFactory
implements OwVIIdFactory {
    @Override
    public OwVIId createVersionIndependentId(OwObject obj) throws OwNotSupportedException {
        String resourceId;
        OwVIId objVID = null;
        try {
            resourceId = obj.getResourceID();
        }
        catch (Exception e1) {
            throw new OwInaccessibleException("Could not retrieve resource/repository Id", "owd.core");
        }
        switch (obj.getType()) {
            case 8193: 
            case 8194: {
                objVID = this.createOwVIId(obj.getID(), resourceId, OwVIIdType.FOLDER);
                break;
            }
            case 4097: {
                try {
                    objVID = this.createOwVIId(obj.getVersionSeries().getId(), resourceId, OwVIIdType.DOCUMENT);
                    break;
                }
                catch (Exception e) {
                    throw new OwInaccessibleException("VersionSeries cannot be retrieved from object", "owd.core");
                }
            }
            case 12291: {
                objVID = this.createOwVIId(obj.getID(), resourceId, OwVIIdType.LINK);
                break;
            }
            case 12288: 
            case 12289: {
                objVID = this.createOwVIId(obj.getID(), resourceId, OwVIIdType.CUSTOM);
                break;
            }
            default: {
                throw new OwNotSupportedException(new OwString("viid.OwSimpleVIIdFactory.createVersionIndependentId.unsupported", "ObjectType not supported for VIId creation"));
            }
        }
        return objVID;
    }

    protected OwVIId createOwVIId(String objId, String resourceId, OwVIIdType type) {
        return new OwSimpleVIId(objId, resourceId, type);
    }

    @Override
    public OwIdDecoder<OwVIId> createViidDecoder() {
        return new OwSimpleVIIdDecoder();
    }
}

