/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.collections;

import com.wewebu.ow.server.collections.OwEmptyIterable;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwIterableAttributeBag;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class OwAggregateIterable<T>
extends OwIterableAttributeBag<T> {
    private static final Logger LOG = OwLogCore.getLogger(OwAggregateIterable.class);
    private OwIterable<T>[] iterables;
    private Map<Integer, Long> totalNumItemsByIndex = new HashMap<Integer, Long>();
    private long skippedOffset;
    private long totalNumItems;
    private long maxPageSize;

    public OwAggregateIterable(List<OwIterable<T>> iterables) {
        this(iterables.toArray(new OwIterable[0]));
    }

    public OwAggregateIterable(OwIterable<T> ... iterables) {
        this(0L, false, iterables[0].getPageNumItems(), -1L, iterables);
    }

    private OwAggregateIterable(long skippedOffset, boolean isPage, long maxPageSize, long totalNumItems, OwIterable<T> ... iterables) {
        this.iterables = iterables;
        this.skippedOffset = skippedOffset;
        this.isPage = isPage;
        this.totalNumItems = totalNumItems;
        this.maxPageSize = maxPageSize;
        LOG.info((Object)"New OwAggregateIterable instance created.");
    }

    @Override
    public OwIterable<T> skipTo(long position) {
        int iterableIndex = 0;
        long count = 0L;
        for (int i = 0; i < this.iterables.length; ++i) {
            if ((count += this.getTotalNumItems(i)) < position) continue;
            iterableIndex = i;
            break;
        }
        if (position > count) {
            return OwEmptyIterable.instance();
        }
        long skipOffset = this.getTotalNumItems(iterableIndex) - (count - position);
        LinkedList<OwIterable<T>> newIterables = new LinkedList<OwIterable<T>>();
        newIterables.add(this.iterables[iterableIndex].skipTo(skipOffset));
        for (int i = iterableIndex + 1; i < this.iterables.length; ++i) {
            newIterables.add(this.iterables[i]);
        }
        return new OwAggregateIterable<T>(skipOffset, this.isPage, this.maxPageSize, this.getTotalNumItems(), newIterables.toArray(new OwIterable[0]));
    }

    private long getTotalNumItems(int iterableIndex) {
        OwIterable<T> owIterable = this.iterables[iterableIndex];
        long totalNumItems = owIterable.getTotalNumItems();
        if (totalNumItems < 0L) {
            Long cachedCount = this.totalNumItemsByIndex.get(iterableIndex);
            if (null != cachedCount) {
                return cachedCount;
            }
            totalNumItems = 0L;
            boolean finished = false;
            while (!finished) {
                OwIterable<T> currentPage = owIterable.skipTo(totalNumItems).getPage();
                for (T item : currentPage) {
                    ++totalNumItems;
                }
                if (currentPage.getHasMoreItems()) continue;
                finished = true;
            }
            this.totalNumItemsByIndex.put(iterableIndex, totalNumItems);
        }
        return totalNumItems;
    }

    @Override
    public OwIterable<T> getPage() {
        return this.getPage((int)this.getPageNumItems());
    }

    @Override
    public OwIterable<T> getPage(int maxNumItems) {
        LinkedList<OwIterable<T>> pageIterables = new LinkedList<OwIterable<T>>();
        long count = this.getTotalNumItems(0) - this.skippedOffset;
        if (count >= (long)maxNumItems) {
            pageIterables.add(this.iterables[0].getPage(maxNumItems));
        } else {
            pageIterables.add(this.iterables[0].getPage((int)count));
            for (int i = 1; i < this.iterables.length; ++i) {
                long currentNumItems = this.getTotalNumItems(i);
                if (count >= (long)maxNumItems) break;
                if ((count += currentNumItems) >= (long)maxNumItems) {
                    long tail = (long)maxNumItems - (count - currentNumItems);
                    pageIterables.add(this.iterables[i].getPage((int)tail));
                    continue;
                }
                pageIterables.add(this.iterables[i]);
            }
        }
        return new OwAggregateIterable<T>(this.skippedOffset, true, maxNumItems, this.getTotalNumItems(), pageIterables.toArray(new OwIterable[0]));
    }

    @Override
    public Iterator<T> iterator() {
        LinkedList iterators = new LinkedList();
        for (OwIterable<T> iterable : this.iterables) {
            iterators.add(iterable.iterator());
        }
        return new AggregateIterator(iterators);
    }

    @Override
    public long getPageNumItems() {
        long numItems;
        int index = 0;
        for (numItems = this.iterables[index].getPageNumItems(); numItems < this.maxPageSize && !this.iterables[index].getHasMoreItems() && ++index < this.iterables.length; numItems += this.iterables[index].getPageNumItems()) {
        }
        numItems = Math.min(this.maxPageSize, numItems);
        return numItems;
    }

    @Override
    public boolean getHasMoreItems() {
        if (this.iterables[0].getHasMoreItems()) {
            return true;
        }
        for (int i = 1; i < this.iterables.length; ++i) {
            if (this.iterables[i].getTotalNumItems() <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getTotalNumItems() {
        if (!this.isPage && this.totalNumItems < 0L) {
            this.totalNumItems = 0L;
            for (int i = 0; i < this.iterables.length; ++i) {
                long numItems = this.getTotalNumItems(i);
                if (numItems < 0L) {
                    this.totalNumItems = -1L;
                    break;
                }
                this.totalNumItems += numItems;
            }
        }
        return this.totalNumItems;
    }

    public static <IT> OwIterable<IT> forList(List<OwIterable<IT>> list) {
        ArrayList filteredList = new ArrayList();
        for (OwIterable<IT> owIterable : list) {
            if (owIterable.getTotalNumItems() == 0L) continue;
            filteredList.add(owIterable);
        }
        if (1 == filteredList.size()) {
            return (OwIterable)filteredList.get(0);
        }
        if (filteredList.isEmpty()) {
            return new OwEmptyIterable();
        }
        return new OwAggregateIterable(filteredList);
    }

    private class AggregateIterator<T>
    implements Iterator<T> {
        private int iteratorIndex = 0;
        private List<Iterator<T>> iterators;

        private AggregateIterator(List<Iterator<T>> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            Iterator<T> current = this.iterators.get(this.iteratorIndex);
            if (current.hasNext()) {
                return true;
            }
            return this.iteratorIndex < this.iterators.size() - 1 && this.iterators.get(this.iteratorIndex + 1).hasNext();
        }

        @Override
        public T next() {
            Iterator<T> current = this.iterators.get(this.iteratorIndex);
            if (!current.hasNext() && this.iteratorIndex < this.iterators.size() - 1) {
                ++this.iteratorIndex;
                current = this.iterators.get(this.iteratorIndex);
            }
            if (current.hasNext()) {
                return current.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Delete/Remove is not supported by this iterator");
        }
    }
}

