/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.collections;

import com.wewebu.ow.server.collections.OwEmptyIterable;
import com.wewebu.ow.server.collections.OwItemFilter;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwIterableAttributeBag;
import com.wewebu.ow.server.collections.OwObjectCollectionIterableAdapter;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class OwFilteringIterable<T>
extends OwIterableAttributeBag<T> {
    private static final Logger LOG = OwLogCore.getLogger(OwFilteringIterable.class);
    private OwIterable<T> iterable;
    private OwItemFilter<T> filter;
    private long pageSize;
    private long count;
    private boolean exactCalculation;

    public OwFilteringIterable(OwIterable<T> iterable, OwItemFilter<T> filter) {
        this(iterable, filter, iterable.getPageNumItems());
    }

    public OwFilteringIterable(OwIterable<T> iterable, OwItemFilter<T> filter, long pageSize) {
        this(iterable, filter, pageSize, false);
    }

    public OwFilteringIterable(OwIterable<T> iterable, OwItemFilter<T> filter, long pageSize, boolean exactCalculation) {
        this.iterable = iterable;
        this.filter = filter;
        this.pageSize = pageSize;
        this.exactCalculation = exactCalculation;
        this.count = -1L;
    }

    @Override
    public OwIterable<T> skipTo(long position) {
        if (this.iterable.getTotalNumItems() >= 0L && position > this.iterable.getTotalNumItems()) {
            return OwEmptyIterable.instance();
        }
        long positionToSkip = -1L;
        long acceptedItems = 0L;
        OwIterable<T> it = this.iterable.skipTo(0L);
        for (T item : it) {
            if (this.filter.accept(item)) {
                ++acceptedItems;
            }
            ++positionToSkip;
            if (acceptedItems != position + 1L) continue;
            break;
        }
        if (acceptedItems < position + 1L) {
            LOG.warn((Object)("OFilteringIterable.skipTo: Could not jump to possition = " + position + " available items = " + acceptedItems));
            return OwEmptyIterable.instance();
        }
        OwIterable<T> newIterable = this.iterable.skipTo(positionToSkip);
        return new OwFilteringIterable<T>(newIterable, this.filter, this.getPageNumItems());
    }

    @Override
    public OwIterable<T> getPage() {
        return this.getPage((int)this.getPageNumItems());
    }

    @Override
    public OwIterable<T> getPage(int maxNumItems) {
        OwStandardObjectCollection pageItems = new OwStandardObjectCollection();
        Iterator<T> iterator = this.iterator();
        for (int pageItemsCount = 0; pageItemsCount < maxNumItems && iterator.hasNext(); ++pageItemsCount) {
            T nextItem = iterator.next();
            pageItems.add(nextItem);
        }
        return new OwObjectCollectionIterableAdapter((OwObjectCollection)pageItems, iterator.hasNext(), maxNumItems);
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteringIterator(this.iterable.iterator(), this.filter);
    }

    @Override
    public long getPageNumItems() {
        return this.pageSize;
    }

    @Override
    public boolean getHasMoreItems() {
        return false;
    }

    @Override
    public long getTotalNumItems() {
        if (this.isExcatCalculation() && -1L == this.count) {
            this.count = 0L;
            long totalCount = 0L;
            boolean finished = false;
            while (!finished) {
                OwIterable<T> currentPage = this.iterable.skipTo(totalCount).getPage();
                for (T item : currentPage) {
                    if (this.filter.accept(item)) {
                        ++this.count;
                    }
                    ++totalCount;
                }
                if (currentPage.getHasMoreItems()) continue;
                finished = true;
            }
        }
        return this.count;
    }

    public void setExactCalculation(boolean calculation) {
        this.exactCalculation = calculation;
    }

    public boolean isExcatCalculation() {
        return this.exactCalculation;
    }

    private class FilteringIterator<O>
    implements Iterator<O> {
        private Iterator<O> iterator;
        private OwItemFilter<O> filter;
        private O nextElement = null;
        private long itemCount = 0L;

        private FilteringIterator(Iterator<O> iterator, OwItemFilter<O> filter) {
            this.iterator = iterator;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (null != this.nextElement) {
                return true;
            }
            Object result = null;
            while (this.iterator.hasNext()) {
                result = this.iterator.next();
                if (!this.filter.accept(result)) continue;
                this.nextElement = result;
                return true;
            }
            return false;
        }

        @Override
        public O next() {
            ++this.itemCount;
            O result = this.nextElement;
            this.nextElement = null;
            if (null != result) {
                return result;
            }
            while (this.iterator.hasNext()) {
                result = this.iterator.next();
                if (!this.filter.accept(result)) continue;
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

