/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.collections;

import com.wewebu.ow.server.collections.OwLoadContextInfo;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import java.util.Collection;

public class OwLoadContext
implements OwLoadContextInfo {
    public static final int DEFAULT_PAGE_SIZE = 50;
    private static final int[] NO_TYPES = new int[0];
    private int[] objectTypes;
    private Collection<String> propertyNames;
    private OwSort sorting;
    private long maxSize;
    private long skipCount;
    private int versionSelection;
    private int pageSize;
    private OwSearchNode filter;

    public OwLoadContext() {
        this.pageSize = 50;
    }

    public OwLoadContext(OwLoadContextInfo ctxInfo) {
        this.setObjectTypes(ctxInfo.getObjectTypes());
        this.setSorting(ctxInfo.getSorting());
        this.setFilter(ctxInfo.getFilter());
        this.setMaxSize(ctxInfo.getMaxSize());
        this.setPropertyNames(ctxInfo.getPropertyNames());
        this.setVersionSelection(ctxInfo.getVersionSelection());
        this.pageSize = ctxInfo.getPageSize() <= 0 ? 50 : ctxInfo.getPageSize();
    }

    @Override
    public int[] getObjectTypes() {
        return this.objectTypes == null ? NO_TYPES : this.objectTypes;
    }

    public void setObjectTypes(int ... objectTypes) {
        if (objectTypes != null) {
            this.objectTypes = new int[objectTypes.length];
            System.arraycopy(objectTypes, 0, this.objectTypes, 0, objectTypes.length);
        } else {
            this.objectTypes = NO_TYPES;
        }
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(Collection<String> propertyNames) {
        this.propertyNames = propertyNames;
    }

    @Override
    public OwSort getSorting() {
        return this.sorting;
    }

    public void setSorting(OwSort sort) {
        this.sorting = sort;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public int getVersionSelection() {
        return this.versionSelection;
    }

    public void setVersionSelection(int versionSelection) {
        this.versionSelection = versionSelection;
    }

    @Override
    public OwSearchNode getFilter() {
        return this.filter;
    }

    public void setFilter(OwSearchNode filterCriteria) {
        this.filter = filterCriteria;
    }

    public boolean includeFolders() {
        for (int type : this.objectTypes) {
            if (type != 8192 && type != 8193) continue;
            return true;
        }
        return false;
    }

    public boolean includeDocuments() {
        for (int type : this.objectTypes) {
            if (type != 4096 && type != 4097) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(long skipCount) {
        this.skipCount = skipCount;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

