/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.collections;

import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwIterableAttributeBag;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import java.util.Iterator;

public class OwObjectCollectionIterableAdapter<T>
extends OwIterableAttributeBag<T> {
    private static final int DEFAULT_PAGE_SIZE = 10;
    private OwObjectCollection owCollection;
    private long position;
    private int maxNumItems;
    private Boolean hasMoreItems = Boolean.FALSE;

    public OwObjectCollectionIterableAdapter(OwObjectCollection owCollection) {
        this(owCollection, 0L, 10);
    }

    public OwObjectCollectionIterableAdapter(OwObjectCollection owCollection, int maxNumItems) {
        this(owCollection, 0L, maxNumItems);
    }

    public OwObjectCollectionIterableAdapter(OwObjectCollection owCollection, boolean hasMoreItems) {
        this(owCollection, hasMoreItems, 10);
    }

    public OwObjectCollectionIterableAdapter(OwObjectCollection owCollection, boolean hasNext, int maxNumItems) {
        this.owCollection = owCollection;
        this.maxNumItems = maxNumItems;
        this.hasMoreItems = hasNext;
    }

    private OwObjectCollectionIterableAdapter(OwObjectCollection owCollection, long position, int maxNumItems) {
        this.owCollection = owCollection;
        this.position = position;
        this.maxNumItems = maxNumItems;
        this.hasMoreItems = this.position + (long)this.maxNumItems < (long)this.owCollection.size();
    }

    @Override
    public OwIterable<T> skipTo(long position) {
        return new OwObjectCollectionIterableAdapter<T>(this.owCollection, position, this.maxNumItems);
    }

    @Override
    public OwIterable<T> getPage() {
        int start = (int)this.position;
        int end = (int)(this.position + (long)this.maxNumItems);
        if (end > this.owCollection.size()) {
            end = this.owCollection.size();
        }
        OwStandardObjectCollection subCollection = new OwStandardObjectCollection();
        subCollection.addAll(this.owCollection.subList(start, end));
        OwObjectCollectionIterableAdapter<T> page = new OwObjectCollectionIterableAdapter<T>((OwObjectCollection)subCollection, 0L, this.maxNumItems);
        page.hasMoreItems = end < this.owCollection.size();
        page.isPage = true;
        return page;
    }

    @Override
    public OwIterable<T> getPage(int maxNumItems) {
        int start = (int)this.position;
        int end = (int)(this.position + (long)maxNumItems);
        if (end > this.owCollection.size()) {
            end = this.owCollection.size();
        }
        OwStandardObjectCollection subCollection = new OwStandardObjectCollection();
        subCollection.addAll(this.owCollection.subList(start, end));
        OwObjectCollectionIterableAdapter<T> page = new OwObjectCollectionIterableAdapter<T>((OwObjectCollection)subCollection, 0L, maxNumItems);
        page.hasMoreItems = end < this.owCollection.size();
        page.isPage = true;
        return page;
    }

    @Override
    public Iterator<T> iterator() {
        return this.owCollection.subList((int)this.position, this.owCollection.size()).iterator();
    }

    @Override
    public long getPageNumItems() {
        return this.maxNumItems;
    }

    @Override
    public boolean getHasMoreItems() {
        return this.hasMoreItems;
    }

    @Override
    public long getTotalNumItems() {
        return this.owCollection.size();
    }
}

