/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.collections.impl;

import com.wewebu.ow.server.collections.impl.OwAbstractPageFetcher;
import com.wewebu.ow.server.collections.impl.OwPage;
import java.util.Iterator;
import java.util.List;

public abstract class OwAbstractIterator<T>
implements Iterator<T> {
    private long skipCount;
    private int skipOffset;
    private final OwAbstractPageFetcher<T> pageFetcher;
    private Long totalNumItems;
    protected OwPage<T> page;
    private Boolean hasMoreItems;

    protected OwAbstractIterator(long skipCount, OwAbstractPageFetcher<T> pageFetcher) {
        this.skipCount = skipCount;
        this.pageFetcher = pageFetcher;
    }

    public long getTotalNumItems() {
        if (this.totalNumItems == null) {
            this.totalNumItems = -1L;
            OwPage<T> currentPage = this.getCurrentPage();
            if (null != currentPage && null != currentPage.getTotalNumItems()) {
                this.totalNumItems = currentPage.getTotalNumItems();
            }
        }
        return this.totalNumItems;
    }

    public boolean getHasMoreItems() {
        if (this.hasMoreItems == null) {
            this.hasMoreItems = Boolean.FALSE;
            OwPage<T> page = this.getCurrentPage();
            if (page != null && page.getHasMoreItems() != null) {
                this.hasMoreItems = page.getHasMoreItems();
            }
        }
        return this.hasMoreItems;
    }

    protected OwPage<T> getCurrentPage() {
        if (this.page == null) {
            this.page = this.pageFetcher.fetchPage(this.skipCount);
        }
        return this.page;
    }

    public long getPageNumItems() {
        List<T> items;
        OwPage<T> page = this.getCurrentPage();
        if (page != null && (items = page.getItems()) != null) {
            return items.size();
        }
        return 0L;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected long getSkipCount() {
        return this.skipCount;
    }

    protected int getSkipOffset() {
        return this.skipOffset;
    }

    protected OwPage<T> incrementPage() {
        this.skipCount += (long)this.skipOffset;
        this.skipOffset = 0;
        this.totalNumItems = null;
        this.hasMoreItems = null;
        this.page = this.pageFetcher.fetchPage(this.skipCount);
        return this.page;
    }

    protected int incrementSkipOffset() {
        return this.skipOffset++;
    }

    protected OwAbstractPageFetcher<T> getPageFetcher() {
        return this.pageFetcher;
    }
}

