/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.command;

import com.wewebu.ow.server.ecm.OwObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class OwMultipleObjectsProcessCollector {
    private List m_failToProcessMessages = new LinkedList();
    private List m_unprocessedObjectsData = new LinkedList();
    private List m_processedObjectsData = new LinkedList();
    private List m_failedObjectsData = new LinkedList();

    public OwObjectCollectData createCollectData(OwObject object_p) throws Exception {
        return new OwObjectCollectData(object_p);
    }

    public void addUnprocessedObjectData(OwObjectCollectData collectData_p) {
        this.m_unprocessedObjectsData.add(collectData_p);
    }

    public void addProcessedObjectData(OwObjectCollectData collectData_p) {
        this.m_processedObjectsData.add(collectData_p);
    }

    public void addFailedObjectData(OwObjectCollectData collectData_p) {
        this.m_failedObjectsData.add(collectData_p);
    }

    public void clear() {
        this.m_failToProcessMessages.clear();
        this.m_processedObjectsData.clear();
        this.m_unprocessedObjectsData.clear();
        this.m_failedObjectsData.clear();
    }

    public void addProcessedObjectFailureMessages(String localizedMessage_p) {
        this.m_failToProcessMessages.add(localizedMessage_p);
    }

    public String getFailToProcessErrorMessages() {
        return this.getMessages(this.m_failToProcessMessages);
    }

    public boolean hasProcessedObjects() {
        return !this.m_processedObjectsData.isEmpty();
    }

    public boolean hasProcessErrors() {
        return !this.m_failedObjectsData.isEmpty();
    }

    public Set getProcessedDmsIds() {
        HashSet<String> processedDMSIDS = new HashSet<String>();
        for (OwObjectCollectData collectData : this.m_processedObjectsData) {
            processedDMSIDS.add(collectData.getCachedObjectDMSID());
        }
        return processedDMSIDS;
    }

    public List getProcessedNames() {
        LinkedList<String> processedNames = new LinkedList<String>();
        for (OwObjectCollectData collectData : this.m_processedObjectsData) {
            processedNames.add(collectData.getCachedObjectName());
        }
        return processedNames;
    }

    private List createListOfObjectNames(List collectDataList_p) {
        LinkedList<String> result = new LinkedList<String>();
        for (OwObjectCollectData collectData : collectDataList_p) {
            result.add(collectData.getCachedObjectName());
        }
        return result;
    }

    private List createListOfObjects(List collectDataList_p) {
        LinkedList<OwObject> result = new LinkedList<OwObject>();
        for (OwObjectCollectData collectData : collectDataList_p) {
            result.add(collectData.getObject());
        }
        return result;
    }

    public List getProcessedObjects() {
        LinkedList<OwObject> processedObjects = new LinkedList<OwObject>();
        for (OwObjectCollectData collectData : this.m_processedObjectsData) {
            processedObjects.add(collectData.getObject());
        }
        return processedObjects;
    }

    public List getFailToProcessNames() {
        return this.createListOfObjectNames(this.m_failedObjectsData);
    }

    private String getMessages(List objectsMessages_p) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < objectsMessages_p.size(); ++i) {
            buf.append(objectsMessages_p.get(i));
            if (i >= objectsMessages_p.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public boolean hasErrors() {
        return this.hasProcessErrors();
    }

    public List getAllErrorNames() {
        List result = this.getFailToProcessNames();
        return result;
    }

    public List getAllErrorObjects() {
        return this.createListOfObjects(this.m_failedObjectsData);
    }

    public String getAllErrorMessages() {
        List result = this.m_failToProcessMessages;
        return this.getMessages(result);
    }

    public List getDisabledObjects() {
        return this.createListOfObjects(this.m_unprocessedObjectsData);
    }

    public List getDisabledObjectNames() {
        return this.createListOfObjectNames(this.m_unprocessedObjectsData);
    }

    public List getFailedObjectsData() {
        return this.m_failedObjectsData;
    }

    public static class OwObjectCollectData {
        private OwObject m_object;
        private String m_objectDMSIDCache;
        private String m_objectNameCache;
        private Exception failureReason;

        public OwObjectCollectData(OwObject object_p) throws Exception {
            this.m_object = object_p;
            this.m_objectDMSIDCache = object_p.getDMSID();
            this.m_objectNameCache = object_p.getName();
        }

        public OwObject getObject() {
            return this.m_object;
        }

        public String getCachedObjectDMSID() {
            return this.m_objectDMSIDCache;
        }

        public String getCachedObjectName() {
            return this.m_objectNameCache;
        }

        public void setFailureReason(Exception failureReason_p) {
            this.failureReason = failureReason_p;
        }

        public Exception getFailureReason() {
            return this.failureReason;
        }
    }
}

