/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwJspFormConfigurator;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.app.OwStandardDialog;
import com.wewebu.ow.server.app.OwSubLayout;
import com.wewebu.ow.server.app.OwSubNavigationView;
import com.wewebu.ow.server.dmsdialogs.OwCreateObjectWithFormDialog;
import com.wewebu.ow.server.dmsdialogs.OwFormPropertyViewBridge;
import com.wewebu.ow.server.dmsdialogs.OwPropertyViewBridge;
import com.wewebu.ow.server.dmsdialogs.OwStandardPropertyViewBridge;
import com.wewebu.ow.server.dmsdialogs.views.OwMultipanelAccessRightsView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassProcessor;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyFormularView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyView;
import com.wewebu.ow.server.dmsdialogs.views.classes.OwObjectClassSelectionCfg;
import com.wewebu.ow.server.dmsdialogs.views.classes.OwRootClassCfg;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwVirtualFolderObject;
import com.wewebu.ow.server.ecmimpl.OwSimpleLocation;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.ui.OwConfigurableDialog;
import com.wewebu.ow.server.ui.OwDelegateView;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwJspConfigurable;
import com.wewebu.ow.server.ui.OwNavigationView;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.wd.ui.conf.OwPropertyListConfiguration;
import org.alfresco.wd.ui.conf.prop.OwPropertyInfo;
import org.apache.log4j.Logger;

public class OwCreateObjectDialog
extends OwStandardDialog
implements OwObjectClassView.OwObjectClassViewListner,
OwConfigurableDialog,
OwJspConfigurable {
    private static final Logger LOG = OwLogCore.getLogger(OwCreateObjectDialog.class);
    protected OwSubLayout m_Layout;
    protected OwObjectSkeleton m_sceletonObject;
    protected OwObjectClassView m_classView;
    protected OwSubNavigationView m_SubNavigation;
    protected OwPropertyViewBridge propertyViewBridge;
    private String m_strDmsID;
    protected OwObject m_folderObject;
    protected String m_strObjectClass;
    protected String m_strObjectClassParent;
    protected OwObjectClass m_folderClass;
    protected OwClientRefreshContext m_RefreshCtx;
    protected boolean m_fOpenObject;
    protected Map m_ValuesMap;
    protected Collection m_propertyInfos;
    public static final int DIALOG_STATUS_NONE = 0;
    public static final int DIALOG_STATUS_OK = 1;
    public static final int DIALOG_STATUS_FAILED = 2;
    protected int m_dialogStatus = 0;
    private OwJspFormConfigurator m_jspFormConfigurator;
    protected OwDelegateView delegateView;
    protected OwNavigationView.OwTabInfo propertiesTab;
    protected String m_objectClassName = null;
    protected OwMultipanelAccessRightsView accessRightsView;
    protected OwXMLUtil m_configNode;
    private OwObjectClassSelectionCfg classSelectionCfg;
    private OwObjectClassProcessor objectClassProcessor;
    private OwPropertyListConfiguration propertyListConfiguration;

    public OwCreateObjectDialog(OwObject folderObject_p, String strClassName_p, String strObjectClassParent_p, boolean fOpenObject_p) {
        this.m_folderObject = folderObject_p;
        this.m_strObjectClass = strClassName_p;
        this.m_fOpenObject = fOpenObject_p;
        this.m_strObjectClassParent = strObjectClassParent_p;
        this.setDocument(this.createDocument());
    }

    public OwCreateObjectDialog(OwObject folderObject_p, OwObjectClassSelectionCfg classSelectionCfg, boolean fOpenObject_p) {
        this.m_folderObject = folderObject_p;
        this.classSelectionCfg = classSelectionCfg;
        this.m_fOpenObject = fOpenObject_p;
        this.setDocument(this.createDocument());
    }

    protected OwDocument createDocument() {
        return new OwDocument();
    }

    public int getStatus() {
        return this.m_dialogStatus;
    }

    public void setValues(Map properties_p) {
        this.m_ValuesMap = properties_p;
    }

    public void setPropertyInfos(List propertyInfos_p) {
        this.m_propertyInfos = propertyInfos_p;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.getDocument().attach(this.getContext(), null);
        this.m_Layout = new OwSubLayout();
        this.addView(this.m_Layout, 2, null);
        this.m_SubNavigation = new OwSubNavigationView();
        this.m_Layout.addView(this.m_SubNavigation, 0, null);
        this.m_SubNavigation.setValidatePanels(true);
        this.m_Layout.addViewReference(this.m_SubNavigation.getViewReference(), 2);
        this.delegateView = this.createDelegateView();
        if (null == this.classSelectionCfg) {
            if (this.m_strObjectClass == null) {
                this.m_classView = new OwObjectClassView(this.m_folderObject.getResource(), 8193, this.m_strObjectClassParent);
                if (this.getObjectClassProcessor() != null) {
                    this.m_classView.setObjectClassProcessor(this.getObjectClassProcessor());
                }
                this.m_SubNavigation.addView(this.m_classView, this.getContext().localize("owaddrecord.OwCreateRecordDialog.class_title", "Choose class"), null, this.getContext().getDesignURL() + "/images/plug/owdocprops/class.png", null, null);
                this.m_classView.setSelectedItemStyle("OwSaveDlgObjectClassTextSelected");
                this.m_classView.setItemStyle("OwSaveDlgObjectClassText");
                this.m_classView.setEventListner(this);
            }
        } else if (!this.classSelectionCfg.hasDefaultClass()) {
            this.m_classView = new OwObjectClassView(this.m_folderObject.getResource(), 8193, this.classSelectionCfg);
            if (this.getObjectClassProcessor() != null) {
                this.m_classView.setObjectClassProcessor(this.getObjectClassProcessor());
            }
            this.m_SubNavigation.addView(this.m_classView, this.getContext().localize("owaddrecord.OwCreateRecordDialog.class_title", "Choose class"), null, this.getContext().getDesignURL() + "/images/plug/owdocprops/class.png", null, null);
            this.m_classView.setSelectedItemStyle("OwSaveDlgObjectClassTextSelected");
            this.m_classView.setItemStyle("OwSaveDlgObjectClassText");
            this.m_classView.setEventListner(this);
        }
        if (this.getConfigNode().getSafeBooleanValue("AccessRightsView", false)) {
            this.accessRightsView = this.createAccessRightsView();
            this.accessRightsView.setReadOnly(this.getConfigNode().getSubUtil("AccessRightsView").getSafeBooleanAttributeValue("readonly", false));
            this.m_SubNavigation.addView(this.accessRightsView, this.getContext().localize("owaddrecord.OwCreateRecordDialog.AccessRights_Title", "Access Rights"), null, this.getContext().getDesignURL() + "/images/plug/owdocprops/accessrights.png", null, null);
            this.accessRightsView.setNextActivateView(this.delegateView);
        }
        this.propertyViewBridge = this.createPropertyViewBridge();
        int propTab = this.m_SubNavigation.addView(this.delegateView, this.getContext().localize("owaddrecord.OwCreateRecordDialog.properties_title", "Properties"), null, this.getContext().getDesignURL() + "/images/plug/owdocprops/properties.png", null, null);
        this.propertiesTab = (OwNavigationView.OwTabInfo)this.m_SubNavigation.getTabList().get(propTab);
        this.initTabOrder();
        this.propertyViewBridge.setReadOnlyContext(1);
        if (null == this.classSelectionCfg) {
            if (this.m_strObjectClass != null) {
                this.m_folderClass = ((OwMainAppContext)this.getContext()).getNetwork().getObjectClass(this.m_strObjectClass, this.m_folderObject.getResource());
                this.updateObjectClass();
            }
        } else if (this.classSelectionCfg.hasDefaultClass()) {
            OwRootClassCfg defaultRootClassCfg = this.classSelectionCfg.getDefaultClass();
            this.m_folderClass = ((OwMainAppContext)this.getContext()).getNetwork().getObjectClass(defaultRootClassCfg.getName(), this.m_folderObject.getResource());
            this.updateObjectClass();
        }
        this.m_SubNavigation.navigate(0);
    }

    protected void initTabOrder() throws Exception {
        if (null != this.m_classView) {
            if (this.accessRightsView == null) {
                this.m_classView.setNextActivateView(this.delegateView);
            } else {
                this.m_classView.setNextActivateView(this.accessRightsView);
                this.accessRightsView.setPrevActivateView(this.m_classView);
            }
        }
        if (this.accessRightsView != null) {
            this.propertiesTab.setDisabled(!this.accessRightsView.isValidated());
        }
    }

    protected OwPropertyViewBridge createPropertyViewBridge() throws Exception {
        OwPropertyViewBridge bridge = null;
        if (this.getJspConfigurator() != null) {
            String jspPage = null;
            if (this.m_objectClassName != null && this.getJspConfigurator().isJspFormEnabled() && (jspPage = this.getJspConfigurator().getJspForm(this.m_objectClassName)) != null) {
                bridge = this.createFormViewBridge();
            }
        }
        if (bridge == null) {
            bridge = this.createStandardViewBridge();
        }
        bridge.setReadOnlyContext(1);
        bridge.setPropertyListConfiguration(this.getPropertyListConfiguration());
        return bridge;
    }

    protected OwFormPropertyViewBridge createFormViewBridge() {
        OwObjectPropertyFormularView view = new OwObjectPropertyFormularView();
        view.setJspConfigurator(this.getJspConfigurator());
        return new OwFormPropertyViewBridge(view);
    }

    protected OwStandardPropertyViewBridge createStandardViewBridge() throws Exception {
        OwStandardPropertyViewBridge bridge = new OwStandardPropertyViewBridge(this.createObjectPropertyView());
        return bridge;
    }

    protected OwObjectPropertyView createObjectPropertyView() throws Exception {
        return new OwObjectPropertyView();
    }

    @Override
    public void detach() {
        super.detach();
        this.getDocument().detach();
        if (this.getPropertyListConfiguration() != null) {
            this.propertyListConfiguration = null;
        }
    }

    public OwObject getNewObject() throws Exception {
        if (null == this.m_strDmsID) {
            return null;
        }
        return ((OwMainAppContext)this.getContext()).getNetwork().getObjectFromDMSID(this.m_strDmsID, false);
    }

    @Override
    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        switch (iCode_p) {
            case 2: {
                this.m_strDmsID = this.create();
                this.closeDialog();
                OwObject recordObject = this.getNewObject();
                if (this.m_fOpenObject) {
                    OwMasterDocument recordPlugin = OwMimeManager.getHandlerMasterPlugin((OwMainAppContext)this.getContext(), recordObject);
                    if (recordPlugin == null) {
                        String msg = "OwCreateObjectDialog.onUpdate: Recordplugin Id must be specified if record is created.";
                        LOG.fatal((Object)msg);
                        throw new OwConfigurationException(msg);
                    }
                    recordPlugin.dispatch(1, recordObject, null);
                }
                if (this.m_RefreshCtx == null) break;
                this.m_RefreshCtx.onClientRefreshContextUpdate(8, recordObject);
                this.m_RefreshCtx.onClientRefreshContextUpdate(4, recordObject);
                this.m_RefreshCtx.onClientRefreshContextUpdate(3, recordObject);
            }
        }
    }

    public void setRefreshContext(OwClientRefreshContext pluginRefreshCtx_p) {
        this.m_RefreshCtx = pluginRefreshCtx_p;
    }

    protected String create() throws Exception {
        OwPropertyCollection docStandardPropertiesMap = this.m_sceletonObject.getEditableProperties(1);
        String docType = this.m_sceletonObject.getObjectClass().getClassName();
        OwPermissionCollection permCol = null;
        if (this.getAccessRightsView() != null) {
            permCol = this.m_sceletonObject.getPermissions();
        }
        String newDmsid = null;
        try {
            newDmsid = ((OwMainAppContext)this.getContext()).getNetwork().createNewObject(this.m_folderObject.getResource(), docType, docStandardPropertiesMap, permCol, null, this.m_folderObject, null, null);
            this.m_dialogStatus = 1;
            return newDmsid;
        }
        catch (Exception e) {
            this.m_dialogStatus = 2;
            throw e;
        }
    }

    protected void updateObjectClass() throws Exception {
        OwRoleManagerContext ctx = this.getContext().getRegisteredInterface(OwRoleManagerContext.class);
        if (this.getObjectClassProcessor() != null) {
            OwSimpleLocation location = new OwSimpleLocation(this.m_folderObject);
            OwObjectClass cls = this.getObjectClassProcessor().process(this.m_folderClass, location, this.getContext());
            this.m_sceletonObject = ctx.getNetwork().createObjectSkeleton(cls, this.m_folderObject.getResource());
        } else {
            this.m_sceletonObject = ctx.getNetwork().createObjectSkeleton(this.m_folderClass, this.m_folderObject.getResource());
        }
        if (this.m_folderObject instanceof OwVirtualFolderObject) {
            OwVirtualFolderObject vfObject = (OwVirtualFolderObject)this.m_folderObject;
            vfObject.setFiledObjectProperties(this.m_folderClass, this.m_sceletonObject.getProperties(null));
            if (this.m_propertyInfos == null) {
                this.m_propertyInfos = new ArrayList();
            }
            OwStandardPropertyCollection tempFilledProperties = new OwStandardPropertyCollection();
            vfObject.setFiledObjectProperties(this.m_folderClass, tempFilledProperties);
            for (String propName : this.m_sceletonObject.getProperties(null).keySet()) {
                this.m_propertyInfos.add(new OwPropertyInfo(propName, tempFilledProperties.containsKey(propName)));
            }
        }
        this.m_objectClassName = this.m_sceletonObject.getClassName();
        this.propertyViewBridge = this.createPropertyViewBridge();
        this.delegateView.setView(this.propertyViewBridge.getView());
        if (null != this.m_ValuesMap) {
            for (String strPropName : this.m_ValuesMap.keySet()) {
                try {
                    OwProperty skeletonProp = this.m_sceletonObject.getProperty(strPropName);
                    skeletonProp.setValue(this.m_ValuesMap.get(strPropName));
                }
                catch (OwObjectNotFoundException e) {}
            }
        }
        this.propertyViewBridge.setObjectRef(this.m_sceletonObject, false);
        if (this.getAccessRightsView() != null) {
            this.getAccessRightsView().setObjectRef(this.m_sceletonObject);
        }
        this.propertiesTab.setDisabled(this.m_folderClass == null);
    }

    @Override
    public void onObjectClassViewSelectClass(OwObjectClass classDescription_p, String strPath_p) throws Exception {
        this.m_folderClass = classDescription_p;
        this.updateObjectClass();
    }

    public OwCreateObjectDialog createFormDialog() {
        if (null != this.m_strObjectClass || null != this.m_strObjectClassParent) {
            return new OwCreateObjectWithFormDialog(this.m_folderObject, this.m_strObjectClass, this.m_strObjectClassParent, this.m_fOpenObject, this.m_jspFormConfigurator);
        }
        return new OwCreateObjectWithFormDialog(this.m_folderObject, this.classSelectionCfg, this.m_fOpenObject, this.m_jspFormConfigurator);
    }

    @Override
    public void setConfigNode(OwXMLUtil configNode_p) {
        this.m_configNode = configNode_p;
    }

    @Override
    public void setJspConfigurator(OwJspFormConfigurator jspFormConfigurator_p) {
        this.m_jspFormConfigurator = jspFormConfigurator_p;
    }

    @Override
    public OwXMLUtil getConfigNode() {
        return this.m_configNode;
    }

    @Override
    public OwJspFormConfigurator getJspConfigurator() {
        return this.m_jspFormConfigurator;
    }

    protected OwMultipanelAccessRightsView createAccessRightsView() {
        return new OwMultipanelAccessRightsView();
    }

    protected OwMultipanelAccessRightsView getAccessRightsView() {
        return this.accessRightsView;
    }

    protected OwDelegateView createDelegateView() {
        return new OwDelegateView();
    }

    public void setObjectClassProcessor(OwObjectClassProcessor objProc) {
        this.objectClassProcessor = objProc;
    }

    public OwObjectClassProcessor getObjectClassProcessor() {
        return this.objectClassProcessor;
    }

    public OwPropertyListConfiguration getPropertyListConfiguration() {
        return this.propertyListConfiguration;
    }

    public void setPropertyListConfiguration(OwPropertyListConfiguration propertyListConfiguration) {
        this.propertyListConfiguration = propertyListConfiguration;
    }
}

