/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class OwLaunchableWorkflowSelectionView
extends OwView {
    private static final String ROW_INDEX_PARAMETER = "dRowIndex";
    private List m_workflowDescriptions = new ArrayList();
    private List m_selectionListeners = new ArrayList();

    public OwLaunchableWorkflowSelectionView(Collection workflowDescriptions_p) {
        if (workflowDescriptions_p != null) {
            this.m_workflowDescriptions.addAll(workflowDescriptions_p);
        }
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("dmsdialogs/OwLaunchableWorkflowSelectionView.jsp", w_p);
    }

    public final List getWorkflowDescriptions() {
        return this.m_workflowDescriptions;
    }

    public String createRowLinkURL(int rowIndex_p) {
        return this.getEventURL("RowClick", "dRowIndex=" + rowIndex_p);
    }

    public String getWorkflowDescriptionName(int i_p) {
        OwWorkflowDescription desc = (OwWorkflowDescription)this.m_workflowDescriptions.get(i_p);
        String localizedName = ((OwMainAppContext)this.getContext()).localizeLabel(desc.getName());
        try {
            return OwHTMLHelper.encodeToSecureHTML(localizedName);
        }
        catch (IOException ex) {
            return desc.getName();
        }
    }

    public int getWorkflowDescriptionCount() {
        return this.m_workflowDescriptions.size();
    }

    public boolean hasWorkflowDescrptions() {
        return this.m_workflowDescriptions.size() > 0;
    }

    public void onRowClick(HttpServletRequest request_p) throws Exception {
        String rowIndexParameter = request_p.getParameter(ROW_INDEX_PARAMETER);
        if (rowIndexParameter != null) {
            int rowIndex = Integer.parseInt(rowIndexParameter);
            OwWorkflowDescription description = (OwWorkflowDescription)this.m_workflowDescriptions.get(rowIndex);
            this.fireDescriptionSelected(description);
        }
    }

    public synchronized void addSelectionListener(OwWorkflowSelectionListener listener_p) {
        this.m_selectionListeners.add(listener_p);
    }

    public synchronized void removeSelectionListener(OwWorkflowSelectionListener listener_p) {
        this.m_selectionListeners.remove(listener_p);
    }

    protected synchronized void fireDescriptionSelected(OwWorkflowDescription description_p) {
        for (OwWorkflowSelectionListener listener : this.m_selectionListeners) {
            listener.descriptionSelected(description_p);
        }
    }

    public void renderTableCaption(Writer w_p) throws Exception {
        String title = this.getContext().localize("app.OwLaunchableWorkflowSelectionView.tableCaption", "Table of launchable workflows");
        w_p.write(title);
    }

    public static interface OwWorkflowSelectionListener {
        public void descriptionSelected(OwWorkflowDescription var1);
    }
}

