/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewRow;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwStandardFieldColumnInfo;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwEventTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class OwObjectEditVersionsView
extends OwObjectListViewRow {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectEditVersionsView.class);
    protected OwObject m_ObjectRef;
    protected OwObjectCollection m_versionObjects;
    protected int m_iMaxListSize;
    protected List m_defaultColumnInfoList;
    protected Collection m_defaultPropertyNameList;

    public OwObjectEditVersionsView() {
        super(2);
        this.setMimeTypeContext("OwObjectEditVersionsView");
    }

    @Override
    protected void onActivate(int iIndex_p, Object oReason_p) throws Exception {
        if (this.m_versionObjects == null) {
            this.updateVersions();
        }
    }

    protected void updateVersions() throws Exception {
        OwVersionSeries vSeries = this.m_ObjectRef.getVersionSeries();
        this.m_versionObjects = new OwStandardObjectCollection();
        Collection versions = vSeries.getVersions(this.m_defaultPropertyNameList, this.getSort(), this.m_iMaxListSize);
        Iterator it = versions.iterator();
        while (it.hasNext()) {
            this.m_versionObjects.add(vSeries.getObject((OwVersion)it.next()));
        }
        this.setObjectList(this.m_versionObjects, null);
    }

    public void setObjectRef(OwObject objectRef_p) throws Exception {
        this.m_ObjectRef = objectRef_p;
    }

    public void setColumnProperties(Collection propertyNames_p, int iMaxListSize_p) throws Exception {
        this.m_iMaxListSize = iMaxListSize_p;
        this.createDefaultColumnInfo(propertyNames_p);
    }

    protected void createDefaultColumnInfo(Collection propertyNames_p) throws Exception {
        this.m_defaultPropertyNameList = propertyNames_p;
        if (this.m_defaultPropertyNameList != null) {
            this.m_defaultColumnInfoList = new ArrayList();
            Iterator it = this.m_defaultPropertyNameList.iterator();
            while (it.hasNext()) {
                String strPropertyName = (String)it.next();
                OwFieldDefinition fielddef = null;
                try {
                    fielddef = ((OwMainAppContext)this.getContext()).getNetwork().getFieldDefinition(strPropertyName, null);
                }
                catch (OwObjectNotFoundException e) {
                    LOG.error((Object)("Could not resolve property for contentlist, propertyname = " + strPropertyName));
                    it.remove();
                    continue;
                }
                this.m_defaultColumnInfoList.add(new OwStandardFieldColumnInfo(fielddef));
            }
        } else {
            this.m_defaultColumnInfoList = new Vector();
            this.m_defaultPropertyNameList = new Vector();
        }
        this.setColumnInfo(this.m_defaultColumnInfoList);
    }

    @Override
    protected String getRowClassName(int iIndex_p, OwObject obj_p) {
        boolean fSelectedObject = false;
        try {
            fSelectedObject = obj_p.getVersion().equals(this.m_ObjectRef.getVersion());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (fSelectedObject) {
            return "OwGeneralList_RowMarked";
        }
        return super.getRowClassName(iIndex_p, obj_p);
    }

    @Override
    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        if (1 == iCode_p) {
            this.updateVersions();
        }
    }
}

