/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwSearchCriteriaView;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewRow;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.bpm.OwCaseObject;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwStandardFieldColumnInfo;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwObjectHistoryView
extends OwLayout {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectHistoryView.class);
    public static final int OBJECT_LIST_REGION = 1;
    public static final int SEARCH_CRITERIA_REGION = 2;
    public static final int MENU_REGION = 3;
    public static final int VIEW_MASK_HISTORY_SCOPE_OBJECT = 1;
    public static final int VIEW_MASK_HISTORY_SCOPE_CASE = 2;
    protected int m_iViewMask = 1;
    protected OwObject m_object;
    protected OwObjectListView m_ObjectListView = new OwObjectListViewRow(0);
    protected OwSearchCriteriaView m_SearchCriteriaView;
    protected OwObjectCollection m_historyEntries;
    protected OwSearchTemplate m_searchtemplate;
    protected int m_iMaxSize = 100;
    protected Collection m_propertyColumnList;

    public OwObjectHistoryView(OwSearchTemplate searchTemplate_p, Collection columnInfoList_p, int iMaxSize_p) throws Exception {
        this.m_iMaxSize = iMaxSize_p;
        this.m_searchtemplate = searchTemplate_p;
        this.m_propertyColumnList = columnInfoList_p;
    }

    public void setViewMask(int iViewMask_p) {
        this.m_iViewMask = iViewMask_p;
    }

    protected boolean hasViewMask(int iViewMask_p) {
        return (iViewMask_p & this.m_iViewMask) != 0;
    }

    protected Collection createColumnInfo(Collection propertyList_p) throws Exception {
        ArrayList<OwStandardFieldColumnInfo> columnInfoList = new ArrayList<OwStandardFieldColumnInfo>();
        for (String strPropertyName : propertyList_p) {
            OwFieldDefinition fielddef = null;
            try {
                fielddef = ((OwMainAppContext)this.getContext()).getHistoryManager().getFieldDefinition(strPropertyName, null);
                columnInfoList.add(new OwStandardFieldColumnInfo(fielddef));
            }
            catch (OwObjectNotFoundException e) {
                LOG.warn((Object)("Property could not be resolved for OwObjectHistoryView list: " + strPropertyName), (Throwable)e);
            }
        }
        return columnInfoList;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.addView(this.m_ObjectListView, 1, null);
        if (this.m_searchtemplate != null) {
            this.m_SearchCriteriaView = new OwSearchCriteriaView();
            this.addView(this.m_SearchCriteriaView, 2, null);
            OwSubMenuView m_Menu = new OwSubMenuView();
            m_Menu.addFormMenuItem((OwEventTarget)this, this.getContext().localize("dmsdialogs.views.OwObjectHistoryView.search", "Search"), "SubmitSearch", this.getContext().localize("dmsdialogs.views.OwObjectHistoryView.searchtooltip", "Search for history entries"), this.m_SearchCriteriaView.getFormName());
            this.addView(m_Menu, 3, null);
            this.m_SearchCriteriaView.setCriteriaList(this.m_searchtemplate.getSearch(false).getCriteriaList(1));
            this.m_SearchCriteriaView.setFieldProvider(this.m_searchtemplate);
            this.m_ObjectListView.setColumnInfo(this.m_searchtemplate.getColumnInfoList());
        } else {
            this.m_ObjectListView.setColumnInfo(this.createColumnInfo(this.m_propertyColumnList));
            this.m_propertyColumnList = null;
        }
        this.m_ObjectListView.setSort(new OwSort());
    }

    public void onSubmitSearch(HttpServletRequest request_p, Object user_p) throws Exception {
        if (this.m_SearchCriteriaView.onSubmitSearch(request_p)) {
            this.searchHistory();
        }
    }

    @Override
    public String getFormName() {
        return null;
    }

    public void setObjectRef(OwObject obj_p) throws Exception {
        this.m_object = obj_p;
        this.m_historyEntries = null;
    }

    @Override
    protected void onActivate(int iIndex_p, Object oReason_p) throws Exception {
        if (null == this.m_searchtemplate) {
            this.searchHistory();
        }
    }

    private void searchHistory() throws Exception {
        OwSearchNode search = null;
        if (null != this.m_searchtemplate) {
            search = this.m_searchtemplate.getSearch(false);
        }
        if (this.hasViewMask(1)) {
            this.m_historyEntries = ((OwMainAppContext)this.getContext()).getHistoryManager().doObjectSearch(this.m_object, search, this.m_ObjectListView.getSort(), null, null, this.m_iMaxSize);
        }
        if (this.hasViewMask(2)) {
            try {
                int workitemCount = ((OwCaseObject)((Object)this.m_object)).getWorkitemCount();
                for (int i = 0; i < workitemCount; ++i) {
                    OwObjectReference caseref = ((OwCaseObject)((Object)this.m_object)).getWorkitem(i);
                    OwObjectCollection caseSearch = ((OwMainAppContext)this.getContext()).getHistoryManager().doObjectSearch(caseref, search, this.m_ObjectListView.getSort(), null, null, this.m_iMaxSize);
                    if (null == this.m_historyEntries) {
                        this.m_historyEntries = caseSearch;
                        continue;
                    }
                    this.m_historyEntries.addAll(caseSearch);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.m_ObjectListView.setObjectList(this.m_historyEntries, null);
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("dmsdialogs/OwObjectHistoryView.jsp", w_p);
    }
}

