/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.dmsdialogs.views.OwDirectInputPageSelectorComponent;
import com.wewebu.ow.server.dmsdialogs.views.OwNumberBlockPageSelectorComponent;
import com.wewebu.ow.server.dmsdialogs.views.OwPageSelectorComponent;
import com.wewebu.ow.server.dmsdialogs.views.OwPageableView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwScriptTable;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class OwObjectListView
extends OwView
implements OwPageableView,
OwClientRefreshContext {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectListView.class);
    public static final String SELECT_DESELECT_NONCONSECUTIVE_OBJECTS_ACTION_ID = "object.list.select.deselect.nonconsecutive";
    protected static final OwHtmlAlignmentMap m_HtmlAlignments = new OwHtmlAlignmentMap();
    private static Set<Integer> m_maxoperators = new HashSet<Integer>();
    protected static final String MULTISELECT_COMOBO_MENU_NAME = "owmcm";
    protected static final String OBJECT_INDEX_KEY = "oi";
    private static final String PAGING_NODE_NAME = "paging";
    protected static final String PLUG_INDEX_KEY = "pi";
    protected static final String QUERY_KEY_PAGE = "page";
    protected static final String SORT_PROPERTY_KEY = "prop";
    public static final int VIEW_MASK_INLINE_EDITING = 128;
    public static final int VIEW_MASK_INSTANCE_PLUGINS = 64;
    public static final int VIEW_MASK_MULTI_SELECTION = 4;
    public static final int VIEW_MASK_NO_PAGE_BUTTONS = 32;
    public static final int VIEW_MASK_SINGLE_SELECTION = 16;
    public static final int VIEW_MASK_USE_DOCUMENT_PLUGINS = 1;
    public static final int VIEW_MASK_USE_SELECT_BUTTON = 2;
    private static final String VIEW_MASKS_NODE_NAME = "viewmasks";
    private List contextMenuPlugins;
    private List m_DocumentFunctionPluginList;
    private OwObjectListViewEventListner m_EventListner;
    private OwFilter m_filter;
    @Deprecated
    protected boolean m_isStickyFooterInUse;
    private int m_iViewMask;
    private int m_listViewID = 0;
    protected OwPageSelectorComponent m_pageSelectorComponent;
    protected Node m_pagingNode;
    private Map m_persistedSelectionState = new HashMap();
    private boolean m_renderEmptyPluginColumn;
    private OwObject parentObject;
    private List pluginEntriesList;

    public OwObjectListView() {
    }

    public OwObjectListView(int iViewMask_p) {
        this.m_iViewMask = iViewMask_p;
    }

    protected void addAjaxPersistenceService(Writer w_p, String eventName_p) throws Exception {
        w_p.write("\n\n<script type=\"text/javascript\">addSelectionPersistanceEndpoint('");
        w_p.write(Integer.toString(this.getListViewID()));
        w_p.write("','");
        w_p.write(OwHTMLHelper.encodeJavascriptString(this.getAjaxEventURL(eventName_p, null)));
        w_p.write("'); </script>\n\n");
    }

    public void addViewMask(int iViewMask_p) {
        this.m_iViewMask |= iViewMask_p;
    }

    protected void clearViewMask(int iViewMask_p) {
        this.m_iViewMask &= ~iViewMask_p;
    }

    public void copy(OwObjectListView oldview_p) throws Exception {
        if (oldview_p.getObjectList() != null) {
            this.setObjectList(oldview_p.getObjectList(), oldview_p.getParentObject());
        } else {
            this.setObjectIterable(oldview_p.getObjectIterable(), oldview_p.getParentObject());
        }
        this.setCurrentPage(oldview_p.getCurrentPage());
        this.setSort(oldview_p.getSort());
        this.setColumnInfo(oldview_p.getColumnInfo());
        this.setFilter(oldview_p.getFilter());
        this.setEventListner(oldview_p.getEventListner());
        this.setRefreshContext(oldview_p.getRefreshContext());
        this.setFieldManager(oldview_p.getFieldManager());
        if (oldview_p.getExternalFormEventTarget() != oldview_p) {
            this.setExternalFormTarget(oldview_p.getExternalFormEventTarget());
        }
    }

    @Override
    public OwPageSelectorComponent createPageSelector() throws Exception {
        OwPageSelectorComponent component = null;
        String pageSelectorClassName = OwXMLDOMUtil.getSafeStringAttributeValue(this.m_pagingNode, "classname", null);
        if (pageSelectorClassName == null) {
            component = new OwDirectInputPageSelectorComponent(this);
        } else {
            try {
                Class<?> pageSelectorClass = Class.forName(pageSelectorClassName);
                Constructor<?> pageSelectorConstructor = pageSelectorClass.getConstructor(OwPageableView.class);
                component = (OwPageSelectorComponent)pageSelectorConstructor.newInstance(this);
                component.setConfigNode(this.m_pagingNode);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        component.init();
        return component;
    }

    public abstract Collection<? extends OwFieldColumnInfo> getColumnInfo();

    protected List getContextMenuFunction() {
        if (this.contextMenuPlugins == null) {
            this.contextMenuPlugins = new ArrayList();
            for (int i = 0; i < this.getDocumentFunctionPluginList().size(); ++i) {
                OwDocumentFunction plugin = (OwDocumentFunction)this.getDocumentFunctionPluginList().get(i);
                if (plugin.getNeedParent() && this.getParentObject() == null || !plugin.getContextMenu()) continue;
                this.contextMenuPlugins.add(new OwPluginEntry(plugin, i));
            }
        }
        return this.contextMenuPlugins;
    }

    @Override
    public int getCount() {
        if (this.getObjectList() == null && this.getObjectIterable() == null) {
            return 0;
        }
        if (this.getObjectList() != null) {
            return this.getObjectList().size();
        }
        long totalNum = this.getObjectIterable().getTotalNumItems();
        if (totalNum == -1L) {
            return -1;
        }
        return (int)totalNum;
    }

    protected OwDocumentFunction getDocumentFunction(int globalPluginIndex_p) {
        return (OwDocumentFunction)this.getDocumentFunctionPluginList().get(globalPluginIndex_p);
    }

    public List getDocumentFunctionPluginList() {
        return this.m_DocumentFunctionPluginList;
    }

    protected OwObjectListViewEventListner getEventListner() {
        return this.m_EventListner;
    }

    public abstract OwFieldManager getFieldManager();

    public OwFilter getFilter() {
        return this.m_filter;
    }

    public OwSearchNode getFilterSearch() throws Exception {
        if (null != this.m_filter) {
            return this.m_filter.getFilterSearch();
        }
        return null;
    }

    public int getListViewID() {
        if (this.m_listViewID == 0) {
            OwView parent = this.getParent();
            if (parent != null) {
                if (parent instanceof OwObjectListView) {
                    OwObjectListView parentList = (OwObjectListView)parent;
                    this.m_listViewID = parentList.getListViewID();
                } else {
                    this.m_listViewID = this.hashCode();
                }
            } else {
                this.m_listViewID = this.hashCode();
            }
        }
        return this.m_listViewID;
    }

    protected OwObject getObjectByIndex(int index) {
        if (this.getObjectList() != null) {
            return (OwObject)this.getObjectList().get(index);
        }
        return this.getObjectIterable().skipTo(index).iterator().next();
    }

    public abstract OwIterable<OwObject> getObjectIterable();

    public abstract OwObjectCollection getObjectList();

    @Override
    public String getPageAbsolutEventURL(String aditionalParameters_p) {
        return this.getEventURL("PageAbsolut", aditionalParameters_p);
    }

    @Override
    public String getPageNextEventURL() {
        return this.getEventURL("PageNext", null);
    }

    @Override
    public String getPagePrevEventURL() {
        return this.getEventURL("PagePrev", null);
    }

    public OwObject getParentObject() {
        return this.parentObject;
    }

    public List<OwPluginEntry> getPluginEntries() {
        if (null == this.pluginEntriesList) {
            this.pluginEntriesList = new ArrayList();
            if (this.hasViewMask(64)) {
                for (int p = 0; p < this.m_DocumentFunctionPluginList.size(); ++p) {
                    OwDocumentFunction plugin = (OwDocumentFunction)this.m_DocumentFunctionPluginList.get(p);
                    if (plugin.getNeedParent() && this.getParentObject() == null || !plugin.getObjectInstance()) continue;
                    this.pluginEntriesList.add(new OwPluginEntry(plugin, p));
                }
            }
        }
        return this.pluginEntriesList;
    }

    protected abstract OwClientRefreshContext getRefreshContext();

    public abstract Collection<String> getRetrievalPropertyNames() throws Exception;

    public abstract OwSort getSort();

    @Override
    public final boolean hasPaging() {
        return !this.hasViewMask(32) && this.isPagingEnabled();
    }

    protected boolean hasViewMask(int iViewMask_p) {
        return (this.m_iViewMask & iViewMask_p) > 0;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_renderEmptyPluginColumn = false;
        if (this.m_DocumentFunctionPluginList == null) {
            this.m_DocumentFunctionPluginList = this.hasViewMask(1) ? ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunctionPlugins() : new ArrayList();
        }
    }

    public boolean isEmptyPluginColumnRendered() {
        return this.m_renderEmptyPluginColumn;
    }

    protected boolean isObjectSelectionPersisted(int objectIndex_p) {
        Boolean selectedObj = (Boolean)this.m_persistedSelectionState.get(objectIndex_p);
        return selectedObj != null && selectedObj != false;
    }

    protected boolean isObjectTypeSupportedByPlugin(OwDocumentFunction plugIn_p, Set objectTypes_p) {
        boolean fSupported = false;
        Iterator it = objectTypes_p.iterator();
        while (it.hasNext()) {
            if (!plugIn_p.isObjectTypeSupported((Integer)it.next())) continue;
            fSupported = true;
            break;
        }
        return fSupported;
    }

    protected boolean isPagingEnabled() {
        return false;
    }

    @Override
    public boolean isShowMaximized() {
        if (this.getParent() == null) {
            return super.isShowMaximized();
        }
        return this.getParent().isShowMaximized();
    }

    @Deprecated
    public boolean isStickyFooterInUse() {
        boolean stickyFooterByContext = !(this.m_pageSelectorComponent instanceof OwNumberBlockPageSelectorComponent);
        return this.m_isStickyFooterInUse && stickyFooterByContext;
    }

    protected void pageAbsolut(int iPage_p) {
    }

    @Deprecated
    protected void persistAjaxTriggeredSelection(HttpServletRequest request_p, HttpServletResponse response_p, OwObjectCollection objects_p) throws Exception {
        String sObjid = request_p.getParameter("objid");
        String sStatus = request_p.getParameter("status");
        if (sObjid == null || sStatus == null) {
            return;
        }
        boolean status = Boolean.valueOf(sStatus);
        if (!status && !Boolean.FALSE.toString().equals(sStatus)) {
            return;
        }
        String[] objectIds = sObjid.split(",");
        int objectsCount = objects_p != null ? objects_p.size() : 0;
        for (int i = 0; i < objectIds.length; ++i) {
            int iObjid = -1;
            try {
                iObjid = Integer.parseInt(objectIds[i]);
            }
            catch (Exception e) {
                continue;
            }
            if (iObjid >= objectsCount || objects_p.get(iObjid) == null) continue;
            this.persistObjectSelectionState(iObjid, status);
        }
    }

    protected void persistAjaxTriggeredSelection(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        String sObjid = request_p.getParameter("objid");
        String sStatus = request_p.getParameter("status");
        if (sObjid == null || sStatus == null) {
            return;
        }
        boolean status = Boolean.valueOf(sStatus);
        if (!status && !Boolean.FALSE.toString().equals(sStatus)) {
            return;
        }
        String[] objectIds = sObjid.split(",");
        for (int i = 0; i < objectIds.length; ++i) {
            int iObjid = -1;
            try {
                iObjid = Integer.parseInt(objectIds[i]);
            }
            catch (Exception e) {
                continue;
            }
            this.persistObjectSelectionState(iObjid, status);
        }
    }

    protected void persistObjectSelectionState(int iObjid_p, boolean status_p) {
        this.m_persistedSelectionState.put(iObjid_p, status_p ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void renderContextMenu(Writer w_p, Set occuredObjectTypes_p) throws Exception {
        List pluginEntries = this.getContextMenuFunction();
        if (pluginEntries.size() == 0) {
            return;
        }
        StringBuilderWriter sb = new StringBuilderWriter();
        OwScriptTable.writeSelectableListContextMenuStart(String.valueOf(this.getListViewID()), (Writer)sb, "OwContextMenu");
        boolean isMenuEmpty = true;
        for (int p = 0; p < pluginEntries.size(); ++p) {
            OwPluginEntry entry = (OwPluginEntry)pluginEntries.get(p);
            OwDocumentFunction plugIn = entry.getPlugin();
            if (plugIn.getNeedParent() && this.getParentObject() == null || !this.isObjectTypeSupportedByPlugin(plugIn, occuredObjectTypes_p)) continue;
            isMenuEmpty = false;
            String strEventURL = this.getEventURL("ContextMenuEvent", "pi=" + String.valueOf(entry.getIndex()));
            OwScriptTable.writeSelectableListContextMenuTREntry(String.valueOf(this.getListViewID()), (Writer)sb, "OwContextMenu", p, strEventURL, this.getFormName(), plugIn.getDefaultIconHTML(), plugIn.getDefaultLabel());
            sb.write("\n\n<script type=\"text/javascript\">addContextMenuShortcut('");
            sb.write(plugIn.getPluginID());
            sb.write("',");
            sb.write(Integer.toString(this.getListViewID()));
            sb.write(",'");
            sb.write(strEventURL);
            sb.write("','");
            sb.write(this.getFormName());
            sb.write("');</script>\n\n");
            ((OwMainAppContext)this.getContext()).registerPluginKeyEvent(plugIn.getPluginID(), "javascript:fireContextMenuShortcut('" + plugIn.getPluginID() + "')", null, plugIn.getDefaultLabel());
        }
        OwScriptTable.writeSelectableListContextMenuEnd(String.valueOf(this.getListViewID()), (Writer)sb);
        sb.flush();
        if (!isMenuEmpty) {
            w_p.append(sb.getBuilder());
        }
    }

    protected void resetPersistedSelectionState() {
        this.m_persistedSelectionState = new HashMap();
    }

    public abstract void setColumnInfo(Collection<? extends OwFieldColumnInfo> var1);

    public void setConfigNode(Node node_p) throws Exception {
        Node viewmasksNode = OwXMLDOMUtil.getChildNode(node_p, VIEW_MASKS_NODE_NAME);
        List masklist = OwXMLDOMUtil.getSafeStringList(viewmasksNode);
        Iterator it = masklist.iterator();
        this.m_iViewMask = 0;
        while (it.hasNext()) {
            String sMask = (String)it.next();
            this.m_iViewMask |= this.getClass().getField(sMask).getInt(null);
        }
        this.m_pagingNode = OwXMLDOMUtil.getChildNode(node_p, PAGING_NODE_NAME);
    }

    public final void setCurrentPage(int iPage_p) {
        this.pageAbsolut(iPage_p);
    }

    public void setDocumentFunctionPluginList(List pluginList_p) {
        this.m_DocumentFunctionPluginList = pluginList_p;
        this.pluginEntriesList = null;
        this.contextMenuPlugins = null;
    }

    public void setEventListner(OwObjectListViewEventListner eventlister_p) {
        this.m_EventListner = eventlister_p;
    }

    public abstract void setFieldManager(OwFieldManager var1);

    public void setFilter(OwFilter filter_p) {
        this.m_filter = filter_p;
    }

    public abstract void setObjectIterable(OwIterable<OwObject> var1, OwObject var2) throws Exception;

    public abstract void setObjectList(OwObjectCollection var1, OwObject var2) throws Exception;

    protected void setParentObject(OwObject newParent_p) {
        this.parentObject = newParent_p;
        if (this.pluginEntriesList != null) {
            this.pluginEntriesList.clear();
            this.pluginEntriesList = null;
        }
        if (this.contextMenuPlugins != null) {
            this.contextMenuPlugins.clear();
            this.contextMenuPlugins = null;
        }
    }

    public abstract void setRefreshContext(OwClientRefreshContext var1);

    public void setRenderEmptyPluginColumn(boolean renderEmptyColumn_p) {
        this.m_renderEmptyPluginColumn = renderEmptyColumn_p;
    }

    public abstract void setSort(OwSort var1);

    @Deprecated
    public void setStickyFooterInUse(boolean stickyFooterInUse_p) {
        this.m_isStickyFooterInUse = stickyFooterInUse_p;
    }

    public void setViewMask(int iViewMask_p) {
        this.m_iViewMask = iViewMask_p;
    }

    public static OwFilter createFilter(Collection filterprops_p, OwFieldDefinitionProvider fieldDefinitionProvider_p, String sResourceName_p, String sID_p, OwDocument doc_p) throws Exception {
        OwFilter retFilter = new OwFilter(sID_p);
        if (null != filterprops_p) {
            for (OwFieldDefinition info : filterprops_p) {
                Integer firstOperator = (Integer)OwObjectListView.getFilterOperators(info).iterator().next();
                retFilter.put(info.getClassName(), new OwFilterEntry(info, fieldDefinitionProvider_p, sResourceName_p, firstOperator));
            }
        }
        if (null != doc_p) {
            retFilter.load(doc_p.getPersistentAttributeBagWriteable());
        }
        return retFilter;
    }

    public static OwFilter createFilter(Collection filterprops_p, String sID_p, OwDocument doc_p) throws Exception {
        OwFilter retFilter = new OwFilter(sID_p);
        if (null != filterprops_p) {
            for (OwFieldDefinition info : filterprops_p) {
                Integer firstOperator = (Integer)OwObjectListView.getFilterOperators(info).iterator().next();
                retFilter.put(info.getClassName(), new OwFilterEntry(info, firstOperator));
            }
        }
        if (null != doc_p) {
            retFilter.load(doc_p.getPersistentAttributeBagWriteable());
        }
        return retFilter;
    }

    public static OwFilter createFilter(String sID_p) throws Exception {
        return new OwFilter(sID_p);
    }

    public static Collection getFilterOperators(OwFieldDefinition fielddef_p) throws Exception {
        Collection ops = fielddef_p.getOperators();
        if (null == ops) {
            String msg = "OwObjectListView.getFilterOperators: Fielddef = " + fielddef_p.getClassName() + " contains no operators, but is used as a filter.";
            LOG.error((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        LinkedList ret = new LinkedList();
        for (Object op : ops) {
            if (!m_maxoperators.contains(op)) continue;
            ret.add(op);
        }
        return ret;
    }

    static {
        m_maxoperators.add(6);
        m_maxoperators.add(4);
        m_maxoperators.add(14);
        m_maxoperators.add(12);
        m_maxoperators.add(530);
    }

    public static class OwPluginEntry {
        protected int m_iIndex;
        protected OwDocumentFunction m_Plugin;

        public OwPluginEntry(OwDocumentFunction plugin_p, int iIndex_p) {
            this.m_Plugin = plugin_p;
            this.m_iIndex = iIndex_p;
        }

        public boolean equals(Object otherObject_p) {
            boolean result = false;
            if (otherObject_p instanceof OwPluginEntry) {
                OwPluginEntry otherEntry = (OwPluginEntry)otherObject_p;
                if (this.m_Plugin != null && this.m_Plugin.getPluginID() != null && otherEntry.m_Plugin != null && otherEntry.m_Plugin.getPluginID() != null && this.m_Plugin.getPluginID().compareTo(otherEntry.m_Plugin.getPluginID()) == 0 && this.m_iIndex == otherEntry.m_iIndex) {
                    result = true;
                }
            }
            return result;
        }

        public int getIndex() {
            return this.m_iIndex;
        }

        public OwDocumentFunction getPlugin() {
            return this.m_Plugin;
        }

        public int hashCode() {
            return this.m_iIndex;
        }
    }

    public static interface OwObjectListViewEventListner
    extends EventListener {
        public void onObjectListViewFilterChange(OwSearchNode var1, OwObject var2) throws Exception;

        public String onObjectListViewGetRowClassName(int var1, OwObject var2);

        public boolean onObjectListViewItemClick(OwObject var1) throws Exception;

        public void onObjectListViewSelect(OwObject var1, OwObject var2) throws Exception;

        public void onObjectListViewSort(OwSort var1, String var2) throws Exception;
    }

    public static class OwIcon {
        private String m_iconAsString;
        private int m_numberOfIcons;

        public OwIcon(String owIconAsString_p) {
            this.m_iconAsString = owIconAsString_p;
            this.m_numberOfIcons = this.computeNumberOfIcons();
        }

        private int computeNumberOfIcons() {
            String iconText;
            String[] tokens;
            int result = 0;
            if (this.m_iconAsString != null && (tokens = (iconText = this.m_iconAsString.toLowerCase()).split("<img")).length > 0) {
                result = tokens.length - 1;
            }
            return result;
        }

        public int getNumberOfIcons() {
            return this.m_numberOfIcons;
        }

        public String toString() {
            return this.m_iconAsString != null ? this.m_iconAsString : "";
        }
    }

    protected static class OwHtmlAlignmentMap {
        public String[] m_list = new String[7];

        public OwHtmlAlignmentMap() {
            this.m_list[0] = "";
            this.m_list[1] = "";
            this.m_list[2] = "align=center";
            this.m_list[3] = "align=right";
            this.m_list[4] = "nowrap";
            this.m_list[5] = "nowrap align=center";
            this.m_list[6] = "nowrap align=right";
        }
    }

    public static class OwFilterEntry {
        protected static final String PERSIST_ACTIVE_ATTR_NAME = "ac";
        protected static final String PERSIST_NODE_NAME = "FE";
        private boolean m_fActive;
        private OwFieldDefinitionProvider m_fielddefprovider;
        private OwSearchNode m_searchnode;
        private String m_sRescourceName;

        public OwFilterEntry(OwFieldDefinition info_p, int iOperator_p) throws Exception {
            this.m_searchnode = new OwSearchNode(info_p, iOperator_p, null, 16);
        }

        public OwFilterEntry(OwFieldDefinition info_p, OwFieldDefinitionProvider fieldDefinitionProvider_p, String sResourceName_p, int iOperator_p) throws Exception {
            this.m_sRescourceName = sResourceName_p;
            this.m_fielddefprovider = fieldDefinitionProvider_p;
            this.m_searchnode = new OwSearchNode(info_p, iOperator_p, null, 16);
            this.updateWildcarddefs(iOperator_p);
        }

        public Element getPersistentNode(Document doc_p) throws Exception {
            Element retNode = doc_p.createElement(PERSIST_NODE_NAME);
            retNode.setAttribute(PERSIST_ACTIVE_ATTR_NAME, String.valueOf(this.isActive()));
            retNode.appendChild(this.getSearchNode().getPersistentNode(doc_p));
            return retNode;
        }

        public OwSearchNode getSearchNode() {
            return this.m_searchnode;
        }

        public boolean isActive() {
            return this.m_fActive;
        }

        public void setActive(boolean fActive_p) {
            this.m_fActive = fActive_p;
        }

        public void setOperator(int iOperator_p) throws Exception {
            this.getSearchNode().getCriteria().setOperator(iOperator_p);
            this.updateWildcarddefs(iOperator_p);
        }

        public void setPersistentNode(Node entryNode_p) throws Exception {
            this.m_fActive = OwXMLDOMUtil.getSafeBooleanAttributeValue(entryNode_p, PERSIST_ACTIVE_ATTR_NAME, false);
            this.m_searchnode.setPersistentNode(entryNode_p.getFirstChild());
        }

        public void toggle() {
            this.m_fActive = !this.m_fActive;
        }

        private void updateWildcarddefs(int iOperator_p) throws Exception {
            if (null != this.m_fielddefprovider) {
                Collection wildcarddefinitions = this.m_fielddefprovider.getWildCardDefinitions(this.getSearchNode().getCriteria().getClassName(), this.m_sRescourceName, iOperator_p);
                this.getSearchNode().getCriteria().setWildCardDefinitions(wildcarddefinitions);
            }
        }
    }

    public static class OwFilter
    extends HashMap {
        protected static final String PERSIST_ENTRY_NAME_ATTR_NAME = "en";
        protected static final String PERSIST_FILTER_NODE_NAME = "FN";
        private static final long serialVersionUID = 1L;
        protected String m_sID;

        public OwFilter(String sID_p) {
            this.m_sID = sID_p;
        }

        public OwFilterEntry getFilterEntry(String strProperty_p) throws OwObjectNotFoundException {
            OwFilterEntry filter = (OwFilterEntry)this.get(strProperty_p);
            if (filter == null) {
                throw new OwObjectNotFoundException("OwObjectListView$OwFilter.getFilterEntry: Property does not allow filter = " + strProperty_p);
            }
            return filter;
        }

        public OwSearchNode getFilterSearch() throws Exception {
            OwSearchNode filtersearchrootnode = new OwSearchNode(1, 1);
            boolean fSet = false;
            for (OwFilterEntry filter : this.values()) {
                if (!filter.isActive()) continue;
                filtersearchrootnode.add(filter.getSearchNode());
                fSet = true;
            }
            if (fSet) {
                return filtersearchrootnode;
            }
            return null;
        }

        private String getSerializeAttributeName() {
            return "OwFilter_" + this.m_sID;
        }

        public void load(OwAttributeBagWriteable persistentAttributeBagWriteable_p) throws Exception {
            String sXML = null;
            try {
                sXML = (String)persistentAttributeBagWriteable_p.getAttribute(this.getSerializeAttributeName());
            }
            catch (OwObjectNotFoundException e) {
                return;
            }
            Document doc = OwXMLDOMUtil.getDocumentFromString(sXML);
            for (Node entryNode = doc.getFirstChild().getFirstChild(); entryNode != null; entryNode = entryNode.getNextSibling()) {
                String sEntryName = entryNode.getAttributes().getNamedItem(PERSIST_ENTRY_NAME_ATTR_NAME).getNodeValue();
                OwFilterEntry entry = (OwFilterEntry)this.get(sEntryName);
                if (null == entry) continue;
                entry.setPersistentNode(entryNode);
            }
        }

        public void save(OwAttributeBagWriteable persistentAttributeBagWriteable_p) throws Exception {
            Document doc = OwXMLDOMUtil.getNewDocument();
            Element saveNode = doc.createElement(PERSIST_FILTER_NODE_NAME);
            for (Map.Entry entry : this.entrySet()) {
                String sKey = (String)entry.getKey();
                OwFilterEntry value = (OwFilterEntry)entry.getValue();
                if (!value.isActive()) continue;
                Element entryNode = value.getPersistentNode(doc);
                entryNode.setAttribute(PERSIST_ENTRY_NAME_ATTR_NAME, sKey);
                saveNode.appendChild(entryNode);
            }
            persistentAttributeBagWriteable_p.setAttribute(this.getSerializeAttributeName(), OwXMLDOMUtil.toString(saveNode));
            persistentAttributeBagWriteable_p.save();
        }

        public void setActive(String strProperty_p, boolean fActive_p) throws OwObjectNotFoundException {
            this.getFilterEntry(strProperty_p).setActive(fActive_p);
        }
    }
}

