/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewRow;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewThumbnails;
import com.wewebu.ow.server.dmsdialogs.views.OwPageableListView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Node;

public class OwObjectListViewCombined
extends OwPageableListView {
    private OwXMLUtil configNode;
    protected static final String QUERY_KEY_PAGE_COMBINED = "combinedpage";

    public OwObjectListViewCombined(int iViewMask_p) {
        super(iViewMask_p);
    }

    public OwObjectListViewCombined() {
    }

    @Override
    public void setConfigNode(Node node_p) throws Exception {
        super.setConfigNode(node_p);
        this.configNode = new OwStandardXMLUtil(node_p);
    }

    protected OwXMLUtil getConfigNode() {
        return this.configNode;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        LinkedList<OwObjectListView> views = new LinkedList<OwObjectListView>();
        List subViewConfig = this.getConfigNode().getSafeUtilList("subview");
        if (subViewConfig.isEmpty()) {
            OwPageableListView listView = new OwObjectListViewRow();
            listView.setConfigNode(this.getConfigNode().getNode());
            views.add(listView);
            listView = new OwObjectListViewThumbnails();
            listView.setConfigNode(this.getConfigNode().getNode());
            views.add(listView);
        } else {
            for (OwXMLUtil config : subViewConfig) {
                String name = config.getSafeStringAttributeValue("classname", null);
                if (name == null) continue;
                Class<?> lstClass = Class.forName(name);
                OwObjectListView subView = (OwObjectListView)lstClass.newInstance();
                subView.setConfigNode(config.getNode());
                views.add(subView);
            }
        }
        for (OwObjectListView subview : views) {
            this.addView(subview, null);
            subview.addViewMask(32);
        }
        this.m_pageSelectorComponent = this.createPageSelector();
    }

    @Override
    public void setDocumentFunctionPluginList(List pluginList_p) {
        for (int i = 0; i < this.getViewList().size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.getViewList().get(i);
            subview.setDocumentFunctionPluginList(pluginList_p);
        }
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        boolean useHtml5DragAndDrop = ((OwMainAppContext)this.getContext()).isUseHtml5DragAndDrop();
        if (useHtml5DragAndDrop) {
            StringBuilder sb = new StringBuilder();
            sb.append("<script type=\"text/javascript\">\n");
            sb.append("var dropArea = document.getElementById('OwSublayout_ContentContainer');\n");
            sb.append("if(typeof addHtml5DropArea == 'function') {\n");
            sb.append("addHtml5DropArea(dropArea, false);\n");
            sb.append("}\n");
            sb.append("</script>\n");
            w_p.write(sb.toString());
        }
        if (this.getIsList()) {
            w_p.write("<div id=\"wrap\"><!-- wrap start combined -->");
            super.onRender(w_p);
            w_p.flush();
            w_p.write("</div><!-- div wrap end combined -->");
            if (this.hasPaging()) {
                w_p.write("<div id=\"footer\"><!-- footer start combined -->");
                this.renderCombinedPageButtons(w_p);
                w_p.write("</div><!-- div footer end -->");
            }
        } else {
            w_p.write("<span id=\"emptyList\"  class=\"OwEmptyTextMessage\">" + this.getContext().localize("app.OwObjectListView.emptylist", "No items to display") + "</span>\n");
        }
    }

    public boolean getIsList() {
        return this.getIsListValid() && this.getCount() != 0;
    }

    public boolean getIsListValid() {
        return this.getCount() != 0 && this.getColumnInfo() != null;
    }

    @Deprecated
    public boolean getIsListEmpty() {
        return this.getCount() == 0;
    }

    @Deprecated
    public boolean getIsPaging() {
        return this.hasPaging();
    }

    protected void renderCombinedPageButtons(Writer w_p) throws Exception {
        this.m_pageSelectorComponent.render(w_p);
    }

    @Override
    public void setFieldManager(OwFieldManager fieldmanager_p) {
        super.setFieldManager(fieldmanager_p);
        for (OwObjectListView subview : this.getViewList()) {
            subview.setFieldManager(fieldmanager_p);
        }
    }

    @Override
    public Collection<String> getRetrievalPropertyNames() throws Exception {
        if (this.getViewList().size() > 0) {
            return ((OwObjectListView)this.getViewList().get(0)).getRetrievalPropertyNames();
        }
        return null;
    }

    @Override
    protected void pageAbsolut(int iPage_p) {
        super.pageAbsolut(iPage_p);
        for (int i = 0; i < this.getViewList().size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.getViewList().get(i);
            subview.setCurrentPage(iPage_p);
        }
    }

    @Override
    public void setColumnInfo(Collection<? extends OwFieldColumnInfo> columnInfo_p) {
        super.setColumnInfo(columnInfo_p);
        for (int i = 0; i < this.getViewList().size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.getViewList().get(i);
            subview.setColumnInfo(columnInfo_p);
        }
    }

    @Override
    public void setObjectList(OwObjectCollection objectList_p, OwObject parentObject_p) throws Exception {
        super.setObjectList(objectList_p, parentObject_p);
        for (int i = 0; i < this.getViewList().size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.getViewList().get(i);
            subview.setObjectList(objectList_p, parentObject_p);
        }
    }

    @Override
    public void setObjectIterable(OwIterable<OwObject> iterable, OwObject parentObject_p) throws Exception {
        super.setObjectIterable(iterable, parentObject_p);
        for (int i = 0; i < this.getViewList().size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.getViewList().get(i);
            subview.setObjectIterable(iterable, parentObject_p);
        }
    }

    @Override
    public void setRefreshContext(OwClientRefreshContext eventlistner_p) {
        super.setRefreshContext(eventlistner_p);
        for (int i = 0; i < this.getViewList().size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.getViewList().get(i);
            subview.setRefreshContext(eventlistner_p);
        }
    }

    @Override
    public void setSort(OwSort sort_p) {
        super.setSort(sort_p);
        for (int i = 0; i < this.getViewList().size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.getViewList().get(i);
            subview.setSort(sort_p);
        }
    }

    @Override
    public String getTitle() {
        StringBuilder sTitle = new StringBuilder();
        sTitle.append(this.getContext().localize("dmsdialogs.views.OwObjectListViewCombined.title", "Combined:"));
        sTitle.append(" ");
        Iterator it = this.getViewList().iterator();
        while (it.hasNext()) {
            OwObjectListView subview = (OwObjectListView)it.next();
            sTitle.append(subview.getTitle());
            if (!it.hasNext()) continue;
            sTitle.append(", ");
        }
        return sTitle.toString();
    }

    @Override
    public String getIcon() throws Exception {
        return "/images/OwObjectListView/OwObjectListViewCombined.png";
    }

    @Override
    public void setEventListner(OwObjectListView.OwObjectListViewEventListner eventlister_p) {
        super.setEventListner(eventlister_p);
        for (OwObjectListView listView : this.getViewList()) {
            listView.setEventListner(eventlister_p);
        }
    }

    @Override
    public void detach() {
        super.detach();
        this.m_pageSelectorComponent = null;
        this.configNode = null;
    }
}

