/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwObjectCollectionIterableAdapter;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwPageableListView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.perf4j.log4j.Log4JStopWatch;

public abstract class OwObjectListViewPluginCache
extends OwPageableListView {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectListViewPluginCache.class);
    private OwPluginStatusCachingUtility pluginCache;

    public OwObjectListViewPluginCache() {
    }

    public OwObjectListViewPluginCache(int viewMask) {
        super(viewMask);
    }

    protected OwPluginStatusCachingUtility getPluginCache() {
        return this.pluginCache;
    }

    protected void setPluginCache(OwPluginStatusCachingUtility newCache) {
        this.pluginCache = newCache;
    }

    @Deprecated
    protected OwPluginStatusCachingUtility createPluginStatusCacheUtility(int startIndex, int endIndex, Collection<OwObjectListView.OwPluginEntry> pluginEntries) throws Exception {
        return this.createPluginStatusCacheUtility(startIndex, endIndex, this.getObjectList(), this.getParentObject(), pluginEntries, this.isEmptyPluginColumnRendered());
    }

    @Deprecated
    protected OwPluginStatusCachingUtility createPluginStatusCacheUtility(int startIndex, int endIndex, List objectList, OwObject parentObject, Collection<OwObjectListView.OwPluginEntry> pluginEntries, boolean displayEmptyPluginColumn) throws Exception {
        OwObjectCollectionIterableAdapter page = new OwObjectCollectionIterableAdapter((OwObjectCollection)objectList);
        return new OwPluginStatusCachingUtility(page.skipTo(startIndex).getPage(endIndex - startIndex), parentObject, pluginEntries, displayEmptyPluginColumn);
    }

    protected OwPluginStatusCachingUtility createPluginStatusCacheUtility(Collection<OwObjectListView.OwPluginEntry> pluginEntries) throws Exception {
        return this.createPluginStatusCacheUtility(this.getDisplayedPage(), this.getParentObject(), pluginEntries, this.isEmptyPluginColumnRendered());
    }

    protected OwPluginStatusCachingUtility createPluginStatusCacheUtility(OwIterable<OwObject> page, OwObject parentObject, Collection<OwObjectListView.OwPluginEntry> pluginEntries, boolean displayEmptyPluginColumn) throws Exception {
        return new OwPluginStatusCachingUtility(page, parentObject, pluginEntries, displayEmptyPluginColumn);
    }

    protected static class OwPluginStatus {
        private boolean isCached;
        private boolean isEnabled;
        public static final OwPluginStatus NOT_CACHED = new OwPluginStatus(false, false);

        public OwPluginStatus(boolean isCached_p, boolean isEnabled_p) {
            this.isCached = isCached_p;
            this.isEnabled = isEnabled_p;
        }

        public boolean isCached() {
            return this.isCached;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }

    protected static class OwPluginStatusCachingUtility {
        private Map<String, Boolean> m_object2PluginStatusMap;
        private boolean m_displayEmptyPluginColumn;
        private List<OwObjectListView.OwPluginEntry> m_disabledPlugins;
        private Map<Integer, Integer> m_maxNumberOfIconsPerEntry;

        public OwPluginStatusCachingUtility(int startIndex_p, int endIndex_p, OwObjectCollection objectList_p, OwObject parentObject_p, Collection<OwObjectListView.OwPluginEntry> pluginEntries_p) throws Exception {
            this.m_displayEmptyPluginColumn = false;
            this.m_disabledPlugins = new LinkedList<OwObjectListView.OwPluginEntry>();
            this.m_maxNumberOfIconsPerEntry = new HashMap<Integer, Integer>();
            this.m_object2PluginStatusMap = new HashMap<String, Boolean>();
            OwObjectCollectionIterableAdapter page = new OwObjectCollectionIterableAdapter(objectList_p);
            try {
                this.preparePluginInfo(page.skipTo(startIndex_p).getPage(endIndex_p - startIndex_p), parentObject_p, pluginEntries_p);
            }
            catch (Exception e) {
                LOG.error((Object)"OwPluginStatusCachingUtility.constructor: Cannot prepare plugin info. Reason:", (Throwable)e);
                throw e;
            }
        }

        public OwPluginStatusCachingUtility(OwIterable<OwObject> page, OwObject parent, Collection<OwObjectListView.OwPluginEntry> pluginEntries, boolean displayEmptyPluginColumn_p) throws Exception {
            this.m_displayEmptyPluginColumn = displayEmptyPluginColumn_p;
            this.m_disabledPlugins = new LinkedList<OwObjectListView.OwPluginEntry>();
            this.m_maxNumberOfIconsPerEntry = new HashMap<Integer, Integer>();
            this.m_object2PluginStatusMap = new HashMap<String, Boolean>();
            try {
                this.preparePluginInfo(page, parent, pluginEntries);
            }
            catch (Exception e) {
                LOG.error((Object)"OwPluginStatusCachingUtility.constructor: Cannot prepare plugin info. Reason:", (Throwable)e);
                throw e;
            }
        }

        private void addPluginStatusForObject(OwObject object_p, OwObjectListView.OwPluginEntry pluginEntry_p, boolean isEnabled_p) {
            try {
                String key = this.createKey(object_p, pluginEntry_p);
                this.m_object2PluginStatusMap.put(key, isEnabled_p ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot add plugin status for object: " + object_p + " and for plugin entry: " + pluginEntry_p), (Throwable)e);
            }
        }

        private String createKey(OwObject object_p, OwObjectListView.OwPluginEntry pluginEntry_p) throws Exception {
            String objectId = object_p.getDMSID();
            String key = objectId + "_" + pluginEntry_p.getIndex();
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void preparePluginInfo(OwIterable<OwObject> page, OwObject parent, Collection<OwObjectListView.OwPluginEntry> instancePluginsList) throws Exception {
            Log4JStopWatch preparePluginInfoStopWatch = new Log4JStopWatch("preparePluginInfo");
            try {
                Iterator<OwObjectListView.OwPluginEntry> pluginsIterator = new CopyOnWriteArraySet<OwObjectListView.OwPluginEntry>(instancePluginsList).iterator();
                this.m_disabledPlugins = new LinkedList<OwObjectListView.OwPluginEntry>();
                while (pluginsIterator.hasNext()) {
                    OwObjectListView.OwPluginEntry entry = pluginsIterator.next();
                    this.processPluginEntry(page, parent, entry);
                }
            }
            finally {
                preparePluginInfoStopWatch.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPluginEntry(OwIterable<OwObject> page, OwObject parent, OwObjectListView.OwPluginEntry entry) throws Exception {
            boolean isPluginEnabled = false;
            String pluginName = entry.getPlugin().getName();
            Log4JStopWatch pluginStopWatch = new Log4JStopWatch("plugin.isEnabled." + pluginName);
            try {
                for (OwObject obj : page) {
                    if (obj == null) continue;
                    if (entry.m_Plugin.isEnabled(obj, parent, 1)) {
                        String icon = entry.m_Plugin.getIconHTML(obj, parent);
                        OwObjectListView.OwIcon owIcon = new OwObjectListView.OwIcon(icon);
                        int numberOfIcons = owIcon.getNumberOfIcons();
                        this.addNumberOfIconsForEntry(entry, numberOfIcons);
                        if (numberOfIcons > 0) {
                            isPluginEnabled = true;
                            this.addPluginStatusForObject(obj, entry, true);
                            continue;
                        }
                        this.addPluginStatusForObject(obj, entry, false);
                        continue;
                    }
                    this.addPluginStatusForObject(obj, entry, false);
                }
            }
            finally {
                pluginStopWatch.stop();
            }
            if (!isPluginEnabled) {
                this.m_disabledPlugins.add(entry);
                this.addNumberOfIconsForEntry(entry, 0);
            }
        }

        private void addNumberOfIconsForEntry(OwObjectListView.OwPluginEntry entry_p, int numberOfIcons_p) {
            Integer key = entry_p.getIndex();
            if (this.m_maxNumberOfIconsPerEntry.containsKey(key)) {
                Integer existingNumberOfIcons = this.m_maxNumberOfIconsPerEntry.get(key);
                if (existingNumberOfIcons < numberOfIcons_p) {
                    this.m_maxNumberOfIconsPerEntry.put(key, numberOfIcons_p);
                }
            } else {
                this.m_maxNumberOfIconsPerEntry.put(key, numberOfIcons_p);
            }
        }

        public int getMaximumNumberOfIconsForEntry(OwObjectListView.OwPluginEntry entry_p) {
            int result = 0;
            if (entry_p != null) {
                Integer resultAsInt = this.m_maxNumberOfIconsPerEntry.get(entry_p.getIndex());
                result = resultAsInt != null ? resultAsInt : result;
            }
            return result;
        }

        public int getMaximumNumberOfIcons() {
            int result = 0;
            for (Integer value : this.m_maxNumberOfIconsPerEntry.values()) {
                result += value.intValue();
            }
            return result;
        }

        public boolean isPluginDisabledForAllObjects(OwObjectListView.OwPluginEntry entry_p) {
            boolean result = this.m_disabledPlugins.contains(entry_p);
            if (this.m_displayEmptyPluginColumn) {
                result = false;
            }
            return result;
        }

        public OwPluginStatus getCachedPluginState(OwObjectListView.OwPluginEntry pluginEntry_p, OwObject obj_p) {
            OwPluginStatus result;
            try {
                String key = this.createKey(obj_p, pluginEntry_p);
                Boolean status = this.m_object2PluginStatusMap.get(key);
                result = status == null ? OwPluginStatus.NOT_CACHED : new OwPluginStatus(true, status);
            }
            catch (Exception e) {
                result = OwPluginStatus.NOT_CACHED;
            }
            return result;
        }

        public int getNumberOfDisabledPlugins() {
            return this.m_disabledPlugins.size();
        }
    }
}

