/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.collections.OwEmptyIterable;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwObjectCollectionIterableAdapter;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class OwPageableListView
extends OwObjectListView {
    private static final Logger LOG = OwLogCore.getLogger(OwPageableListView.class);
    private OwFieldManager fieldManager;
    private OwClientRefreshContext refreshContext;
    private OwSort sort;
    private Collection<? extends OwFieldColumnInfo> columnInfo;
    private int currentPage;
    private OwObjectCollection objectList;
    private OwIterable<OwObject> objectIterable;
    private OwIterable<OwObject> page;

    protected OwPageableListView() {
    }

    public OwPageableListView(int viewMask) {
        super(viewMask);
    }

    @Override
    public void detach() {
        super.detach();
        if (this.getFieldManager() != null) {
            this.fieldManager.detach();
            this.fieldManager = null;
        }
        this.columnInfo = null;
        this.sort = null;
        this.objectList = null;
        this.refreshContext = null;
        this.objectIterable = null;
        this.page = null;
    }

    @Override
    public void setObjectList(OwObjectCollection objectList_p, OwObject parentObject_p) throws Exception {
        this.objectList = objectList_p;
        this.objectIterable = null;
        this.page = null;
        this.setParentObject(parentObject_p);
    }

    @Override
    public void setObjectIterable(OwIterable<OwObject> iterable, OwObject parentObject_p) throws Exception {
        this.objectIterable = iterable;
        this.objectList = null;
        this.page = null;
        this.setParentObject(parentObject_p);
    }

    @Override
    public OwObjectCollection getObjectList() {
        return this.objectList;
    }

    @Override
    public OwIterable<OwObject> getObjectIterable() {
        return this.objectIterable;
    }

    @Override
    public OwFieldManager getFieldManager() {
        return this.fieldManager;
    }

    @Override
    public void setFieldManager(OwFieldManager fieldmanager_p) {
        this.fieldManager = fieldmanager_p;
    }

    @Override
    public void setRefreshContext(OwClientRefreshContext refreshContext) {
        this.refreshContext = refreshContext;
    }

    @Override
    protected OwClientRefreshContext getRefreshContext() {
        return this.refreshContext;
    }

    @Override
    public void setColumnInfo(Collection<? extends OwFieldColumnInfo> columnInfo) {
        this.columnInfo = columnInfo;
    }

    @Override
    public Collection<? extends OwFieldColumnInfo> getColumnInfo() {
        return this.columnInfo;
    }

    @Override
    public void setSort(OwSort sort) {
        this.sort = sort;
    }

    @Override
    public OwSort getSort() {
        return this.sort;
    }

    @Override
    public Collection<String> getRetrievalPropertyNames() throws Exception {
        return null;
    }

    @Override
    public void onPageAbsolut(HttpServletRequest request_p) throws Exception {
        this.pageAbsolut(Integer.parseInt(request_p.getParameter("page")));
    }

    @Override
    public void onPageNext(HttpServletRequest request_p) throws Exception {
        this.setCurrentPage(this.getCurrentPage() + 1);
    }

    @Override
    public void onPagePrev(HttpServletRequest request_p) throws Exception {
        this.setCurrentPage(this.getCurrentPage() - 1);
    }

    @Override
    public int getPageCount() {
        if (this.getObjectList() == null && this.getObjectIterable() == null) {
            return 1;
        }
        int count = this.getCount();
        if (count < 0) {
            return -1;
        }
        int pageSize = this.getPageSize();
        if (pageSize > 0) {
            int modulo = count % pageSize;
            int pageCount = count / pageSize;
            if (modulo != 0 || pageCount == 0 && count != 0) {
                return pageCount + 1;
            }
            return pageCount;
        }
        return 0;
    }

    @Override
    public int getCurrentPage() {
        if (this.isShowMaximized()) {
            return 0;
        }
        int pageCount = this.getPageCount();
        if (this.currentPage >= pageCount && pageCount >= 0) {
            this.currentPage = pageCount - 1;
            this.page = null;
        }
        if (this.currentPage < 0) {
            this.currentPage = 0;
            this.page = null;
        }
        return this.currentPage;
    }

    @Override
    public boolean canPagePrev() {
        if (this.getCount() >= 0) {
            return this.getCurrentPage() == 0 ? false : this.getCurrentPage() < this.getPageCount();
        }
        return this.getCurrentPage() != 0;
    }

    @Override
    public boolean canPageNext() {
        int pageCount = this.getPageCount();
        if (pageCount < 0) {
            return this.getDisplayedPage().getHasMoreItems();
        }
        return pageCount > 1 ? this.getCurrentPage() < pageCount - 1 : false;
    }

    @Override
    protected boolean isPagingEnabled() {
        int pageCount = this.getPageCount();
        return pageCount > 1 || pageCount < 0;
    }

    @Override
    public String getPagePrevEventURL() {
        return this.getEventURL("PagePrev", null);
    }

    @Override
    public String getPageNextEventURL() {
        return this.getEventURL("PageNext", null);
    }

    @Override
    public String getPageAbsolutEventURL(String aditionalParameters_p) {
        return this.getEventURL("PageAbsolut", aditionalParameters_p);
    }

    @Override
    protected void pageAbsolut(int currentPage) {
        int pageCount = this.getPageCount();
        if (currentPage < 0 || currentPage > pageCount && pageCount > 0) {
            throw new IllegalArgumentException("Page index out of bound: " + currentPage);
        }
        if (currentPage != this.currentPage) {
            this.page = null;
        }
        this.currentPage = pageCount == 0 ? 0 : currentPage;
    }

    public OwIterable<OwObject> getDisplayedPage() {
        if (this.page == null) {
            OwIterable<OwObject> root = this.getObjectList() != null ? new OwObjectCollectionIterableAdapter<OwObject>(this.getObjectList()) : this.getObjectIterable();
            if (root != null) {
                int idxPage = this.getCurrentPage();
                int pageSize = this.getPageSize();
                this.page = root.skipTo(idxPage * pageSize).getPage(pageSize);
            } else {
                this.page = new OwEmptyIterable<OwObject>();
            }
        }
        return this.page;
    }

    public boolean isCollectionComplete() {
        Object complete = null;
        try {
            complete = this.getDisplayedPage().getAttribute("ow_complete");
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"Could not identify attribute IS_COMPLETE returning true", (Throwable)e);
            }
            LOG.warn((Object)"OwPageableLIstView.isComplete: Could not identify attribute IS_COMPLETE returning true");
        }
        if (complete == null) {
            return true;
        }
        return Boolean.valueOf("" + complete);
    }

    public int getPageSize() {
        if (this.isShowMaximized()) {
            return this.getCount();
        }
        return ((OwMainAppContext)this.getContext()).getPageSizeForLists();
    }

    @Override
    public void onClientRefreshContextUpdate(int iReason_p, Object param_p) throws Exception {
        this.page = null;
    }
}

