/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwDocument;
import org.apache.log4j.Logger;

public class OwPermissionsDocument
extends OwDocument {
    private static final Logger LOG = OwLogCore.getLogger(OwPermissionsDocument.class);
    private OwPermissionCollection permissions;
    private OwObject object;

    private static OwPermissionCollection fetchPermissions(OwObject object_p) throws OwException {
        try {
            return object_p.getPermissions();
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Could not retrieve perimissions.", (Throwable)e);
        }
    }

    public OwPermissionsDocument(OwObject object_p) throws OwException {
        this(object_p, OwPermissionsDocument.fetchPermissions(object_p));
    }

    public OwPermissionsDocument(OwObject object_p, OwPermissionCollection permissions_p) {
        this.object = object_p;
        this.permissions = permissions_p;
    }

    public void savePermissions() throws OwException {
        try {
            this.object.setPermissions(this.permissions);
        }
        catch (OwException e) {
            LOG.error((Object)"Could not save permissions.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not save permissions.", (Throwable)e);
            throw new OwInvalidOperationException("Could not retrieve perimissions.", (Throwable)e);
        }
        finally {
            try {
                this.permissions = OwPermissionsDocument.fetchPermissions(this.object);
            }
            catch (OwException e) {
                LOG.error((Object)"Could not reload permissions.", (Throwable)e);
                throw e;
            }
        }
    }

    public OwObject getObject() {
        return this.object;
    }

    public OwPermissionCollection getPermissions() {
        return this.permissions;
    }
}

