/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwUserSelectDialog;
import com.wewebu.ow.server.dmsdialogs.views.OwPrivilegeSetEditorDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwPrivilegesDocument;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class OwPrivilegeSetEditor
extends OwView
implements OwDialog.OwDialogListener {
    private static final int RECENT_LIST_MAX_SIZE = 25;
    public static final String PRIVILEGES_PARAMETER = "sp";
    private List<String> recentRoleNames = new ArrayList<String>();
    private OwUserSelectDialog dlgRole;
    private OwDialog dialog;

    public OwPrivilegeSetEditor(OwPrivilegesDocument privilegesDocument_p, OwDialog dialog_p) {
        OwPrivilegeSetEditorDocument document = new OwPrivilegeSetEditorDocument(privilegesDocument_p);
        this.setDocument(document);
        this.dialog = dialog_p;
    }

    @Override
    public OwPrivilegeSetEditorDocument getDocument() {
        return (OwPrivilegeSetEditorDocument)super.getDocument();
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwPrivilegeSetEditor.jsp", w_p);
    }

    public List<String> getRecentRoleNames() {
        return this.recentRoleNames;
    }

    public void onChangeToRecentRole(HttpServletRequest request_p) throws Exception {
        int recentId = -1;
        try {
            recentId = Integer.parseInt(request_p.getParameter("recentRoleId"));
        }
        catch (Exception e) {
            return;
        }
        if (recentId >= 0 && recentId < this.recentRoleNames.size()) {
            String recentRoleName = this.recentRoleNames.get(recentId);
            this.recentRoleNames.remove(recentRoleName);
            this.recentRoleNames.add(recentRoleName);
            while (this.recentRoleNames.size() > 25) {
                this.recentRoleNames.remove(0);
            }
            OwPrivilegeSetEditorDocument document = this.getDocument();
            document.setCurrentRole(recentRoleName);
        }
    }

    public void onOpenRoleDialog(HttpServletRequest request_p) throws Exception {
        this.dlgRole = this.createOwUserSelectDialog(new int[]{3}, false);
        this.getContext().openDialog(this.dlgRole, this);
    }

    protected OwUserSelectDialog createOwUserSelectDialog(int[] filter, boolean multiSelect) throws OwException {
        return new OwUserSelectDialog(filter, multiSelect);
    }

    @Override
    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        String selRole;
        List roles = ((OwUserSelectDialog)dialogView_p).getSelectedRoles();
        if (roles != null && (selRole = (String)roles.get(0)) != null) {
            this.recentRoleNames.remove(selRole);
            this.recentRoleNames.add(selRole);
            while (this.recentRoleNames.size() > 25) {
                this.recentRoleNames.remove(0);
            }
            OwPrivilegeSetEditorDocument document = this.getDocument();
            document.setCurrentRole(selRole);
        }
        this.dlgRole = null;
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    public void onAddPrivilege(HttpServletRequest request_p) throws Exception {
        String[] guids = request_p.getParameterValues(PRIVILEGES_PARAMETER);
        if (guids != null) {
            OwPrivilegeSetEditorDocument document = this.getDocument();
            String[] privileges = new String[guids.length];
            for (int i = 0; i < guids.length; ++i) {
                privileges[i] = OwPrivilegesDocument.guidToPrivilege(guids[i]);
            }
            document.setAddedPrivileges(privileges);
        }
        if (this.dialog != null) {
            this.dialog.closeDialog();
        }
    }
}

