/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.dmsdialogs.views.OwAddPrivilegeDialog;
import com.wewebu.ow.server.dmsdialogs.views.OwPermissionsDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwPrivilegesDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwUIGenericAccessRightsModul;
import com.wewebu.ow.server.ecm.OwPrivilege;
import com.wewebu.ow.server.ecm.OwPrivilegeSet;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwPrivilegesView
extends OwView
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLogCore.getLogger(OwPrivilegesView.class);
    public static final String PRIVILEGES_PARAM = "pv";
    private boolean m_readonly = false;
    private String message;
    private boolean liveUpdate;

    public OwPrivilegesView(OwUIGenericAccessRightsModul accessRightsView_p, boolean forceLiveUpdate_p) {
        this(accessRightsView_p, Collections.EMPTY_MAP, forceLiveUpdate_p);
    }

    public OwPrivilegesView(OwUIGenericAccessRightsModul accessRightsView_p, Map<String, String> privilegeDisplayNames_p, boolean forceLiveUpdate_p) {
        OwPermissionsDocument permissionsDocument = accessRightsView_p.getDocument();
        OwPrivilegesDocument doc = this.createPrivilegesDocument(permissionsDocument, privilegeDisplayNames_p);
        if (doc != null) {
            this.setDocument(doc);
        }
        this.liveUpdate = forceLiveUpdate_p;
    }

    protected OwPrivilegesDocument createPrivilegesDocument(OwPermissionsDocument permissionsDocument_p, Map<String, String> privilegeDisplayNames_p) {
        return new OwPrivilegesDocument(permissionsDocument_p, privilegeDisplayNames_p);
    }

    @Override
    protected void init() throws Exception {
        super.init();
    }

    @Override
    public OwPrivilegesDocument getDocument() {
        return (OwPrivilegesDocument)super.getDocument();
    }

    public void onSave(HttpServletRequest request_p, Object reason_p) throws OwException {
    }

    public final void setReadOnly(boolean readOnly_p) {
        this.m_readonly = readOnly_p;
    }

    public boolean isReadOnly() {
        return this.m_readonly;
    }

    public void setMessage(String message_p) {
        this.message = message_p;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        super.onRender(w_p);
        this.serverSideDesignInclude("OwPrivilegesView.jsp", w_p);
    }

    public void onRemovePrivileges(HttpServletRequest request_p) throws Exception {
        String[] removedPrivilegesParams = request_p.getParameterValues(PRIVILEGES_PARAM);
        if (removedPrivilegesParams != null) {
            OwPrivilegesDocument document = this.getDocument();
            Collection<OwPrivilegeSet> appliedPrivilegesSets = document.getAppliedPrivilegeSets();
            LinkedList<OwPrivilegeSet> removedPrivilegeSets = new LinkedList<OwPrivilegeSet>();
            for (String privilegeParam : removedPrivilegesParams) {
                int splitIndex = privilegeParam.indexOf("_P");
                String guids = privilegeParam.substring(0, splitIndex);
                String principal = privilegeParam.substring(splitIndex + 2);
                String[] guidArray = guids.split("_");
                LinkedList<String> removedPrivileges = new LinkedList<String>();
                for (String guid : guidArray) {
                    removedPrivileges.add(OwPrivilegesDocument.guidToPrivilege(guid));
                }
                for (OwPrivilegeSet appliedSet : appliedPrivilegesSets) {
                    OwUserInfo appliedPrincipal = appliedSet.getPrincipal();
                    if (!appliedPrincipal.getUserName().equals(principal)) continue;
                    Collection appliedPrivileges = appliedSet.getPrivileges();
                    LinkedList<String> appliedNames = new LinkedList<String>();
                    for (OwPrivilege privilege : appliedPrivileges) {
                        appliedNames.add(privilege.getName());
                    }
                    if (appliedNames.size() != removedPrivileges.size() || !appliedNames.containsAll(removedPrivileges)) continue;
                    removedPrivilegeSets.add(appliedSet);
                }
            }
            for (OwPrivilegeSet removedSet : removedPrivilegeSets) {
                document.removePrivilegeSet(removedSet);
            }
        }
    }

    public void onOpenAddDialog(HttpServletRequest request_p) throws OwException {
        OwAddPrivilegeDialog addPrivilegeDialog = this.createAddPrivilegeDialog();
        try {
            this.getContext().openDialog(addPrivilegeDialog, this);
        }
        catch (OwException owEx) {
            throw owEx;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not open privilege dialog.", (Throwable)e);
            throw new OwServerException(this.getContext().localize("OwPrivilegesView.openAddDialog.error", "Could not open add privilege dialog."), (Throwable)e);
        }
    }

    protected OwAddPrivilegeDialog createAddPrivilegeDialog() throws OwException {
        return new OwAddPrivilegeDialog(this);
    }

    @Override
    public void onDialogClose(OwDialog dialogView_p) throws Exception {
    }

    public boolean liveUpdate() {
        return this.liveUpdate;
    }
}

