/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewRow;
import com.wewebu.ow.server.dmsdialogs.views.OwSplitObjectListDocument;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import java.io.Writer;
import java.util.Collection;
import java.util.List;

public class OwSplitObjectListView
extends OwLayout {
    private OwObjectListView[] objectListViews;

    public OwSplitObjectListView(String[] splitNames, Collection<OwFieldColumnInfo>[] columnInfos, List<OwDocumentFunction> documentFunctions) {
        this(new OwSplitObjectListDocument(splitNames, columnInfos, documentFunctions));
    }

    public OwSplitObjectListView(OwSplitObjectListDocument document) {
        if (document != null) {
            this.setDocument(document);
        }
    }

    @Override
    protected void init() throws Exception {
        super.init();
        OwSplitObjectListDocument document = this.getDocument();
        int splitCount = document.getSplitCount();
        this.objectListViews = new OwObjectListView[splitCount];
        for (int i = 0; i < splitCount; ++i) {
            this.objectListViews[i] = this.createObjectListView(document.getColumnInfos()[i]);
            this.addView(this.objectListViews[i], i, null);
            this.objectListViews[i].setExternalFormTarget(this.getExternalFormEventTarget());
        }
    }

    public int getSplitCount() {
        return this.getDocument().getSplitCount();
    }

    public boolean displaySplitName(int index) {
        return this.getDocument().getSplitName(index) != "";
    }

    public String getSplitName(int index) {
        return this.getDocument().getSplitName(index);
    }

    protected OwObjectListView createObjectListView(Collection<OwFieldColumnInfo> viewColumnInfos) {
        OwObjectListViewRow objectListView = new OwObjectListViewRow(0);
        objectListView.setViewMask(69);
        objectListView.setColumnInfo(viewColumnInfos);
        objectListView.setSort(new OwSort());
        if (this.getDocument().getDocumentFunctions() != null) {
            objectListView.setDocumentFunctionPluginList(this.getDocument().getDocumentFunctions());
        }
        return objectListView;
    }

    @Override
    public OwSplitObjectListDocument getDocument() {
        return (OwSplitObjectListDocument)super.getDocument();
    }

    @Override
    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        OwSplitObjectListDocument document = this.getDocument();
        for (int i = 0; i < this.objectListViews.length; ++i) {
            this.objectListViews[i].setObjectList(document.getSplit(i), null);
        }
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwSplitObjectListView.jsp", w_p);
    }
}

